/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.filecache;

import com.lightcrafts.utils.filecache.FileCache;
import com.lightcrafts.utils.filecache.LocalFileCacheKeyMapper;
import com.lightcrafts.utils.filecache.PerUserFileCacheKeyMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.prefs.Preferences;

public class FileCacheFactory {
    public static final long MaxSize = 0x140000000L;
    private static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/utils/filecache");
    private static final String ScopeKey = "CacheScope";
    private static FileCache GlobalInstance;
    private static HashMap<File, FileCache> LocalInstances;

    public static synchronized FileCache get(File file) {
        boolean local = Prefs.getBoolean(ScopeKey, false);
        if (!local) {
            return FileCacheFactory.getGlobalCache();
        }
        return FileCacheFactory.getLocalCache(file);
    }

    public static FileCache getGlobalCache() {
        if (GlobalInstance == null) {
            try {
                PerUserFileCacheKeyMapper mapper = PerUserFileCacheKeyMapper.create();
                GlobalInstance = new FileCache(0x140000000L, mapper);
            }
            catch (IOException e) {
                System.err.print("Couldn't create FileCache: ");
                System.err.println(e.getMessage());
            }
        }
        return GlobalInstance;
    }

    public static FileCache getLocalCache(File file) {
        FileCache cache;
        if (file.isFile()) {
            file = file.getParentFile();
        }
        if ((cache = LocalInstances.get(file = new File(file, "LightZone Previews"))) != null) {
            return cache;
        }
        try {
            LocalFileCacheKeyMapper mapper = LocalFileCacheKeyMapper.create(file);
            if (mapper != null) {
                cache = new FileCache(0x140000000L, mapper);
                LocalInstances.put(file, cache);
                return cache;
            }
            System.err.print("Couldn't create LocalFileCacheKeyMapper");
            return null;
        }
        catch (IOException e) {
            System.err.print("Couldn't create FileCache: ");
            System.err.println(e.getMessage());
            return null;
        }
    }

    static {
        LocalInstances = new HashMap();
    }
}

