/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.filecache;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.utils.Version;
import com.lightcrafts.utils.filecache.FileCacheKeyMapper;
import java.io.File;
import java.io.IOException;

public final class PerUserFileCacheKeyMapper
implements FileCacheKeyMapper {
    private static final PerUserFileCacheKeyMapper INSTANCE = new PerUserFileCacheKeyMapper();
    private static final File m_cacheDir;
    private static boolean m_createSucceeded;

    public static PerUserFileCacheKeyMapper create() throws IOException {
        if (!m_createSucceeded) {
            throw new IOException("User file cache create failed.");
        }
        return INSTANCE;
    }

    @Override
    public File getCacheDirectory() {
        return m_cacheDir;
    }

    @Override
    public File mapKeyToFile(String key, boolean ensurePathExists) {
        File keyAsFile = new File(key);
        String dirOfFile = keyAsFile.getParent();
        if (dirOfFile == null) {
            dirOfFile = System.getProperty("user.dir");
        }
        String subdirName = Integer.toHexString(dirOfFile.hashCode());
        File subdir = new File(m_cacheDir, subdirName);
        if (ensurePathExists) {
            subdir.mkdir();
        }
        return new File(subdir, keyAsFile.getName() + ".lzc");
    }

    private PerUserFileCacheKeyMapper() {
    }

    static {
        String dir = Platform.getType() == Platform.MacOSX ? "Library/Caches/" + Version.getApplicationName() : (Platform.getType() == Platform.Windows ? "Application Data\\" + Version.getApplicationName() + "\\Caches" : ".lzncache");
        m_cacheDir = new File(System.getProperty("user.home"), dir);
        m_createSucceeded = m_cacheDir.exists() || m_cacheDir.mkdirs();
    }
}

