/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.xml;

import com.lightcrafts.utils.xml.XmlNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlDocument {
    private static DocumentBuilder Builder;
    private static TransformerFactory Transformers;
    private Document doc;
    private XmlNode root;
    private Transformer xform;

    public XmlDocument(String name) {
        this.doc = XmlDocument.createDocument();
        this.xform = XmlDocument.createTransformer();
        Element e = this.doc.createElement(name);
        this.doc.appendChild(e);
        this.root = new XmlNode(e);
    }

    public XmlDocument(String uri, String name) {
        this(name);
        this.root.setAttribute("xmlns", uri);
    }

    public XmlDocument(Document doc) {
        this.doc = doc;
        this.xform = XmlDocument.createTransformer();
        this.root = new XmlNode(doc.getDocumentElement());
    }

    public XmlDocument(InputStream in) throws IOException {
        this.doc = XmlDocument.createDocument();
        this.xform = XmlDocument.createTransformer();
        this.read(in);
        Element e = this.doc.getDocumentElement();
        this.root = new XmlNode(e);
    }

    public XmlDocument(Element e) {
        e = (Element)e.cloneNode(true);
        this.doc = XmlDocument.createDocument();
        e = (Element)this.doc.importNode(e, true);
        this.doc.appendChild(e);
        this.xform = XmlDocument.createTransformer();
        this.root = new XmlNode(e);
    }

    public XmlDocument(XmlDocument xml) {
        this.doc = (Document)xml.doc.cloneNode(true);
        this.xform = XmlDocument.createTransformer();
        Element e = this.doc.getDocumentElement();
        this.root = new XmlNode(e);
    }

    public XmlNode getRoot() {
        return this.root;
    }

    public void write(OutputStream out) throws IOException {
        DOMSource source = new DOMSource(this.doc);
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        StreamResult result = new StreamResult(writer);
        try {
            this.xform.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException("Couldn't write XML: " + e.getMessage());
        }
    }

    private void read(InputStream in) throws IOException {
        StreamSource source = new StreamSource(in);
        DOMResult result = new DOMResult(this.doc);
        Transformer xform = XmlDocument.createTransformer();
        try {
            xform.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException("Couldn't read XML: " + e.getMessage());
        }
    }

    private static Document createDocument() {
        return Builder.newDocument();
    }

    private static Transformer createTransformer() {
        Transformer xform = null;
        try {
            xform = Transformers.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        xform.setOutputProperty("indent", "yes");
        xform.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        xform.setOutputProperty("omit-xml-declaration", "yes");
        return xform;
    }

    public static void main(String[] args) throws IOException {
        int i;
        InputStream in = XmlDocument.class.getResourceAsStream("XmlDocument.class");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        do {
            if ((i = in.read()) < 0) continue;
            bytes.write(i);
        } while (i >= 0);
        byte[] inBytes = bytes.toByteArray();
        XmlDocument doc = new XmlDocument("namespace", "root");
        XmlNode root = doc.getRoot();
        XmlNode child = root.addChild("child");
        child.setAttribute("attribute", "value");
        child.setData(inBytes);
        doc.write(System.out);
        byte[] outBytes = child.getData();
        if (Arrays.equals(inBytes, outBytes)) {
            System.out.println("CDATA match");
        } else {
            System.out.println("CDATA differ");
        }
    }

    static {
        try {
            Builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Couldn't init XML builder", e);
        }
        try {
            Transformers = TransformerFactory.newInstance();
            if (System.getProperty("java.version").startsWith("1.5")) {
                Transformers.setAttribute("indent-number", "2");
            }
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException("Couldn't init XML transformer", e);
        }
    }
}

