/*
 * Decompiled with CFR 0.152.
 */
package tilecachetool;

import com.lightcrafts.jai.utils.LCTileCache;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tilecachetool.Statistics;

public final class TCInfo
extends JPanel
implements ChangeListener {
    private JSlider memoryCapacitySlider;
    private JSlider memoryThresholdSlider;
    private JLabel memoryCapacityLabel;
    private JLabel memoryThresholdLabel;
    private LCTileCache cache = null;
    private Statistics statistics;
    private float memoryUsage;
    private float memoryCapacity;
    private int percentTCM;
    private static final Color BACKGROUND = new Color(180, 180, 220);
    private static final Color LIGHT_BLUE = new Color(200, 200, 230);
    private static final BevelBorder BEVEL_BORDER = new BevelBorder(1);

    public TCInfo() {
        this.setLayout(new FlowLayout(0, 10, 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.setBackground(LIGHT_BLUE);
        this.memoryCapacityLabel = new JLabel("16 MB");
        this.memoryCapacityLabel.setBackground(LIGHT_BLUE);
        this.memoryCapacityLabel.setForeground(Color.black);
        p1.add((Component)this.memoryCapacityLabel, "North");
        this.memoryCapacitySlider = new JSlider(1, 0, 128, 16);
        this.memoryCapacitySlider.setBorder(BEVEL_BORDER);
        this.memoryCapacitySlider.createStandardLabels(64, 0);
        this.memoryCapacitySlider.setBackground(BACKGROUND);
        this.memoryCapacitySlider.setForeground(Color.black);
        this.memoryCapacitySlider.setPaintLabels(true);
        this.memoryCapacitySlider.setPaintTicks(true);
        this.memoryCapacitySlider.setMajorTickSpacing(32);
        this.memoryCapacitySlider.setMinorTickSpacing(8);
        this.memoryCapacitySlider.setSnapToTicks(false);
        this.memoryCapacitySlider.addChangeListener(this);
        p1.add(this.memoryCapacitySlider);
        this.add(p1);
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        p2.setBackground(LIGHT_BLUE);
        this.memoryThresholdLabel = new JLabel("75%");
        this.memoryThresholdLabel.setBackground(LIGHT_BLUE);
        this.memoryThresholdLabel.setForeground(Color.black);
        p2.add((Component)this.memoryThresholdLabel, "North");
        this.memoryThresholdSlider = new JSlider(1, 0, 100, 75);
        this.memoryThresholdSlider.setBorder(BEVEL_BORDER);
        Hashtable<Integer, JLabel> mt_labels = new Hashtable<Integer, JLabel>();
        for (int j = 0; j <= 100; j += 10) {
            JLabel label = new JLabel(j + "%");
            label.setForeground(Color.black);
            mt_labels.put(new Integer(j), label);
        }
        this.memoryThresholdSlider.setBackground(BACKGROUND);
        this.memoryThresholdSlider.setForeground(Color.black);
        this.memoryThresholdSlider.setPaintLabels(true);
        this.memoryThresholdSlider.setLabelTable(mt_labels);
        this.memoryThresholdSlider.setPaintTicks(true);
        this.memoryThresholdSlider.setMajorTickSpacing(10);
        this.memoryThresholdSlider.setMinorTickSpacing(5);
        this.memoryThresholdSlider.setSnapToTicks(true);
        this.memoryThresholdSlider.addChangeListener(this);
        p2.add(this.memoryThresholdSlider);
        this.add(p2);
    }

    public void setTileCache(LCTileCache c) {
        if (c == null) {
            throw new IllegalArgumentException("cache cannot be null.");
        }
        if (!(c instanceof LCTileCache)) {
            throw new IllegalArgumentException("cache not an instance of SunTileCache");
        }
        this.cache = c;
        this.memoryCapacitySlider.setValue((int)(this.cache.getMemoryCapacity() / 0x100000L));
        this.memoryThresholdSlider.setValue((int)(100.0f * this.cache.getMemoryThreshold()));
    }

    public void setStatistics(Statistics stats) {
        this.statistics = stats;
    }

    public void setMemoryCapacitySliderMaximum(int max_mem) {
        if ((long)max_mem <= 0L) {
            throw new IllegalArgumentException("max_mem must be greater than 0");
        }
        int mem_cap = (int)(this.cache.getMemoryCapacity() / 0x100000L);
        if (max_mem < mem_cap) {
            max_mem = mem_cap;
        }
        this.memoryCapacitySlider.setMaximum(max_mem);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider slider = (JSlider)e.getSource();
        if (slider == this.memoryCapacitySlider) {
            this.memoryCapacityLabel.setText(slider.getValue() + " MB");
            this.cache.setMemoryCapacity((long)slider.getValue() * 1024L * 1024L);
            if (this.statistics != null) {
                this.memoryCapacity = this.cache.getMemoryCapacity();
                this.memoryUsage = this.cache.getCacheMemoryUsed();
                this.percentTCM = (int)(100.0f * this.memoryUsage / this.memoryCapacity + 0.5f);
                this.statistics.set(this.percentTCM);
            }
        } else if (slider == this.memoryThresholdSlider) {
            this.memoryThresholdLabel.setText(slider.getValue() + "%");
            this.cache.setMemoryThreshold((float)slider.getValue() / 100.0f);
        }
    }
}

