/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.viewer;

import com.sun.deploy.perf.DeployPerfUtil;
import com.sun.deploy.services.ServiceManager;
import java.applet.Applet;
import java.awt.EventQueue;
import java.awt.Frame;
import sun.applet.AppletEvent;
import sun.applet.AppletListener;
import sun.applet.AppletPanel;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.plugin.AppletViewer;
import sun.plugin.BeansViewer;
import sun.plugin.com.DispatchImpl;
import sun.plugin.services.BrowserService;
import sun.plugin.util.NotifierObject;
import sun.plugin.viewer.IExplorerAppletStatusListener;
import sun.plugin.viewer.LifeCycleManager;
import sun.plugin.viewer.context.IExplorerAppletContext;
import sun.plugin.viewer.context.PluginAppletContext;
import sun.plugin.viewer.frame.IExplorerEmbeddedFrame;

public class IExplorerPluginObject
implements AppletListener {
    protected IExplorerAppletStatusListener ieasl = null;
    protected IExplorerEmbeddedFrame frame = null;
    protected AppletViewer panel = null;
    protected int id = -1;
    private int width = 0;
    private int height = 0;
    private String identifier = null;
    boolean bFrameReady = false;
    boolean bContainerReady = false;
    boolean bInit = false;

    IExplorerPluginObject(int n, boolean bl, String string) {
        this.id = n;
        this.identifier = string;
        if (!bl) {
            PluginAppletContext pluginAppletContext;
            this.panel = LifeCycleManager.getAppletPanel(string);
            if (this.panel == null) {
                this.panel = new AppletViewer();
                this.panel.addAppletListener(this);
            }
            if ((pluginAppletContext = (PluginAppletContext)this.panel.getAppletContext()) == null) {
                BrowserService browserService = (BrowserService)ServiceManager.getService();
                pluginAppletContext = browserService.getAppletContext();
            }
            pluginAppletContext.setAppletContextHandle(n);
            this.panel.setAppletContext(pluginAppletContext);
        } else if (this.panel == null) {
            this.panel = new BeansViewer();
        }
    }

    public static native void pumpKillFocusMessages();

    public static void waitForNotification(NotifierObject notifierObject, long l) {
        long l2 = System.currentTimeMillis();
        while (!notifierObject.getNotified() && System.currentTimeMillis() - l2 < l) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IExplorerPluginObject.pumpKillFocusMessages();
        }
    }

    public IExplorerEmbeddedFrame createFrame(final int n) {
        DeployPerfUtil.put((String)"START - Java   - ENV - create embedded browser frame (IE)");
        final NotifierObject notifierObject = new NotifierObject();
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    IExplorerPluginObject.this.frame = new IExplorerEmbeddedFrame(n, IExplorerPluginObject.this);
                }
                finally {
                    notifierObject.setNotified();
                }
            }
        });
        IExplorerPluginObject.waitForNotification(notifierObject, 5000L);
        if (!notifierObject.getNotified()) {
            throw new RuntimeException("Error while creating embedded frame");
        }
        Applet applet = this.panel.getApplet();
        if (applet != null) {
            AppletPanel.changeFrameAppContext((Frame)((Object)this.frame), (AppContext)SunToolkit.targetToAppContext(applet));
        }
        this.frame.setBean(this.panel);
        this.ieasl = new IExplorerAppletStatusListener(this.id);
        this.ieasl.setEmbeddedFrame(this.frame);
        DeployPerfUtil.put((String)"END   - Java   - ENV - create embedded browser frame (IE)");
        return this.frame;
    }

    private synchronized void initPlugin() {
        assert (this.panel != null);
        this.panel.addAppletStatusListener(this.ieasl);
        LifeCycleManager.checkLifeCycle(this.panel);
        new Initer(this.panel, this).start();
    }

    public void destroyPlugin() {
        assert (this.panel != null);
        if (this.bInit) {
            PluginAppletContext pluginAppletContext = (PluginAppletContext)this.panel.getAppletContext();
            LifeCycleManager.stopAppletPanel(this.panel);
            this.panel.readyToQuit = false;
            LifeCycleManager.destroyAppletPanel(this.identifier, this.panel);
            this.panel.removeAppletStatusListener(null);
            ((IExplorerAppletContext)pluginAppletContext).onClose();
            if (pluginAppletContext != null) {
                pluginAppletContext.setAppletContextHandle(0);
            }
        }
    }

    public void mayInit() {
        if (this.bFrameReady && this.bContainerReady && !this.bInit) {
            this.bInit = true;
            this.initPlugin();
        }
    }

    public void containerReady() {
        this.bContainerReady = true;
        this.mayInit();
    }

    public void frameReady() {
        this.bFrameReady = true;
        this.mayInit();
    }

    public void preRefresh() {
        if (this.panel != null) {
            this.panel.preRefresh();
        }
    }

    public AppletViewer getPanel() {
        return this.panel;
    }

    protected Frame getFrame() {
        return this.frame;
    }

    void setFocus() {
        if (this.frame != null) {
            this.frame.synthesizeWindowActivation(true);
        }
    }

    void setFrameSize(int n, int n2) {
        if (this.frame != null) {
            this.frame.setFrameSize(n, n2);
        }
    }

    public Object getJavaObject() {
        Object object = null;
        if (this.panel != null) {
            object = this.panel.getViewedObject();
        }
        return object;
    }

    public Object getDispatchObject() {
        return new DispatchImpl(this.getJavaObject(), this.id);
    }

    int getLoadingStatus() {
        if (this.panel != null) {
            return this.panel.getLoadingStatus();
        }
        return 7;
    }

    public String getParameter(String string) {
        assert (this.panel != null);
        return this.panel.getParameter(string);
    }

    public void setParameter(String string, Object object) {
        assert (this.panel != null);
        this.panel.setParameter(string, object);
    }

    public void setBoxColors() {
        this.panel.setColorAndText();
    }

    public void appletStateChanged(AppletEvent appletEvent) {
        AppletPanel appletPanel = (AppletPanel)appletEvent.getSource();
        switch (appletEvent.getID()) {
            case 51236: {
                if (this.frame == null) break;
                Applet applet = appletPanel.getApplet();
                if (applet != null) {
                    AppletPanel.changeFrameAppContext((Frame)((Object)this.frame), (AppContext)SunToolkit.targetToAppContext(applet));
                    break;
                }
                AppletPanel.changeFrameAppContext((Frame)((Object)this.frame), (AppContext)AppContext.getAppContext());
            }
        }
    }

    private class Initer
    extends Thread {
        AppletViewer that;
        IExplorerPluginObject obj;

        Initer(AppletViewer appletViewer, IExplorerPluginObject iExplorerPluginObject2) {
            this.that = appletViewer;
            this.obj = iExplorerPluginObject2;
        }

        public void run() {
            LifeCycleManager.initAppletPanel(this.that);
            LifeCycleManager.startAppletPanel(this.that);
        }
    }
}

