/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform.windows;

import com.lightcrafts.image.types.ImageType;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public final class WindowsFileUtil {
    public static final int FOLDER_APPDATA = 26;
    public static final int FOLDER_DESKTOP = 16;
    public static final int FOLDER_MY_DOCUMENTS = 5;
    public static final int FOLDER_MY_PICTURES = 39;

    public static native String getFolderPathOf(int var0);

    public static native void hideFile(String var0) throws IOException;

    public static boolean isGUID(File file) {
        return file.getName().startsWith("::{");
    }

    public static boolean isShortcut(String path) {
        return path.endsWith(".lnk");
    }

    public static native boolean moveToRecycleBin(String[] var0);

    public static String openFile(String initialDir) throws IOException {
        Collection types = ImageType.getAllTypes();
        String[] displayStrings = new String[types.size() + 1];
        String[][] extensions = new String[types.size() + 1][];
        displayStrings[0] = "All files";
        extensions[0] = new String[]{"*"};
        int i = 0;
        for (ImageType t : types) {
            displayStrings[++i] = t.getName();
            extensions[i] = t.getExtensions();
        }
        return WindowsFileUtil.openFile(initialDir, displayStrings, extensions);
    }

    public static String openFile(String initialDir, String[] displayStrings, String[][] extensions) throws IOException {
        if (displayStrings.length != extensions.length) {
            throw new IllegalArgumentException();
        }
        String[] patterns = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            patterns[i] = "";
            boolean seperator = false;
            for (String extension : extensions[i]) {
                if (seperator) {
                    int n = i;
                    patterns[n] = patterns[n] + ';';
                } else {
                    seperator = true;
                }
                int n = i;
                patterns[n] = patterns[n] + "*." + extension;
            }
        }
        return WindowsFileUtil.openFile(initialDir, displayStrings, patterns);
    }

    public static String resolveShortcut(String path) {
        return WindowsFileUtil.isShortcut(path) ? WindowsFileUtil.resolveShortcutImpl(path) : path;
    }

    public static boolean showInExplorer(String path) {
        try {
            Runtime.getRuntime().exec("explorer /select, " + path);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static native String openFile(String var0, String[] var1, String[] var2) throws IOException;

    private static native String resolveShortcutImpl(String var0);

    static {
        System.loadLibrary("Windows");
    }
}

