/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform.windows;

import com.lightcrafts.platform.FileChooser;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.platform.PrinterLayer;
import com.lightcrafts.platform.windows.WindowsColorProfileManager;
import com.lightcrafts.platform.windows.WindowsFileUtil;
import com.lightcrafts.platform.windows.WindowsHelp;
import com.lightcrafts.platform.windows.WindowsInternetConnection;
import com.lightcrafts.platform.windows.WindowsKeyUtil;
import com.lightcrafts.platform.windows.WindowsLauncher;
import com.lightcrafts.platform.windows.WindowsMemory;
import com.lightcrafts.platform.windows.WindowsPrinterLayer;
import com.lightcrafts.platform.windows.WindowsSavedSearch;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.utils.ColorProfileInfo;
import com.lightcrafts.utils.Version;
import com.lightcrafts.utils.directory.DirectoryMonitor;
import com.lightcrafts.utils.directory.WindowsDirectoryMonitor;
import com.lightcrafts.utils.file.FileUtil;
import com.lightcrafts.utils.file.ICC_ProfileFileFilter;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.color.ICC_Profile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public final class WindowsPlatform
extends Platform {
    private PrinterLayer printerLayer = new WindowsPrinterLayer();
    private static List<ColorProfileInfo> m_profiles;

    public File getDefaultImageDirectory() {
        String path = WindowsFileUtil.getFolderPathOf(39);
        return path != null ? new File(path) : null;
    }

    public DirectoryMonitor getDirectoryMonitor() {
        return new WindowsDirectoryMonitor();
    }

    public ICC_Profile getDisplayProfile() {
        String path = WindowsColorProfileManager.getSystemDisplayProfilePath();
        if (path == null) {
            return null;
        }
        try {
            InputStream in = new File(path).toURL().openStream();
            ICC_Profile profile = ICC_Profile.getInstance(in);
            System.out.println("Display profile " + ColorProfileInfo.getNameOf((ICC_Profile)profile));
            return profile;
        }
        catch (IOException e) {
            return null;
        }
    }

    public Collection<ColorProfileInfo> getExportProfiles() {
        return WindowsPlatform.getColorProfiles();
    }

    public FileChooser getFileChooser() {
        return super.getFileChooser();
    }

    public String getDisplayNameOf(File file) {
        String displayName = file instanceof ShellFolder ? ((ShellFolder)file).getDisplayName() : this.getFileSystemView().getSystemDisplayName(file);
        if (displayName.endsWith(".lnk")) {
            displayName = FileUtil.trimExtensionOf((String)displayName);
        }
        return displayName;
    }

    public File getLightZoneDocumentsDirectory() {
        File myDocuments = FileSystemView.getFileSystemView().getDefaultDirectory();
        return new File(myDocuments, Version.getApplicationName());
    }

    public LookAndFeel getLookAndFeel() {
        LookAndFeel laf = LightZoneSkin.getLightZoneLookAndFeel();
        boolean addWindows = false;
        if (addWindows) {
            WindowsLookAndFeel quaqua = new WindowsLookAndFeel();
            UIDefaults quaquaDefaults = quaqua.getDefaults();
            Set quaquaKeys = quaquaDefaults.keySet();
            String[] fromQuaqua = new String[]{"FileChooser"};
            block0: for (Object key : quaquaKeys) {
                for (String qk : fromQuaqua) {
                    if (!(key instanceof String) || !((String)key).startsWith(qk)) continue;
                    Object value = quaquaDefaults.get(key);
                    UIManager.put(key, value);
                    continue block0;
                }
            }
        }
        return laf;
    }

    public String[] getPathComponentsToPicturesFolder() {
        File picturesDir = Platform.getPlatform().getDefaultImageDirectory();
        if (picturesDir == null) {
            return null;
        }
        String[] picturesComponents = picturesDir.toString().split("\\\\");
        if (picturesComponents.length != 5) {
            return null;
        }
        String[] wantedComponents = new String[2];
        System.arraycopy(picturesComponents, 3, wantedComponents, 0, 2);
        return wantedComponents;
    }

    public int getPhysicalMemoryInMB() {
        return WindowsMemory.getPhysicalMemoryInMB();
    }

    public Collection<ColorProfileInfo> getPrinterProfiles() {
        return WindowsPlatform.getColorProfiles();
    }

    public boolean hasInternetConnectionTo(String hostName) {
        return WindowsInternetConnection.hasConnection();
    }

    public void hideFile(File file) throws IOException {
        WindowsFileUtil.hideFile(file.getAbsolutePath());
    }

    public boolean isKeyPressed(int keyCode) {
        return WindowsKeyUtil.isKeyPressed(keyCode);
    }

    public File isSpecialFile(File file) {
        if (!((file = FileUtil.resolveAliasFile((File)file)) instanceof WindowsSavedSearch) && WindowsSavedSearch.isSavedSearch(file)) {
            return new WindowsSavedSearch(file);
        }
        if (WindowsPlatform.isVista()) {
            return this.isSpecialFileOnVista(file);
        }
        return file;
    }

    public static boolean isVista() {
        return System.getProperty("os.name").endsWith("Vista");
    }

    public void loadLibraries() throws UnsatisfiedLinkError {
        System.loadLibrary("Windows");
    }

    public boolean moveFilesToTrash(String[] pathNames) {
        return WindowsFileUtil.moveToRecycleBin(pathNames);
    }

    public void readyToOpenFiles() {
        if (System.getProperty("IDE") == null) {
            WindowsLauncher.readyToOpenFiles();
        }
    }

    public String resolveAliasFile(File file) {
        return WindowsFileUtil.resolveShortcut(file.getAbsolutePath());
    }

    public boolean showFileInFolder(String path) {
        return WindowsFileUtil.showInExplorer(path);
    }

    public void showHelpTopic(String topic) {
        WindowsHelp.showHelpTopic(topic);
    }

    public PrinterLayer getPrinterLayer() {
        return this.printerLayer;
    }

    private static synchronized Collection<ColorProfileInfo> getColorProfiles() {
        File[] files;
        File profileDir;
        if (m_profiles != null) {
            return m_profiles;
        }
        m_profiles = new ArrayList<ColorProfileInfo>();
        String windir = System.getenv("WINDIR");
        if (windir == null) {
            windir = "C:\\WINDOWS";
        }
        if (!(profileDir = new File(windir + "\\system32\\spool\\drivers\\color")).isDirectory()) {
            return m_profiles;
        }
        for (File file : files = profileDir.listFiles((FileFilter)ICC_ProfileFileFilter.INSTANCE)) {
            String path = file.getAbsolutePath();
            try {
                ICC_Profile profile = ICC_Profile.getInstance(path);
                String name = ColorProfileInfo.getNameOf((ICC_Profile)profile);
                m_profiles.add(new ColorProfileInfo(name, path));
            }
            catch (IOException e) {
                System.err.println("Can't read a color profile from " + path + ": " + e.getMessage());
            }
            catch (Throwable t) {
                System.err.println("Bad color profile at " + path + ": " + t.getMessage());
            }
        }
        Collections.sort(m_profiles);
        return m_profiles;
    }

    private File isSpecialFileOnVista(File file) {
        String displayName = this.getDisplayNameOf(file);
        if (!displayName.equals(System.getProperty("user.name"))) {
            return file;
        }
        File parentDir = file.getParentFile();
        if (parentDir == null) {
            return file;
        }
        if (parentDir.getName().equals("Desktop")) {
            return new File(System.getProperty("user.home"));
        }
        return file;
    }
}

