/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform.windows;

import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.utils.thread.ProgressThread;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;

public final class WindowsPrintManager {
    public static native void dispose();

    public static native PageFormat getPageFormat();

    public static native Dimension getPrinterResolution();

    public static native void initDefaultPrinter();

    public static synchronized void print(PlanarImage image, Point offset, String documentName, ProgressThread thread) throws PrinterException {
        if (!WindowsPrintManager.isPrinterCapable()) {
            Platform.getPlatform().getAlertDialog().showAlert(null, "Incapable Printer", "The selected printer can not be used with LightZone.", 2, new String[]{"OK"});
            return;
        }
        thread.getProgressIndicator().setMaximum(image.getMaxTileX() * image.getMaxTileY());
        WindowsPrintManager.beginPrinting(documentName, 24);
        WindowsPrintManager.beginPage();
        for (int tileX = 0; tileX <= image.getMaxTileX(); ++tileX) {
            for (int tileY = 0; tileY <= image.getMaxTileY(); ++tileY) {
                if (thread.isCanceled()) {
                    WindowsPrintManager.abortPrinting();
                    return;
                }
                Raster tile = image.getTile(tileX, tileY);
                Rectangle tileBounds = tile.getBounds();
                Rectangle clippedTileBounds = tile.getBounds().intersection(image.getBounds());
                BufferedImage tileImage = new BufferedImage(image.getColorModel(), (WritableRaster)tile.createTranslatedChild(0, 0), false, null);
                BufferedImage winImage = new BufferedImage(clippedTileBounds.width, clippedTileBounds.height, 5);
                Graphics2D g2d = winImage.createGraphics();
                g2d.drawImage(tileImage, null, 0, 0);
                g2d.dispose();
                tile = winImage.getRaster().createTranslatedChild((int)tileBounds.getMinX(), (int)tileBounds.getMinY());
                DataBufferByte dbb = (DataBufferByte)tile.getDataBuffer();
                WindowsPrintManager.printTile((int)tileBounds.getMinX() + offset.x, (int)tileBounds.getMinY() + offset.y, winImage.getWidth(), winImage.getHeight(), dbb.getData());
                thread.getProgressIndicator().incrementBy(1);
            }
        }
        WindowsPrintManager.endPage();
        WindowsPrintManager.endPrinting();
    }

    public static void setPageFormat(PageFormat format) {
        Paper paper = format.getPaper();
        WindowsPrintManager.setPageFormat(paper.getWidth(), paper.getHeight(), paper.getImageableX(), paper.getImageableY(), paper.getImageableWidth(), paper.getImageableHeight(), format.getOrientation());
    }

    public static native boolean showPageSetupDialog(Frame var0);

    public static native boolean showPrintDialog(Frame var0);

    protected void finalize() throws Throwable {
        WindowsPrintManager.dispose();
        super.finalize();
    }

    private static native void abortPrinting();

    private static native void beginPage() throws PrinterException;

    private static native void beginPrinting(String var0, int var1) throws PrinterException;

    private static native void endPage() throws PrinterException;

    private static native void endPrinting() throws PrinterException;

    private static native boolean isPrinterCapable();

    private static native void printTile(int var0, int var1, int var2, int var3, byte[] var4) throws PrinterException;

    private static native void setPageFormat(double var0, double var2, double var4, double var6, double var8, double var10, int var12);

    public static void main(String[] args) throws Exception {
        WindowsPrintManager.showPageSetupDialog(null);
        PageFormat pf = WindowsPrintManager.getPageFormat();
        WindowsPrintManager.dumpPage(pf);
        System.exit(0);
    }

    public static void dumpPage(PageFormat pageFormat) {
        System.out.println("page area: w=" + pageFormat.getWidth() + ", h=" + pageFormat.getHeight() + ", orientation=" + (pageFormat.getOrientation() == 0 ? "landscape" : "portrait"));
        System.out.println("imageable area: x=" + pageFormat.getImageableX() + ", y=" + pageFormat.getImageableY() + ", w=" + pageFormat.getImageableWidth() + ", h=" + pageFormat.getImageableHeight());
    }

    static {
        System.loadLibrary("Windows");
    }
}

