/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform.windows;

import com.lightcrafts.utils.file.SmartFolder;
import java.io.File;
import java.util.ArrayList;

public final class WindowsSavedSearch
extends SmartFolder {
    public WindowsSavedSearch(String pathname) {
        super(pathname);
    }

    public WindowsSavedSearch(File file) {
        super(file.getAbsolutePath());
    }

    public WindowsSavedSearch(File parent, String child) {
        super(parent, child);
    }

    public WindowsSavedSearch(String parent, String child) {
        super(parent, child);
    }

    public boolean isDirectory() {
        return this.isSmartFolder() || super.isDirectory();
    }

    public boolean isFile() {
        return !this.isSmartFolder() && super.isFile();
    }

    public boolean isSmartFolder() {
        return WindowsSavedSearch.isSavedSearch((File)((Object)this));
    }

    public static boolean isSavedSearch(File path) {
        return WindowsSavedSearch.isSavedSearch(path.getName());
    }

    public static boolean isSavedSearch(String path) {
        return path.endsWith(".search-ms");
    }

    public String[] list() {
        return this.isSmartFolder() ? this.savedSearch(this.getAbsolutePath()) : super.list();
    }

    public File[] listFiles() {
        if (!this.isSmartFolder()) {
            return super.listFiles();
        }
        String[] contents = this.savedSearch(this.getAbsolutePath());
        File[] files = new File[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            files[i] = new File(contents[i]);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] savedSearch(String savedSearchPathname) {
        long nativePtr = WindowsSavedSearch.beginSearch(savedSearchPathname);
        if (nativePtr == 0L) {
            return null;
        }
        try {
            String next;
            ArrayList<String> contents = new ArrayList<String>();
            while ((next = WindowsSavedSearch.getNextResult(nativePtr)) != null) {
                contents.add(next);
            }
            String[] stringArray = contents.toArray(new String[0]);
            return stringArray;
        }
        finally {
            WindowsSavedSearch.endSearch(nativePtr);
        }
    }

    private static native long beginSearch(String var0);

    private static native void endSearch(long var0);

    private static native String getNextResult(long var0);

    public static void main(String[] args) {
        WindowsSavedSearch savedSearch = new WindowsSavedSearch(args[0]);
        String[] contents = savedSearch.list();
        if (contents != null) {
            for (String file : contents) {
                System.out.println(file);
            }
        }
    }

    static {
        System.loadLibrary("Windows");
    }
}

