/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.codecimpl;

import com.lightcrafts.media.jai.codec.ImageCodec;
import com.lightcrafts.media.jai.codec.ImageDecodeParam;
import com.lightcrafts.media.jai.codec.ImageDecoder;
import com.lightcrafts.media.jai.codec.ImageEncodeParam;
import com.lightcrafts.media.jai.codec.ImageEncoder;
import com.lightcrafts.media.jai.codec.JPEGDecodeParam;
import com.lightcrafts.media.jai.codec.JPEGEncodeParam;
import com.lightcrafts.media.jai.codec.SeekableStream;
import com.lightcrafts.media.jai.codecimpl.JPEGImageDecoder;
import com.lightcrafts.media.jai.codecimpl.JPEGImageEncoder;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class JPEGCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "jpeg";
    }

    @Override
    public Class getEncodeParamClass() {
        return JPEGEncodeParam.class;
    }

    @Override
    public Class getDecodeParamClass() {
        return JPEGDecodeParam.class;
    }

    @Override
    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        return true;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        JPEGEncodeParam p = null;
        if (param != null) {
            p = (JPEGEncodeParam)param;
        }
        return new JPEGImageEncoder(dst, p);
    }

    @Override
    protected ImageDecoder createImageDecoder(InputStream src, ImageDecodeParam param) {
        return new JPEGImageDecoder(src, param);
    }

    @Override
    protected ImageDecoder createImageDecoder(File src, ImageDecodeParam param) throws IOException {
        return new JPEGImageDecoder(new FileInputStream(src), param);
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        return new JPEGImageDecoder((InputStream)src, param);
    }

    @Override
    public int getNumHeaderBytes() {
        return 3;
    }

    @Override
    public boolean isFormatRecognized(byte[] header) {
        return header[0] == -1 && header[1] == -40 && header[2] == -1;
    }
}

