/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.codecimpl;

import com.lightcrafts.media.jai.codec.ForwardSeekableStream;
import com.lightcrafts.media.jai.codec.ImageCodec;
import com.lightcrafts.media.jai.codec.ImageDecodeParam;
import com.lightcrafts.media.jai.codec.ImageDecoder;
import com.lightcrafts.media.jai.codec.ImageEncodeParam;
import com.lightcrafts.media.jai.codec.ImageEncoder;
import com.lightcrafts.media.jai.codec.PNMEncodeParam;
import com.lightcrafts.media.jai.codec.SeekableStream;
import com.lightcrafts.media.jai.codecimpl.PNMImageDecoder;
import com.lightcrafts.media.jai.codecimpl.PNMImageEncoder;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class PNMCodec
extends ImageCodec {
    @Override
    public String getFormatName() {
        return "pnm";
    }

    @Override
    public Class getEncodeParamClass() {
        return PNMEncodeParam.class;
    }

    @Override
    public Class getDecodeParamClass() {
        return Object.class;
    }

    @Override
    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        SampleModel sampleModel = im.getSampleModel();
        int dataType = sampleModel.getTransferType();
        if (dataType == 4 || dataType == 5) {
            return false;
        }
        int numBands = sampleModel.getNumBands();
        return numBands == 1 || numBands == 3;
    }

    @Override
    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        PNMEncodeParam p = null;
        if (param != null) {
            p = (PNMEncodeParam)param;
        }
        return new PNMImageEncoder(dst, p);
    }

    @Override
    protected ImageDecoder createImageDecoder(InputStream src, ImageDecodeParam param) {
        if (!(src instanceof BufferedInputStream)) {
            src = new BufferedInputStream(src);
        }
        return new PNMImageDecoder(new ForwardSeekableStream(src), null);
    }

    @Override
    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        return new PNMImageDecoder(src, null);
    }

    @Override
    public int getNumHeaderBytes() {
        return 2;
    }

    @Override
    public boolean isFormatRecognized(byte[] header) {
        return header[0] == 80 && header[1] >= 49 && header[1] <= 54;
    }
}

