/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.mlib;

import com.lightcrafts.media.jai.mlib.FFTmediaLib;
import com.lightcrafts.media.jai.mlib.MediaLibAccessor;
import com.lightcrafts.media.jai.mlib.MlibDFTOpImage;
import com.lightcrafts.media.jai.opimage.DFTOpImage;
import com.lightcrafts.media.jai.opimage.RIFUtil;
import com.lightcrafts.media.jai.util.MathJAI;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.EnumeratedParameter;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.operator.DFTDescriptor;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;

public class MlibIDFTRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock args, RenderingHints hints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint(hints);
        if (!MediaLibAccessor.isMediaLibCompatible(new ParameterBlock())) {
            return null;
        }
        RenderedImage source = args.getRenderedSource(0);
        EnumeratedParameter scalingType = (EnumeratedParameter)args.getObjectParameter(0);
        EnumeratedParameter dataNature = (EnumeratedParameter)args.getObjectParameter(1);
        boolean isComplexSource = !dataNature.equals(DFTDescriptor.REAL_TO_COMPLEX);
        int numSourceBands = source.getSampleModel().getNumBands();
        if ((isComplexSource && numSourceBands == 2 || !isComplexSource && numSourceBands == 1) && MlibDFTOpImage.isAcceptableSampleModel(source.getSampleModel())) {
            int sourceWidth = source.getWidth();
            int sourceHeight = source.getHeight();
            if (!MathJAI.isPositivePowerOf2(sourceWidth) || !MathJAI.isPositivePowerOf2(sourceHeight)) {
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(source);
                pb.add(0);
                pb.add(MathJAI.nextPositivePowerOf2(sourceWidth) - sourceWidth);
                pb.add(0);
                pb.add(MathJAI.nextPositivePowerOf2(sourceHeight) - sourceHeight);
                pb.add(BorderExtender.createInstance(0));
                source = JAI.create("border", pb);
            }
            return new MlibDFTOpImage(source, hints, layout, dataNature, false, scalingType);
        }
        FFTmediaLib fft = new FFTmediaLib(false, new Integer(scalingType.getValue()), 2);
        return new DFTOpImage(source, hints, layout, dataNature, fft);
    }
}

