/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.mlib;

import com.lightcrafts.media.jai.mlib.JaiI18N;
import com.lightcrafts.media.jai.mlib.MediaLibAccessor;
import com.lightcrafts.mediax.jai.AreaOpImage;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.operator.MaxFilterDescriptor;
import com.lightcrafts.mediax.jai.operator.MaxFilterShape;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

final class MlibMaxFilterOpImage
extends AreaOpImage {
    protected int maskType;
    protected int maskSize;

    public MlibMaxFilterOpImage(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, MaxFilterShape maskType, int maskSize) {
        super(source, layout, config, true, extender, (maskSize - 1) / 2, (maskSize - 1) / 2, maskSize / 2, maskSize / 2);
        this.maskType = MlibMaxFilterOpImage.mapToMlibMaskType(maskType);
        this.maskSize = maskSize;
    }

    private static int mapToMlibMaskType(MaxFilterShape maskType) {
        if (maskType.equals(MaxFilterDescriptor.MAX_MASK_SQUARE)) {
            return 0;
        }
        if (maskType.equals(MaxFilterDescriptor.MAX_MASK_PLUS)) {
            return 1;
        }
        if (maskType.equals(MaxFilterDescriptor.MAX_MASK_X)) {
            return 2;
        }
        if (maskType.equals(MaxFilterDescriptor.MAX_MASK_SQUARE_SEPARABLE)) {
            return 3;
        }
        throw new RuntimeException(JaiI18N.getString("MaxFilterOpImage0"));
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        int formatTag = MediaLibAccessor.findCompatibleTag(sources, dest);
        MediaLibAccessor srcAccessor = new MediaLibAccessor(source, srcRect, formatTag);
        MediaLibAccessor dstAccessor = new MediaLibAccessor(dest, destRect, formatTag);
        int numBands = this.getSampleModel().getNumBands();
        int cmask = (1 << numBands) - 1;
        mediaLibImage[] srcML = srcAccessor.getMediaLibImages();
        mediaLibImage[] dstML = dstAccessor.getMediaLibImages();
        block4: for (int i = 0; i < dstML.length; ++i) {
            switch (dstAccessor.getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (this.maskSize == 3) {
                        Image.MaxFilter3x3((mediaLibImage)dstML[i], (mediaLibImage)srcML[i]);
                        continue block4;
                    }
                    if (this.maskSize == 5) {
                        Image.MaxFilter5x5((mediaLibImage)dstML[i], (mediaLibImage)srcML[i]);
                        continue block4;
                    }
                    if (this.maskSize != 7) continue block4;
                    Image.MaxFilter7x7((mediaLibImage)dstML[i], (mediaLibImage)srcML[i]);
                    continue block4;
                }
                case 4: 
                case 5: {
                    if (this.maskSize == 3) {
                        Image.MaxFilter3x3_Fp((mediaLibImage)dstML[i], (mediaLibImage)srcML[i]);
                        continue block4;
                    }
                    if (this.maskSize == 5) {
                        Image.MaxFilter5x5_Fp((mediaLibImage)dstML[i], (mediaLibImage)srcML[i]);
                        continue block4;
                    }
                    if (this.maskSize != 7) continue block4;
                    Image.MaxFilter7x7_Fp((mediaLibImage)dstML[i], (mediaLibImage)srcML[i]);
                    continue block4;
                }
                default: {
                    String className = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("Generic2"));
                }
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.copyDataToRaster();
        }
    }
}

