/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.opimage;

import com.lightcrafts.media.jai.opimage.AffineBicubic2OpImage;
import com.lightcrafts.media.jai.opimage.AffineBicubicOpImage;
import com.lightcrafts.media.jai.opimage.AffineBilinearOpImage;
import com.lightcrafts.media.jai.opimage.AffineGeneralOpImage;
import com.lightcrafts.media.jai.opimage.AffineNearestBinaryOpImage;
import com.lightcrafts.media.jai.opimage.AffineNearestOpImage;
import com.lightcrafts.media.jai.opimage.RIFUtil;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.EnumeratedParameter;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.InterpolationBicubic;
import com.lightcrafts.mediax.jai.InterpolationBicubic2;
import com.lightcrafts.mediax.jai.InterpolationBilinear;
import com.lightcrafts.mediax.jai.InterpolationNearest;
import com.lightcrafts.mediax.jai.operator.ShearDescriptor;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;

public class ShearRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint(renderHints);
        BorderExtender extender = RIFUtil.getBorderExtenderHint(renderHints);
        RenderedImage source = paramBlock.getRenderedSource(0);
        float shear_amt = paramBlock.getFloatParameter(0);
        EnumeratedParameter shear_dir = (EnumeratedParameter)paramBlock.getObjectParameter(1);
        float xTrans = paramBlock.getFloatParameter(2);
        float yTrans = paramBlock.getFloatParameter(3);
        Object arg1 = paramBlock.getObjectParameter(4);
        Interpolation interp = (Interpolation)arg1;
        double[] backgroundValues = (double[])paramBlock.getObjectParameter(5);
        AffineTransform tr = new AffineTransform();
        if (shear_dir.equals(ShearDescriptor.SHEAR_HORIZONTAL)) {
            tr.setTransform(1.0, 0.0, shear_amt, 1.0, xTrans, 0.0);
        } else {
            tr.setTransform(1.0, shear_amt, 0.0, 1.0, 0.0, yTrans);
        }
        if (interp instanceof InterpolationNearest) {
            boolean isBinary;
            SampleModel sm = source.getSampleModel();
            boolean bl = isBinary = sm instanceof MultiPixelPackedSampleModel && sm.getSampleSize(0) == 1 && (sm.getDataType() == 0 || sm.getDataType() == 1 || sm.getDataType() == 3);
            if (isBinary) {
                return new AffineNearestBinaryOpImage(source, extender, (Map)renderHints, layout, tr, interp, backgroundValues);
            }
            return new AffineNearestOpImage(source, extender, (Map)renderHints, layout, tr, interp, backgroundValues);
        }
        if (interp instanceof InterpolationBilinear) {
            return new AffineBilinearOpImage(source, extender, (Map)renderHints, layout, tr, interp, backgroundValues);
        }
        if (interp instanceof InterpolationBicubic) {
            return new AffineBicubicOpImage(source, extender, (Map)renderHints, layout, tr, interp, backgroundValues);
        }
        if (interp instanceof InterpolationBicubic2) {
            return new AffineBicubic2OpImage(source, extender, (Map)renderHints, layout, tr, interp, backgroundValues);
        }
        return new AffineGeneralOpImage(source, extender, (Map)renderHints, layout, tr, interp, backgroundValues);
    }
}

