/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.test;

import com.lightcrafts.media.jai.opimage.PatternOpImage;
import com.lightcrafts.media.jai.test.RandomOpImage;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.OpImage;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RasterFactory;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.reflect.Method;
import java.util.Map;

public class OpImageTester {
    long start = 0L;
    long end = 0L;
    int width;
    int height;
    int bands;
    RenderedImage source;
    private static final int[] allDataTypes = new int[]{0, 1, 2, 3, 4, 5};
    private static final String[] dataTypeNames = new String[]{"BYTE  ", "USHORT", "SHORT ", "INT   ", "FLOAT ", "DOUBLE"};

    public OpImageTester(int width, int height, int bands, int dataType) {
        this.width = width;
        this.height = height;
        this.bands = bands;
        int tileWidth = width;
        int tileHeight = height;
        WritableRaster srcRaster = RasterFactory.createInterleavedRaster(dataType, tileWidth, tileHeight, bands, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[]{8, 8, 8};
        ComponentColorModel ccm = new ComponentColorModel(cs, bits, false, false, 1, 0);
        this.source = new PatternOpImage(srcRaster, ccm, 0, 0, width, height);
    }

    public OpImageTester(int width, int height, int bands) {
        this(width, height, bands, 0);
    }

    public RenderedImage getSource() {
        return this.source;
    }

    public Raster[] getSrcRasters() {
        Raster[] r = new Raster[]{this.source.getTile(0, 0)};
        return r;
    }

    public WritableRaster getDstRaster() {
        return RasterFactory.createInterleavedRaster(0, this.width, this.height, this.bands, null);
    }

    public Rectangle getDstRect() {
        return new Rectangle(0, 0, this.width, this.height);
    }

    public static OpImage createRandomOpImage(ImageLayout layout) {
        return new RandomOpImage(0, 0, 800, 800, RasterFactory.createPixelInterleavedSampleModel(0, 200, 200, 3), null, layout);
    }

    public static OpImage createRandomOpImage(Map configuration, ImageLayout layout) {
        return new RandomOpImage(0, 0, 800, 800, RasterFactory.createPixelInterleavedSampleModel(0, 200, 200, 3), configuration, layout);
    }

    public static ImageLayout createImageLayout(int minX, int minY, int width, int height, int tileX, int tileY, int tileWidth, int tileHeight, int dataType, int numBands, boolean isBanded) {
        SampleModel sampleModel = isBanded ? RasterFactory.createBandedSampleModel(dataType, tileWidth, tileHeight, numBands) : RasterFactory.createPixelInterleavedSampleModel(dataType, tileWidth, tileHeight, numBands);
        return new ImageLayout(minX, minY, width, height, tileX, tileY, tileWidth, tileHeight, sampleModel, OpImageTester.createComponentColorModel());
    }

    public static ComponentColorModel createComponentColorModel() {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[]{8, 8, 8};
        return new ComponentColorModel(cs, bits, false, false, 1, 0);
    }

    public static void printPixels(String message, PlanarImage image, Rectangle rect) {
        int[] pixels = image.getData(rect).getPixels(rect.x, rect.y, rect.width, rect.height, (int[])null);
        System.out.println(message + " x=" + rect.x + " y=" + rect.y + " width=" + rect.width + " height=" + rect.height);
        int j = 0;
        for (int h = 0; h < rect.height; ++h) {
            System.out.print("    ");
            for (int w = 0; w < rect.width; ++w) {
                System.out.print("( ");
                for (int b = 0; b < image.getSampleModel().getNumBands(); ++b) {
                    System.out.print(pixels[j] + " ");
                    ++j;
                }
                System.out.print(")");
            }
            System.out.println();
        }
    }

    public static void testOpImage(OpImage dst, Rectangle dstRect) {
        for (int i = 0; i < dst.getNumSources(); ++i) {
            PlanarImage src = dst.getSourceImage(i);
            Rectangle srcRect = dst.mapDestRect(dstRect, i);
            String message = "Source " + (i + 1) + ":";
            OpImageTester.printPixels(message, src, srcRect);
        }
        OpImageTester.printPixels("Dest:", dst, dstRect);
    }

    private static long benchmarkOpImage(OpImage img, int loop) {
        img.setTileCache(null);
        int minX = img.getMinTileX();
        int maxX = img.getMaxTileX();
        int minY = img.getMinTileY();
        int maxY = img.getMaxTileY();
        long total = 0L;
        for (int i = 0; i < loop; ++i) {
            for (int y = minY; y <= maxY; ++y) {
                for (int x = minX; x <= maxX; ++x) {
                    long start = System.currentTimeMillis();
                    img.getTile(x, y);
                    long end = System.currentTimeMillis();
                    int diff = (int)(end - start);
                    total += (long)diff;
                }
            }
        }
        return total;
    }

    public static long timeOpImage(OpImage img, int loops) {
        long total = OpImageTester.benchmarkOpImage(img, loops);
        int w = img.getWidth();
        int h = img.getHeight();
        SampleModel sm = img.getSampleModel();
        double time = (double)total / 1000.0;
        int width = img.getWidth();
        int height = img.getHeight();
        System.out.print("\tLoops : " + loops);
        System.out.print("\tTime : " + time);
        System.out.println("\tMpixels/sec : " + (double)loops / 1000000.0 * ((double)width * (double)height / time));
        return total;
    }

    public static void performDiagnostics(String classname, String[] args) {
        int[] dataTypes = allDataTypes;
        boolean verbose = false;
        int width = 512;
        int height = 512;
        int bands = 1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-fast")) {
                int[] dt = new int[]{0};
                dataTypes = dt;
                continue;
            }
            if (!args[i].equals("-verbose")) continue;
            verbose = true;
        }
        OpImageTester.runDiagnostics(classname, dataTypes, width, height, bands, verbose);
    }

    public static void runDiagnostics(String classname, int[] dataTypes, int width, int height, int bands, boolean verbose) {
        System.out.println("Performing Diagnostics for " + classname);
        for (int i = 0; i < dataTypes.length; ++i) {
            OpImageTester oit = new OpImageTester(512, 512, 1, dataTypes[i]);
            Class<?> clazz = null;
            Method createTestMethod = null;
            System.out.print(" Testing DataBuffer.TYPE_" + dataTypeNames[dataTypes[i]] + " ");
            System.out.println("  Size : " + width + "x" + height + " by " + bands + " bands");
            try {
                clazz = Class.forName(classname);
                Class[] params = new Class[]{Class.forName("com.lightcrafts.media.jai.opimage.OpImageTester")};
                createTestMethod = clazz.getMethod("createTestImage", params);
                Object[] methodArgs = new Object[]{oit};
                OpImage o = (OpImage)createTestMethod.invoke(null, methodArgs);
                long total = OpImageTester.benchmarkOpImage(o, 10);
                total = OpImageTester.benchmarkOpImage(o, 10);
                int loops = (int)(15000.0 / ((double)total / 10.0));
                OpImageTester.timeOpImage(o, loops);
                continue;
            }
            catch (Exception e) {
                if (verbose) {
                    e.printStackTrace();
                }
                System.err.println("\tException thrown");
            }
        }
        System.out.println("Finished Diagnostics\n");
    }
}

