/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.util;

import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.TileComputationListener;
import com.lightcrafts.mediax.jai.TileRequest;
import com.lightcrafts.mediax.jai.TileScheduler;
import java.awt.Point;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;

class Request
implements TileRequest {
    private final TileScheduler scheduler;
    final PlanarImage image;
    final List indices;
    final Set listeners;
    final Hashtable tileStatus;

    Request(TileScheduler scheduler, PlanarImage image, Point[] tileIndices, TileComputationListener[] tileListeners) {
        if (scheduler == null) {
            throw new IllegalArgumentException();
        }
        this.scheduler = scheduler;
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this.image = image;
        if (tileIndices == null || tileIndices.length == 0) {
            throw new IllegalArgumentException();
        }
        this.indices = Arrays.asList(tileIndices);
        if (tileListeners != null) {
            int numListeners = tileListeners.length;
            if (numListeners > 0) {
                this.listeners = new HashSet(numListeners);
                for (int i = 0; i < numListeners; ++i) {
                    this.listeners.add(tileListeners[i]);
                }
            } else {
                this.listeners = null;
            }
        } else {
            this.listeners = null;
        }
        this.tileStatus = new Hashtable(tileIndices.length);
    }

    @Override
    public PlanarImage getImage() {
        return this.image;
    }

    @Override
    public Point[] getTileIndices() {
        return this.indices.toArray(new Point[0]);
    }

    @Override
    public TileComputationListener[] getTileListeners() {
        return this.listeners.toArray(new TileComputationListener[0]);
    }

    @Override
    public boolean isStatusAvailable() {
        return true;
    }

    @Override
    public int getTileStatus(int tileX, int tileY) {
        Point p = new Point(tileX, tileY);
        int status = this.tileStatus.containsKey(p) ? (Integer)this.tileStatus.get(p) : 0;
        return status;
    }

    @Override
    public void cancelTiles(Point[] tileIndices) {
        this.scheduler.cancelTiles(this, tileIndices);
    }
}

