/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.mediax.jai;

import com.lightcrafts.media.jai.util.PropertyUtil;
import com.lightcrafts.mediax.jai.CollectionImageFactory;
import com.lightcrafts.mediax.jai.ImageJAI;
import com.lightcrafts.mediax.jai.JaiI18N;
import com.lightcrafts.mediax.jai.PropertyChangeSupportJAI;
import com.lightcrafts.mediax.jai.WritablePropertySourceImpl;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class CollectionImage
implements ImageJAI,
Collection {
    protected Collection imageCollection;
    protected CollectionImageFactory imageFactory;
    private Boolean isFactorySet = Boolean.FALSE;
    protected PropertyChangeSupportJAI eventManager = new PropertyChangeSupportJAI(this);
    protected WritablePropertySourceImpl properties = new WritablePropertySourceImpl(null, null, this.eventManager);
    protected Set sinks;

    protected CollectionImage() {
    }

    public CollectionImage(Collection collection) {
        this();
        if (collection == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.imageCollection = collection;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.imageCollection.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.imageCollection instanceof List) {
            return ((List)this.imageCollection).get(index);
        }
        return this.imageCollection.toArray((Object[])null)[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageFactory(CollectionImageFactory imageFactory) {
        Boolean bl = this.isFactorySet;
        synchronized (bl) {
            if (this.isFactorySet.booleanValue()) {
                throw new IllegalStateException();
            }
            this.imageFactory = imageFactory;
            this.isFactorySet = Boolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionImageFactory getImageFactory() {
        Boolean bl = this.isFactorySet;
        synchronized (bl) {
            return this.imageFactory;
        }
    }

    public synchronized boolean addSink(Object sink) {
        if (sink == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sinks == null) {
            this.sinks = new HashSet();
        }
        return this.sinks.add(new WeakReference<Object>(sink));
    }

    public synchronized boolean removeSink(Object sink) {
        if (sink == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sinks == null) {
            return false;
        }
        boolean result = false;
        Iterator it = this.sinks.iterator();
        while (it.hasNext()) {
            Object referent = ((WeakReference)it.next()).get();
            if (referent == sink) {
                it.remove();
                result = true;
                continue;
            }
            if (referent != null) continue;
            it.remove();
        }
        return result;
    }

    public synchronized Set getSinks() {
        HashSet v = null;
        if (this.sinks != null && this.sinks.size() > 0) {
            v = new HashSet(this.sinks.size());
            Iterator it = this.sinks.iterator();
            while (it.hasNext()) {
                Object o = ((WeakReference)it.next()).get();
                if (o == null) continue;
                v.add(o);
            }
            if (v.size() == 0) {
                v = null;
            }
        }
        return v;
    }

    public synchronized void removeSinks() {
        this.sinks = null;
    }

    @Override
    public String[] getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    @Override
    public String[] getPropertyNames(String prefix) {
        return PropertyUtil.getPropertyNames(this.getPropertyNames(), prefix);
    }

    @Override
    public Class getPropertyClass(String name) {
        return this.properties.getPropertyClass(name);
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public Object getProperty(String name, Collection collection) {
        return Image.UndefinedProperty;
    }

    @Override
    public void setProperty(String name, Object value) {
        this.properties.setProperty(name, value);
    }

    @Override
    public void removeProperty(String name) {
        this.properties.removeProperty(name);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.eventManager.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.eventManager.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.eventManager.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.eventManager.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public int size() {
        return this.imageCollection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.imageCollection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.imageCollection.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.imageCollection.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.imageCollection.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.imageCollection.toArray(a);
    }

    public boolean add(Object o) {
        return this.imageCollection.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.imageCollection.remove(o);
    }

    public boolean containsAll(Collection c) {
        return this.imageCollection.containsAll(c);
    }

    public boolean addAll(Collection c) {
        return this.imageCollection.addAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.imageCollection.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.imageCollection.retainAll(c);
    }

    @Override
    public void clear() {
        this.imageCollection.clear();
    }
}

