/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.mediax.jai.operator;

import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.OperationDescriptorImpl;
import com.lightcrafts.mediax.jai.ParameterBlockJAI;
import com.lightcrafts.mediax.jai.ParameterListDescriptor;
import com.lightcrafts.mediax.jai.RenderableOp;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.operator.JaiI18N;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.util.Collection;
import java.util.Iterator;

public class AddCollectionDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "AddCollection"}, {"LocalName", "AddCollection"}, {"Vendor", "com.lightcrafts.media.jai"}, {"Description", JaiI18N.getString("AddCollectionDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/AddCollectionDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}};
    private static final Class[][] sourceClasses = new Class[][]{{Collection.class}, {Collection.class}};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public AddCollectionDescriptor() {
        super(resources, supportedModes, null, sourceClasses, (ParameterListDescriptor)null);
    }

    @Override
    protected boolean validateSources(String modeName, ParameterBlock args, StringBuffer msg) {
        block5: {
            Iterator iter;
            block4: {
                if (!super.validateSources(modeName, args, msg)) {
                    return false;
                }
                Collection col = (Collection)args.getSource(0);
                if (col.size() < 2) {
                    msg.append(this.getName() + " " + JaiI18N.getString("AddCollectionDescriptor1"));
                    return false;
                }
                iter = col.iterator();
                if (!modeName.equalsIgnoreCase("rendered")) break block4;
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (o instanceof RenderedImage) continue;
                    msg.append(this.getName() + " " + JaiI18N.getString("AddCollectionDescriptor2"));
                    return false;
                }
                break block5;
            }
            if (!modeName.equalsIgnoreCase("renderable")) break block5;
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof RenderableImage) continue;
                msg.append(this.getName() + " " + JaiI18N.getString("AddCollectionDescriptor3"));
                return false;
            }
        }
        return true;
    }

    public static RenderedOp create(Collection source0, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("AddCollection", "rendered");
        pb.setSource("source0", source0);
        return JAI.create("AddCollection", pb, hints);
    }

    public static RenderableOp createRenderable(Collection source0, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("AddCollection", "renderable");
        pb.setSource("source0", source0);
        return JAI.createRenderable("AddCollection", pb, hints);
    }
}

