/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.mediax.jai.operator;

import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.OperationDescriptorImpl;
import com.lightcrafts.mediax.jai.ParameterBlockJAI;
import com.lightcrafts.mediax.jai.RenderableOp;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.operator.JaiI18N;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;

public class RescaleDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Rescale"}, {"LocalName", "Rescale"}, {"Vendor", "com.lightcrafts.media.jai"}, {"Description", JaiI18N.getString("RescaleDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/RescaleDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("RescaleDescriptor1")}, {"arg1Desc", JaiI18N.getString("RescaleDescriptor2")}};
    private static final Class[] paramClasses = new Class[]{double[].class, double[].class};
    private static final String[] paramNames = new String[]{"constants", "offsets"};
    private static final Object[] paramDefaults = new Object[]{new double[]{1.0}, new double[]{0.0}};

    public RescaleDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    @Override
    public boolean isRenderableSupported() {
        return true;
    }

    @Override
    protected boolean validateParameters(ParameterBlock args, StringBuffer msg) {
        if (!super.validateParameters(args, msg)) {
            return false;
        }
        int constantsLength = ((double[])args.getObjectParameter(0)).length;
        int offsetsLength = ((double[])args.getObjectParameter(1)).length;
        if (constantsLength < 1) {
            msg.append(this.getName() + " " + JaiI18N.getString("RescaleDescriptor3"));
            return false;
        }
        if (offsetsLength < 1) {
            msg.append(this.getName() + ": " + JaiI18N.getString("RescaleDescriptor4"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage source0, double[] constants, double[] offsets, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Rescale", "rendered");
        pb.setSource("source0", source0);
        pb.setParameter("constants", constants);
        pb.setParameter("offsets", offsets);
        return JAI.create("Rescale", pb, hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, double[] constants, double[] offsets, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Rescale", "renderable");
        pb.setSource("source0", source0);
        pb.setParameter("constants", constants);
        pb.setParameter("offsets", offsets);
        return JAI.createRenderable("Rescale", pb, hints);
    }
}

