/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.mediax.jai.tilecodec;

import com.lightcrafts.media.jai.tilecodec.TileCodecUtils;
import com.lightcrafts.mediax.jai.ParameterListDescriptor;
import com.lightcrafts.mediax.jai.tilecodec.JaiI18N;
import com.lightcrafts.mediax.jai.tilecodec.TileCodecDescriptor;
import com.lightcrafts.mediax.jai.tilecodec.TileCodecParameterList;
import com.lightcrafts.mediax.jai.tilecodec.TileEncoder;
import java.io.OutputStream;

public abstract class TileEncoderImpl
implements TileEncoder {
    protected String formatName;
    protected OutputStream outputStream;
    protected TileCodecParameterList paramList;

    public TileEncoderImpl(String formatName, OutputStream output, TileCodecParameterList param) {
        if (formatName == null) {
            throw new IllegalArgumentException(JaiI18N.getString("TileCodecDescriptorImpl0"));
        }
        if (output == null) {
            throw new IllegalArgumentException(JaiI18N.getString("TileEncoderImpl0"));
        }
        TileCodecDescriptor tcd = TileCodecUtils.getTileCodecDescriptor("tileEncoder", formatName);
        if (param == null) {
            param = tcd.getDefaultParameters("tileEncoder");
        }
        if (param != null) {
            if (!param.getFormatName().equalsIgnoreCase(formatName)) {
                throw new IllegalArgumentException(JaiI18N.getString("TileEncoderImpl1"));
            }
            if (!param.isValidForMode("tileEncoder")) {
                throw new IllegalArgumentException(JaiI18N.getString("TileEncoderImpl2"));
            }
            if (!param.getParameterListDescriptor().equals(tcd.getParameterListDescriptor("tileEncoder"))) {
                throw new IllegalArgumentException(JaiI18N.getString("TileCodec0"));
            }
        } else {
            ParameterListDescriptor pld = tcd.getParameterListDescriptor("tileEncoder");
            if (pld != null && pld.getNumParameters() != 0) {
                throw new IllegalArgumentException(JaiI18N.getString("TileDecoderImpl6"));
            }
        }
        this.formatName = formatName;
        this.outputStream = output;
        this.paramList = param;
    }

    @Override
    public String getFormatName() {
        return this.formatName;
    }

    @Override
    public TileCodecParameterList getEncodeParameterList() {
        return this.paramList;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }
}

