/*
 * Decompiled with CFR 0.152.
 */
package jdk1_6.sun.text.normalizer;

import java.text.CharacterIterator;
import jdk1_6.sun.text.normalizer.UCharacterIterator;

public class CharacterIteratorWrapper
extends UCharacterIterator {
    private CharacterIterator iterator;

    public CharacterIteratorWrapper(CharacterIterator iter) {
        if (iter == null) {
            throw new IllegalArgumentException();
        }
        this.iterator = iter;
    }

    @Override
    public int current() {
        char c = this.iterator.current();
        if (c == '\uffff') {
            return -1;
        }
        return c;
    }

    @Override
    public int getLength() {
        return this.iterator.getEndIndex() - this.iterator.getBeginIndex();
    }

    @Override
    public int getIndex() {
        return this.iterator.getIndex();
    }

    @Override
    public int next() {
        char i = this.iterator.current();
        this.iterator.next();
        if (i == '\uffff') {
            return -1;
        }
        return i;
    }

    @Override
    public int previous() {
        char i = this.iterator.previous();
        if (i == '\uffff') {
            return -1;
        }
        return i;
    }

    @Override
    public void setIndex(int index) {
        this.iterator.setIndex(index);
    }

    @Override
    public int getText(char[] fillIn, int offset) {
        int length = this.iterator.getEndIndex() - this.iterator.getBeginIndex();
        int currentIndex = this.iterator.getIndex();
        if (offset < 0 || offset + length > fillIn.length) {
            throw new IndexOutOfBoundsException(Integer.toString(length));
        }
        char ch = this.iterator.first();
        while (ch != '\uffff') {
            fillIn[offset++] = ch;
            ch = this.iterator.next();
        }
        this.iterator.setIndex(currentIndex);
        return length;
    }

    @Override
    public Object clone() {
        try {
            CharacterIteratorWrapper result = (CharacterIteratorWrapper)super.clone();
            result.iterator = (CharacterIterator)this.iterator.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

