from ScriptEngine import *
from globaldefine import *

#Skill script file version
Version = 1

class ShowClass:
	def __init__(self, display, layermanager, srcuin, dstuin):
		self.display = display
		self.layermanager = layermanager
		self.srcuin = srcuin
		self.dstuin = dstuin
		self.gameobjectid = GAMEOBJECTID_AVATAR
		self.skillsource = None
		self.skilldest = []
		self.onskillsourceend = self.OnSkillSourceEnd
		self.onskilldestend = self.OnSkillDestEnd
		self.onsize = self.OnSize		
		
		self.destPlayerInfo = None
	
		self.SrcImageFile = None
		self.DstGGImageFile = None
		self.DstMMImageFile = None
		
	def Run(self):
		RegisterEvent(self, GAMEEVENTID_ONSIZE, self.onsize)
		self.SrcAvatarInfo = GetObjectInfoByID(self.srcuin, self.gameobjectid)
		self.DstAvatarInfo = GetObjectInfoByID(self.dstuin[0], self.gameobjectid)
		self.destPlayerInfo = GetPlayerInfo(self.dstuin[0])
		
		if self.SrcAvatarInfo != None:
			self.skillsource = Image(self,self.display,self.layermanager)
			self.SetSkillParam()
			self.PlaySkill()	
		
	def OnSize(self):	
		self.SrcAvatarInfo = GetObjectInfoByID(self.srcuin, self.gameobjectid)
		if self.SrcAvatarInfo != None:
			self.ChangePosition(self.skillsource, self.SrcAvatarInfo)	
		i = 0
		for dstskill in self.skilldest:
			DstAvatarInfo = GetObjectInfoByID(self.dstuin[i], self.gameobjectid)
			if DstAvatarInfo != None:
				self.ChangePosition(dstskill, DstAvatarInfo)	
			i = i + 1

	def ChangePosition(self, image, AvatarInfo):
		if image != None:
			image.ChangePosition(AvatarInfo["X"], AvatarInfo["Y"])
		
	def PlaySkill(self):
		self.skillsource.LoadImage(self.SrcImageFile)
		self.skillsource.DrawImageAbove(self.SrcAvatarInfo["X"], self.SrcAvatarInfo["Y"],  GAMEOBJECTID_FOREGROUND, 1)
		self.skillsource.OnRelatedFrame = self.onskillsourceend
		HideObjectByID(self.srcuin, GAMEOBJECTID_AVATAR)	
		
	def OnSkillSourceEnd(self):
		self.BePresentFlower()	
	
	def BePresentFlower(self):
		skilldest = None
		if len(self.dstuin) == 0:
			self.OnSkillDestEnd()
		for dst in self.dstuin:
			
			if self.destPlayerInfo != None:
				skilldest = Image(self,self.display,self.layermanager)
				if self.destPlayerInfo["IsMale"] == 1:
					skilldest.LoadImage(self.DstGGImageFile)
				else:
					skilldest.LoadImage(self.DstMMImageFile)
				DstAvatarInfo = GetObjectInfoByID(dst, self.gameobjectid)
				skilldest.DrawImageAbove(self.DstAvatarInfo["X"], self.DstAvatarInfo["Y"],  GAMEOBJECTID_FOREGROUND, 1)
				skilldest.OnDelayEvent = self.onskilldestend			
				HideObjectByID(dst, GAMEOBJECTID_AVATAR)		
				self.skilldest.append(skilldest)
		
	def OnSkillDestEnd(self):
		ShowObjectByID(self.srcuin, GAMEOBJECTID_AVATAR)
		for dst in self.dstuin:
			ShowObjectByID(dst, GAMEOBJECTID_AVATAR)
		ExitScript(self)
		
	#Set skill item show related file (eg: image file , sound file)
	def SetSkillParam(self):
		self.SrcImageFile 	= "item\\10017_1.mif"
		self.DstGGImageFile = "item\\10017_2.mif"
		self.DstMMImageFile = "item\\10017_3.mif"
		
