from ScriptEngine import *
from globaldefine import *
#--------------------------------------------------------------
class UserBase:
	def __init__(self, display, layermanager, selfuin, dstuin):
		self.display = display
		self.layermanager = layermanager
		
		self.selfuin = selfuin
		self.x = 0
		self.y = 0
		
		self.onchangeelement = self.OnChangeElement
		self.onsize = self.OnSize
		self.layerdist = {}
		self.changelayerdist = {}
		self.elementid = []
		
	def Run(self):
		self.SelfAvatarInfo = GetObjectInfoByID(self.selfuin, GAMEOBJECTID_AVATAR)		
		if self.SelfAvatarInfo != None:
			self.x = self.SelfAvatarInfo['X']
			self.y = self.SelfAvatarInfo['Y']
			
			RegisterEvent(self, 101, self.onchangeelement)
			RegisterEvent(self, GAMEEVENTID_ONSIZE, self.onsize)
			self.InitBodyElement() ##
		
	def OnSize(self):
		self.SelfAvatarInfo = GetObjectInfoByID(self.selfuin, GAMEOBJECTID_AVATAR)	
		if self.SelfAvatarInfo != None:
			self.x = self.SelfAvatarInfo['X']
			self.y = self.SelfAvatarInfo['Y']
			keys = self.layerdist.keys()
			for i in keys:
				self.layerdist[i].ChangePosition(self.x, self.y)
			
	def OnChangeElement(self, isadd, layerid, filepath):
		if isadd:
			if layerid in self.layerdist:	
				self.layerdist[layerid].EraseImage()
				self.layerdist[layerid].ReleaseImage(self)
				del self.layerdist[layerid]
					
			newlayer = Image(self, self.display, self.layermanager)
			newlayer.LoadImage(filepath)
			newlayer.DrawImageAbove(self.x, self.y, layerid, 0)
			self.layerdist[layerid] = newlayer			
			
		else:
			if layerid in self.layerdist:
				self.layerdist[layerid].EraseImage()
				self.layerdist[layerid].ReleaseImage(self)
				del self.layerdist[layerid]
				
	def ShowBackGroundLayer(self):
		if self.layerdist.has_key(0):
			self.layerdist[0].DrawImageAbove(self.x, self.y, 0, 0)
		if self.layerdist.has_key(10):
			self.layerdist[10].DrawImageAbove(self.x, self.y, 10, 0)
		if self.layerdist.has_key(20):
			self.layerdist[20].DrawImageAbove(self.x, self.y, 20, 0)
		
	def ShowServiceLayers(self):
		layerid = 170
		while layerid < 270:
			if self.layerdist.has_key(layerid):
				self.layerdist[layerid].DrawImageAbove(self.x, self.y, layerid, 0)
			layerid = layerid + 1
		
	def HideBackGroundLayer(self):
		if self.layerdist.has_key(0):
			self.layerdist[0].EraseImage()		
		if self.layerdist.has_key(10):
			self.layerdist[10].EraseImage()		
		if self.layerdist.has_key(20):
			self.layerdist[20].EraseImage()		
		
	def HideServiceLayers(self):
		layerid = 170
		while layerid < 270:
			if self.layerdist.has_key(layerid):
				self.layerdist[layerid].EraseImage()		
			layerid = layerid + 1
								
	def AddLayer(self, elementid, layerid, filepath):
		newlayer = Image(self, self.display, self.layermanager)
		if filepath != "":
			newlayer.LoadImage(filepath)
			newlayer.DrawImageAbove(self.x, self.y, layerid, 0)		
		if elementid not in self.elementid:
			self.elementid.append(elementid)	
		return newlayer		
		
	def GetElementList(self):
		return self.elementid
