@echo off

title CPU Broadwell Microcode

cls
set guid=17088572-377F-44EF-8F4E-B09FFF46A070
set mpdtbn=mpdt\mpdt_boot_no.bin
set mpdtby=mpdt\mpdt_boot_yes.bin

if not exist bdw (echo Error! Folder HSW not found) && pause && exit
if not exist mpdt (echo Error! Folder MPDT not found) && pause && exit

:mn
set ec=
echo.
echo		Generate FFS files Microcode for CPU Skylake (LGA1151)
echo.
echo 	1A Version 1A Date 05-28-2015
echo 	1C Version 1C Date 06-02-2015
echo 	20 Version 20 Date 06-18-2015
echo 	24 Version 24 Date 07-01-2015
echo 	2E Version 2E Date 07-21-2015
echo 	30 Version 30 Date 07-29-2015
echo 	34 Version 34 Date 08-2982015
echo 	0  Exit
echo.
:mn1
set /p ec=Enter Microcode:
if not defined ec goto mn1
if /I %ec%==1A (set mc=skl\cpu000506E3_plat36_ver0000001A_date#28-05-2015.bin) && goto start
if /I %ec%==1C (set mc=skl\cpu000506E3_plat36_ver0000001C_date#02-06-2015.bin) && goto start
if /I %ec%==20 (set mc=skl\cpu000506E3_plat36_ver00000020_date#18-06-2015.bin) && goto start
if /I %ec%==24 (set mc=skl\cpu000506E3_plat36_ver00000024_date#01-07-2015.bin) && goto start
if /I %ec%==2E (set mc=skl\cpu000506E3_plat36_ver0000002E_date#21-07-2015.bin) && goto start
if /I %ec%==30 (set mc=skl\cpu000506E3_plat36_ver00000030_date#29-07-2015.bin) && goto start
if /I %ec%==34 (set mc=skl\cpu000506E3_plat36_ver00000034_date#08-08-2015.bin) && goto start
if /I %ec%==0 exit
goto mn1

:start
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -o ..\..\..\temp\LGA1151.ffs
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -i %mpdtbn% -o ..\..\..\temp\LGA1151_BOOT_NO.ffs
GenFFS -s -t EFI_FV_FILETYPE_RAW -g %guid% -i %mc% -i %mpdtby% -o ..\..\..\temp\LGA1151_BOOT_YES.ffs

exit