/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.jiagu;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FileUtil {
    public static final int MAX_FILE_SIZE_TO_GET_MD5 = 0xA00000;
    private static final String TAG = FileUtil.class.getSimpleName();
    private static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileByte(File file) {
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        byte[] data = null;
        try {
            fis = new FileInputStream(file);
            fc = fis.getChannel();
            data = new byte[(int)((FileChannel)fc).size()];
            ((FileChannel)fc).read(ByteBuffer.wrap(data));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeByteFile(byte[] bytes, File file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(bytes);
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File srcFile, File destFile) {
        boolean result = false;
        if (srcFile != null && srcFile.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(srcFile);
                result = FileUtil.copyToFile(in, destFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyToFile(InputStream inputStream, File destFile) {
        try {
            if (!destFile.getParentFile().exists()) {
                destFile.getParentFile().mkdirs();
            } else if (destFile.exists()) {
                destFile.delete();
            }
            FileOutputStream out = new FileOutputStream(destFile);
            try {
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) >= 0) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                }
            }
            finally {
                ((OutputStream)out).close();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void deleteDir(String filepath) {
        File f = new File(filepath);
        if (f.exists() && f.isDirectory()) {
            if (f.listFiles().length == 0) {
                f.delete();
            } else {
                File[] delFiles;
                for (File delFile : delFiles = f.listFiles()) {
                    if (delFile.isDirectory()) {
                        FileUtil.deleteDir(delFile.getAbsolutePath());
                    }
                    delFile.delete();
                }
                f.delete();
            }
        }
    }

    public static void deleteFile(String filepath) {
        File file = new File(filepath);
        if (file.exists()) {
            if (file.isDirectory() && file.listFiles().length > 0) {
                File[] delFiles;
                for (File delFile : delFiles = file.listFiles()) {
                    FileUtil.deleteFile(delFile.getAbsolutePath());
                }
            }
            file.delete();
        }
    }

    public static boolean safeRenameTo(File src, File dst) {
        boolean ret;
        if (!dst.getParentFile().exists()) {
            dst.getParentFile().mkdirs();
        }
        if (!(ret = src.renameTo(dst)) && (ret = FileUtil.copyFile(src, dst))) {
            if (src.isDirectory()) {
                FileUtil.deleteDir(src.getAbsolutePath());
            } else {
                src.delete();
            }
        }
        return ret;
    }

    public static long countDirSize(File aDir) {
        File[] files;
        long ret = 0L;
        for (File file : files = aDir.listFiles()) {
            if (file.isDirectory()) {
                ret += FileUtil.countDirSize(file);
                continue;
            }
            ret += file.length();
        }
        return ret;
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isDirectory() && file.listFiles().length > 0) {
                File[] delFiles;
                for (File delFile : delFiles = file.listFiles()) {
                    FileUtil.deleteFile(delFile);
                }
            }
            file.delete();
        }
    }

    public static String readFile(String path, String charsetName) {
        String contents = "";
        try {
            File urlFile = new File(path);
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(urlFile), charsetName);
            BufferedReader breader = new BufferedReader(isr);
            String mimeTypeLine = null;
            while ((mimeTypeLine = breader.readLine()) != null) {
                contents = contents + mimeTypeLine;
            }
            breader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contents;
    }

    public static void delFolder(String folderPath) {
        try {
            FileUtil.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void delOnlyFolderContained(String folderPath) {
        try {
            FileUtil.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void delAllFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileUtil.delAllFile(path + File.separator + tempList[i]);
            FileUtil.delFolder(path + File.separator + tempList[i]);
        }
    }

    public static String inputStreamToString(InputStream in) throws Exception {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(File file, String content) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            os.write(content.getBytes());
        }
        catch (Exception e) {
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static boolean ensureFileExist(String filePath) {
        File dirFile = new File(filePath);
        return FileUtil.ensureFileExist(dirFile);
    }

    public static boolean ensureFileExist(File file) {
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static boolean copySdcardFile(String fromFile, String toFile) {
        try {
            int c;
            FileInputStream fosfrom = new FileInputStream(fromFile);
            FileOutputStream fosto = new FileOutputStream(toFile);
            byte[] bt = new byte[1024];
            while ((c = ((InputStream)fosfrom).read(bt)) > 0) {
                ((OutputStream)fosto).write(bt, 0, c);
            }
            ((InputStream)fosfrom).close();
            ((OutputStream)fosto).close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void closeInStream(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeOutStream(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeReader(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeWriter(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void writeObj(Object obj, File f) {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(obj);
        }
        catch (Exception exception) {
            FileUtil.closeOutStream(oos);
            catch (Throwable throwable) {
                FileUtil.closeOutStream(oos);
                throw throwable;
            }
        }
        FileUtil.closeOutStream(oos);
    }

    public static String readFilePath(String filePath) throws Exception {
        File file = new File(filePath);
        FileInputStream inStream = new FileInputStream(file);
        String data = FileUtil.inputStreamToString(inStream);
        inStream.close();
        return data;
    }

    public static long getFolderSize(File file) throws Exception {
        long size = 0L;
        File[] fileList = file.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            if (fileList[i].isDirectory()) {
                size += FileUtil.getFolderSize(fileList[i]);
                continue;
            }
            size += fileList[i].length();
        }
        return size / 1024L;
    }
}

