/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.jiagu;

import com.qihoo.jiagu.MainfestUtil;
import com.qihoo.jiagu.UnZipData;
import com.qihoo.jiagu.UnzipListener;
import com.qihoo.jiagu.Util;
import com.qihoo.jiagu.ZipUtil;
import java.io.File;
import java.util.ArrayList;

public class Installer {
    public void install(UnzipListener listener) {
        ArrayList<UnZipData> datas = new ArrayList<UnZipData>();
        String installJar = System.getProperty("java.class.path");
        String unZipPath = Installer.getInstallPath(installJar);
        String oldVersion = Util.getJiaguVersion();
        System.out.println("oldVersion " + oldVersion);
        String newVersion = MainfestUtil.getVersionInnerJar(installJar, "jiagu.jar");
        System.out.println("newVersion " + newVersion);
        boolean isUnZip = Util.isNeedUnZip(newVersion, oldVersion);
        File mainFile = new File(unZipPath + File.separator + "jiagu.jar");
        if (!isUnZip && mainFile.exists() && listener != null) {
            listener.onFinish();
            return;
        }
        UnZipData picData = new UnZipData();
        picData.setUnzipPath(unZipPath);
        picData.setTargetPath("pic/");
        UnZipData libData = new UnZipData();
        libData.setUnzipPath(unZipPath);
        libData.setTargetPath("lib/");
        UnZipData mainData = new UnZipData();
        mainData.setUnzipPath(unZipPath);
        mainData.setHasPath(false);
        mainData.setTargetPath("main/");
        UnZipData updateData = new UnZipData();
        updateData.setUnzipPath(unZipPath);
        updateData.setTargetPath("update/");
        UnZipData shellData = new UnZipData();
        shellData.setUnzipPath(unZipPath);
        shellData.setHasPath(false);
        shellData.setTargetPath("shell/");
        datas.add(picData);
        datas.add(libData);
        datas.add(mainData);
        datas.add(updateData);
        datas.add(shellData);
        ZipUtil.unZip(installJar, datas, listener);
    }

    public static String getCurrentPath(String jarPath) {
        String path = null;
        File currentFile = null;
        if (jarPath != null && jarPath.contains(File.separator)) {
            File file = new File(jarPath);
            currentFile = new File(file.getParent());
        } else {
            currentFile = new File(System.getProperty("user.dir"));
        }
        path = currentFile + File.separator;
        return path;
    }

    public static String getInstallPath(String jarPath) {
        String path = null;
        File currentFile = null;
        if (jarPath != null && jarPath.contains(File.separator)) {
            File file = new File(jarPath);
            currentFile = new File(file.getParent());
        } else {
            currentFile = new File(System.getProperty("user.dir"));
        }
        String firmPath = File.separator + "jiagu";
        if (currentFile.getAbsolutePath().contains(firmPath)) {
            int lastIndex = currentFile.getAbsolutePath().lastIndexOf(firmPath);
            String installPath = currentFile.getAbsolutePath().substring(0, lastIndex + firmPath.length());
            File installPathFile = new File(installPath);
            File[] list = installPathFile.listFiles();
            boolean isInstall = false;
            if (list != null) {
                for (File name : list) {
                    if (!"jiagu.jar".equals(name.getName())) continue;
                    isInstall = true;
                    break;
                }
            }
            path = isInstall ? installPathFile.getAbsolutePath() : currentFile.getAbsolutePath() + File.separator + "jiagu" + File.separator;
        } else {
            path = currentFile.getAbsolutePath() + File.separator + "jiagu" + File.separator;
        }
        return path;
    }
}

