/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.jiagu;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    private static final String ALGORIGTHM_MD5 = "MD5";
    private static final int CACHE_SIZE = 8192;

    public static String encode(String string) {
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORIGTHM_MD5);
            md.update(string.getBytes());
            byte[] b = md.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            return buf.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String generateFileMD5(String filePath) {
        String md5 = "";
        try {
            File file = new File(filePath);
            if (file.exists()) {
                MessageDigest messageDigest = MD5Util.getMD5();
                FileInputStream in = new FileInputStream(file);
                byte[] cache = new byte[8192];
                int nRead = 0;
                while ((nRead = ((InputStream)in).read(cache)) != -1) {
                    messageDigest.update(cache, 0, nRead);
                }
                ((InputStream)in).close();
                byte[] data = messageDigest.digest();
                md5 = MD5Util.byteArrayToHexString(data);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return md5;
    }

    public static String generateFileMD5(InputStream in) {
        String md5 = "";
        try {
            MessageDigest messageDigest = MD5Util.getMD5();
            byte[] cache = new byte[8192];
            int nRead = 0;
            while ((nRead = in.read(cache)) != -1) {
                messageDigest.update(cache, 0, nRead);
            }
            in.close();
            byte[] data = messageDigest.digest();
            md5 = MD5Util.byteArrayToHexString(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return md5;
    }

    private static String byteArrayToHexString(byte[] data) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] arr = new char[32];
        int k = 0;
        for (int i = 0; i < 16; ++i) {
            byte b = data[i];
            arr[k++] = hexDigits[b >>> 4 & 0xF];
            arr[k++] = hexDigits[b & 0xF];
        }
        return new String(arr);
    }

    private static MessageDigest getMD5() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(ALGORIGTHM_MD5);
    }

    public static String getMd5(String str) {
        MessageDigest md5 = null;
        StringBuilder sb = null;
        try {
            md5 = MessageDigest.getInstance(ALGORIGTHM_MD5);
            byte[] bs = md5.digest(str.getBytes());
            sb = new StringBuilder(40);
            for (byte x : bs) {
                if ((x & 0xFF) >> 4 == 0) {
                    sb.append("0").append(Integer.toHexString(x & 0xFF));
                    continue;
                }
                sb.append(Integer.toHexString(x & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }
}

