/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.jiagu;

import com.qihoo.jiagu.FileUtil;
import com.qihoo.jiagu.OsConfig;
import java.io.InputStream;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OsConfigParser {
    private static HashMap<String, OsConfig> osConfigMap = null;

    public static synchronized HashMap<String, OsConfig> getOsConfig() {
        if (osConfigMap != null) {
            return osConfigMap;
        }
        osConfigMap = new HashMap();
        try {
            InputStream is = OsConfigParser.class.getResourceAsStream("/resource/os_config.txt");
            String content = FileUtil.inputStreamToString(is);
            osConfigMap = OsConfigParser.parserOsConfig(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            osConfigMap = null;
        }
        return osConfigMap;
    }

    private static HashMap<String, OsConfig> parserOsConfig(String source) {
        HashMap<String, OsConfig> osConfigMap = new HashMap<String, OsConfig>();
        try {
            JSONArray array = new JSONArray(source);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject osInfo = array.optJSONObject(i);
                String os = osInfo.optString("os", "");
                String fileName = osInfo.optString("fileName", "");
                String reName = osInfo.optString("reName", "");
                OsConfig config = new OsConfig();
                config.setOS(os);
                config.setFileName(fileName);
                config.setReName(reName);
                osConfigMap.put(fileName, config);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return osConfigMap;
    }

    public static boolean isWindows() {
        boolean flag = false;
        if (System.getProperties().getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1) {
            flag = true;
        }
        return flag;
    }

    public static String getWindowsOsName() {
        return "Windows";
    }
}

