/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.jiagu;

import com.qihoo.jiagu.InstallConfig;
import com.qihoo.jiagu.Installer;
import com.qihoo.jiagu.MD5Util;
import com.qihoo.jiagu.MainfestUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.TextUtils;

public class Util {
    public static OS_V os = OS_V.NULL;
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final String DIRECTORY_LEVEL_UP = "../";
    private static String pcMidString = null;

    public static boolean isMacOs() {
        String MAC_OS = "MAC";
        Properties props = System.getProperties();
        String osName = System.getProperty("os.name");
        osName = osName.toUpperCase();
        return osName.startsWith(MAC_OS);
    }

    public static boolean isWindows() {
        String MAC_OS = "WINDOWS";
        Properties props = System.getProperties();
        String osName = System.getProperty("os.name");
        osName = osName.toUpperCase();
        return osName.startsWith(MAC_OS);
    }

    public static void reportInstall() {
        new Thread(){

            @Override
            public void run() {
                DefaultHttpClient httpClient = new DefaultHttpClient();
                HttpGet httpRequest = new HttpGet(Util.buildUrl(1000, null));
                HttpParams httpParams = httpRequest.getParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
                HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)5000);
                try {
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
                    StatusLine status = response.getStatusLine();
                    int statusCode = status.getStatusCode();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }.start();
    }

    public static String getOsMid() {
        if (pcMidString != null) {
            return pcMidString;
        }
        try {
            StringBuffer sb = new StringBuffer();
            byte[] mac = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
            for (int i = 0; i < mac.length; ++i) {
                String s = Integer.toHexString(mac[i] & 0xFF);
                sb.append(s.length() == 1 ? 0 + s : s);
            }
            pcMidString = MD5Util.encode(sb.toString().toLowerCase());
        }
        catch (Exception e) {
            pcMidString = MD5Util.encode("360imei");
        }
        return pcMidString;
    }

    public static OS_V getOSVersion() {
        if (os != OS_V.NULL) {
            return os;
        }
        String osName = System.getProperty("os.name", "");
        String osArch = System.getProperty("os.arch", "");
        os = osName.startsWith("Mac OS") ? (osArch.contains("64") ? OS_V.MAC64 : OS_V.MAC32) : (osName.startsWith("Windows") ? (osArch.contains("64") ? OS_V.WINDOWS64 : OS_V.WINDWOS32) : (osArch.contains("64") ? OS_V.LINUX64 : OS_V.LINUX32));
        return os;
    }

    public static String getOsKind() {
        OS_V osV = Util.getOSVersion();
        if (osV.equals((Object)OS_V.WINDWOS32) || osV.equals((Object)OS_V.WINDOWS64)) {
            return "w";
        }
        if (osV.equals((Object)OS_V.LINUX32) || osV.equals((Object)OS_V.LINUX64)) {
            return "l";
        }
        return "m";
    }

    public static String getOsArch() {
        OS_V osV = Util.getOSVersion();
        if (osV.toString().contains("32")) {
            return "32";
        }
        return "64";
    }

    private static String buildUrl(int action, String otherInfo) {
        String url = "http://cr.jiagu.360.cn/l.html";
        String pcInfo = String.format("&tp=1&m=%s&v=%s&p=%s&ar=%s&tg=0", Util.getOsMid(), InstallConfig.APPVERSION, Util.getOsKind(), Util.getOsArch());
        String check = "&c=" + MD5Util.encode(action + "pcjiagu" + pcInfo);
        url = url + "?a=" + action + "&s=" + otherInfo + pcInfo + check;
        return url;
    }

    public static boolean checkVersionString(String versionString) {
        if (TextUtils.isEmpty((CharSequence)versionString)) {
            return false;
        }
        if (!versionString.contains(".")) {
            return false;
        }
        String[] newVersions = versionString.split("\\.");
        if (newVersions.length != 4) {
            return false;
        }
        String oldVersion = null;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < newVersions.length; ++i) {
            builder.append(newVersions[i]);
            if (i != 0) continue;
            builder.append(".");
        }
        oldVersion = builder.toString();
        try {
            float newV = Float.parseFloat(oldVersion);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isNeedUnZip(String newVersion, String installedVersion) {
        if (TextUtils.isEmpty((CharSequence)newVersion)) {
            return false;
        }
        if (!Util.checkVersionString(installedVersion)) {
            return true;
        }
        String[] newVersions = newVersion.split("\\.");
        String[] oldVersions = installedVersion.split("\\.");
        if (newVersions == null) {
            return false;
        }
        if (oldVersions == null) {
            return true;
        }
        if (newVersions.length == 4 && oldVersions.length == 4) {
            int i;
            StringBuilder builder = new StringBuilder();
            String strNewVersion = null;
            String oldVersion = null;
            for (i = 0; i < newVersions.length; ++i) {
                builder.append(newVersions[i]);
                if (i != 0) continue;
                builder.append(".");
            }
            strNewVersion = builder.toString();
            builder = new StringBuilder();
            for (i = 0; i < oldVersions.length; ++i) {
                builder.append(oldVersions[i]);
                if (i != 0) continue;
                builder.append(".");
            }
            oldVersion = builder.toString();
            try {
                float newV = Float.parseFloat(strNewVersion);
                float oldV = Float.parseFloat(oldVersion);
                return newV > oldV;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return oldVersions.length != 4;
    }

    public static String getJiaguVersion() {
        String version = null;
        version = MainfestUtil.getJarVersion(Installer.getInstallPath(System.getProperty("java.class.path")) + "jiagu.jar");
        return version;
    }

    public static enum OS_V {
        NULL,
        WINDWOS32,
        WINDOWS64,
        LINUX32,
        LINUX64,
        MAC32,
        MAC64;

    }
}

