/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.jiagu;

import com.qihoo.jiagu.FileUtil;
import com.qihoo.jiagu.OsConfig;
import com.qihoo.jiagu.OsConfigParser;
import com.qihoo.jiagu.UnZipData;
import com.qihoo.jiagu.UnzipListener;
import com.qihoo.jiagu.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final String TAG = "ZipUtil";
    private static final int BUFF_SIZE = 32768;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean unZip(String zipPath, ArrayList<UnZipData> unZipData, UnzipListener listener) {
        if (listener != null) {
            listener.onStart();
        }
        if (zipPath == null || unZipData == null) {
            if (listener == null) return false;
            listener.onError();
            return false;
        }
        is = null;
        fos = null;
        try {
            zipFile = new ZipFile(zipPath);
            en = zipFile.entries();
            if (en == null) {
                if (listener != null) {
                    listener.onFinish();
                }
                var7_9 = false;
                return var7_9;
            }
            current = 0;
            total = zipFile.size();
lbl19:
            // 2 sources

            while (true) {
                if (en.hasMoreElements()) {
                    object = en.nextElement();
                    ++current;
                    if (listener != null) {
                        percentage = (int)((double)current * 1.0 / ((double)total * 1.0) * 100.0);
                        listener.onProgress(total, current, percentage);
                    }
                    if ((is = zipFile.getInputStream(object)) == null) {
                        percentage = 0;
                        return (boolean)percentage;
                    }
                    name = object.getName();
                    if (name == null) {
                        is.close();
                        is = null;
                        e = false;
                        return e;
                    }
                    if (name.endsWith("/")) continue;
                } else {
                    var9_14 = true;
                    return var9_14;
                }
                i = 0;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (listener != null) {
                listener.onFinish();
            }
            try {
                if (is != null) {
                    is.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
        while (true) {
            if (i < unZipData.size()) ** break;
            ** continue;
            dir = unZipData.get(i).getUnzipPath();
            path = unZipData.get(i).getTargetPath();
            hasPath = unZipData.get(i).hasPath();
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            if (object.getName().startsWith(path)) {
                if (!hasPath) {
                    lastIndex = name.lastIndexOf("/");
                    if (lastIndex != -1) {
                        name = name.substring(lastIndex, name.length());
                    }
                } else {
                    targetDirFile = new File(dir + path);
                    if (!targetDirFile.exists()) {
                        targetDirFile.mkdirs();
                    }
                }
                unZipName = ZipUtil.getOsReNameFile(dir + name);
                if (null == unZipName || "".equals(unZipName)) {
                    is.close();
                    is = null;
                } else {
                    file = new File(unZipName);
                    if (!file.exists()) {
                        file.getParentFile().mkdirs();
                        file.createNewFile();
                    }
                    fos = new FileOutputStream(unZipName);
                    buffer = new byte[2048];
                    size = 0;
                    while ((size = is.read(buffer)) > 0) {
                        fos.write(buffer, 0, size);
                    }
                    fos.flush();
                    fos.getFD().sync();
                    is.close();
                    is = null;
                    fos.close();
                    fos = null;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean unZip(String zipPath, String dir) {
        if (zipPath == null) return false;
        if (dir == null) {
            return false;
        }
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            ZipFile zipFile = new ZipFile(zipPath);
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            if (en == null) {
                boolean bl = false;
                return bl;
            }
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            while (en.hasMoreElements()) {
                ZipEntry object = en.nextElement();
                is = zipFile.getInputStream(object);
                if (is == null) {
                    boolean e = false;
                    return e;
                }
                String name = object.getName();
                if (name == null) {
                    is.close();
                    is = null;
                    boolean e = false;
                    return e;
                }
                fos = new FileOutputStream(dir + name);
                byte[] buffer = new byte[2048];
                int size = 0;
                while ((size = is.read(buffer)) > 0) {
                    fos.write(buffer, 0, size);
                }
                fos.flush();
                fos.getFD().sync();
                is.close();
                is = null;
                fos.close();
                fos = null;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static void unZip(InputStream in, File unZip) throws IOException {
        FileUtil.deleteFile(unZip);
        FileOutputStream OutputStream2 = new FileOutputStream(unZip);
        byte[] bytes = new byte[8192];
        int len = 0;
        if (in == null) {
            return;
        }
        while ((len = in.read(bytes)) > 0) {
            OutputStream2.write(bytes, 0, len);
        }
        if (in != null) {
            in.close();
            in = null;
        }
        if (OutputStream2 != null) {
            OutputStream2.close();
            OutputStream2 = null;
        }
    }

    public static void ZipDir(File dirTobeZip, File newZipFile) throws IOException {
        FileInputStream input = null;
        ZipOutputStream zipOut = null;
        zipOut = new ZipOutputStream(new FileOutputStream(newZipFile));
        if (dirTobeZip.isDirectory()) {
            File[] lists = dirTobeZip.listFiles();
            for (int i = 0; i < lists.length; ++i) {
                File currentFile = lists[i];
                input = new FileInputStream(currentFile);
                zipOut.putNextEntry(new ZipEntry(dirTobeZip.getName() + "/" + currentFile.getName()));
                int temp = 0;
                while ((temp = ((InputStream)input).read()) != -1) {
                    zipOut.write(temp);
                }
                ((InputStream)input).close();
            }
        }
        zipOut.close();
    }

    public static void GzipOneFile(File srcFile, File zipFile) throws IOException {
        if (srcFile.exists()) {
            GZIPOutputStream zipout = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 32768));
            ZipUtil._gzipFile(srcFile, zipout);
            zipout.close();
        }
    }

    public static SizeLimitZipResult ZipDirGzip(File dirTobeZip, File newGZipFile, int fileSizeLimit, int totalSizeLimit) throws IOException {
        String tempFileName = newGZipFile.getAbsolutePath() + ".tmp";
        File tempZipFile = new File(tempFileName);
        boolean dret1 = tempZipFile.delete();
        SizeLimitZipResult ret = ZipUtil.zipDirWithSizeLimit(dirTobeZip, tempZipFile, fileSizeLimit, totalSizeLimit);
        if (ret == SizeLimitZipResult.SizeLimitZipResult_NotFound) {
            return ret;
        }
        ZipUtil.GzipOneFile(tempZipFile, newGZipFile);
        boolean dret = tempZipFile.delete();
        return ret;
    }

    private static void _gzipFile(File resFile, GZIPOutputStream zipout) throws FileNotFoundException, IOException {
        int realLength;
        byte[] buffer = new byte[32768];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(resFile), 32768);
        while ((realLength = in.read(buffer)) != -1) {
            zipout.write(buffer, 0, realLength);
        }
        in.close();
        zipout.flush();
    }

    private static SizeLimitZipResult zipDirWithSizeLimit(File dirTobeZip, File newZipFile, long fileSizeLimit, long totalSizeLimit) throws IOException {
        SizeLimitZipResult ret = SizeLimitZipResult.SizeLimitZipResult_OK;
        boolean hasFile = false;
        if (dirTobeZip.exists() && dirTobeZip.isDirectory()) {
            File[] lists = dirTobeZip.listFiles();
            boolean bl = hasFile = lists.length > 0;
            if (hasFile) {
                boolean needSizeLimit;
                FileInputStream input = null;
                ZipOutputStream zipOut = null;
                FileOutputStream fOut = new FileOutputStream(newZipFile);
                zipOut = new ZipOutputStream(fOut);
                StringBuilder sb = null;
                boolean bl2 = needSizeLimit = totalSizeLimit > 0L || fileSizeLimit > 0L;
                if (needSizeLimit) {
                    sb = new StringBuilder();
                }
                int currentSize = 0;
                for (int i = 0; i < lists.length; ++i) {
                    File currentFile = lists[i];
                    input = new FileInputStream(currentFile);
                    if (needSizeLimit) {
                        int fsize = ((InputStream)input).available();
                        sb.append("[").append(i).append("/").append(lists.length).append("]");
                        sb.append(currentFile.getName());
                        sb.append("(").append(fsize).append(")");
                        if ((long)fsize > fileSizeLimit) {
                            ret = SizeLimitZipResult.SizeLimitZipResult_TooBig;
                            continue;
                        }
                        if ((long)(currentSize + fsize) < totalSizeLimit) {
                            currentSize += fsize;
                        } else {
                            ret = SizeLimitZipResult.SizeLimitZipResult_TooBig;
                            continue;
                        }
                    }
                    zipOut.putNextEntry(new ZipEntry(currentFile.getName()));
                    int readLen = 0;
                    byte[] buf = new byte[1024];
                    while ((readLen = ((InputStream)input).read(buf, 0, 1024)) != -1) {
                        zipOut.write(buf, 0, readLen);
                    }
                    zipOut.closeEntry();
                    ((InputStream)input).close();
                }
                if (needSizeLimit) {
                    if (currentSize == 0 && hasFile) {
                        zipOut.putNextEntry(new ZipEntry("common.txt"));
                        zipOut.write(sb.toString().getBytes());
                        zipOut.closeEntry();
                    }
                    zipOut.setComment(sb.toString());
                }
                zipOut.close();
                fOut.close();
            } else {
                ret = SizeLimitZipResult.SizeLimitZipResult_NotFound;
            }
        } else {
            ret = SizeLimitZipResult.SizeLimitZipResult_NotFound;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringForZip(ZipFile zipFile) {
        String content = null;
        InputStream is = null;
        ByteArrayOutputStream aos = null;
        try {
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry object = en.nextElement();
                is = zipFile.getInputStream(object);
            }
            aos = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int len = 0;
            while ((len = is.read(bytes)) > 0) {
                aos.write(bytes, 0, len);
            }
            aos.flush();
            content = new String(aos.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (aos != null) {
                    aos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    private static String getOsReNameFile(String fileName) {
        String reName = fileName;
        String name = fileName;
        String dir = "";
        int indexDir = fileName.lastIndexOf("/");
        if (indexDir != -1) {
            dir = fileName.substring(0, indexDir + 1);
            name = fileName.substring(indexDir + 1, name.length());
        }
        Properties props = System.getProperties();
        String bits = Util.getOsArch();
        String osName = System.getProperty("os.name");
        if (OsConfigParser.isWindows()) {
            osName = OsConfigParser.getWindowsOsName();
        }
        OsConfigParser configParser = new OsConfigParser();
        HashMap<String, OsConfig> configs = configParser.getOsConfig();
        if (configs.containsKey(name)) {
            OsConfig config = configs.get(name);
            reName = config.getOS().equals(osName + " " + bits) ? dir + config.getReName() : null;
        }
        return reName;
    }

    public static InputStream getZipData(String zipPath, String fileName) {
        ZipInputStream zin = null;
        try {
            zin = new ZipInputStream(new FileInputStream(new File(zipPath)));
            ZipEntry entry = null;
            while ((entry = zin.getNextEntry()) != null && !entry.isDirectory()) {
                String entryName = entry.getName();
                if (!fileName.equals(entryName)) continue;
                return zin;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return zin;
    }

    public static enum SizeLimitZipResult {
        SizeLimitZipResult_OK,
        SizeLimitZipResult_TooBig,
        SizeLimitZipResult_NotFound;

    }
}

