/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Worm;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class WormTexted
implements Iterable<Point2D.Double> {
    private final Worm worm;
    private TextBlock textBlock;

    public WormTexted() {
        this(new Worm());
    }

    private WormTexted(Worm worm) {
        this.worm = worm;
    }

    @Override
    public Iterator<Point2D.Double> iterator() {
        return this.worm.iterator();
    }

    public void addPoint(double x, double y) {
        this.worm.addPoint(x, y);
    }

    public void drawInternalOneColor(UPolygon startDecoration, UGraphic ug, HtmlColorAndStyle color, double stroke, Direction emphasizeDirection, UPolygon endDecoration) {
        this.worm.drawInternalOneColor(startDecoration, ug, color, stroke, emphasizeDirection, endDecoration);
    }

    public Worm getWorm() {
        return this.worm;
    }

    public Point2D get(int i) {
        return this.worm.get(i);
    }

    public int size() {
        return this.worm.size();
    }

    public WormTexted merge(WormTexted other, MergeStrategy merge) {
        Worm result = this.worm.merge(other.worm, merge);
        return new WormTexted(result);
    }

    public void addAll(WormTexted other) {
        this.worm.addAll(other.worm);
    }

    public void setLabel(TextBlock label) {
        if (this.textBlock != null) {
            throw new IllegalStateException();
        }
        this.textBlock = label;
    }

    public boolean isEmptyText(StringBounder stringBounder) {
        return TextBlockUtils.isEmpty(this.textBlock, stringBounder);
    }

    private Point2D getTextBlockPosition(StringBounder stringBounder) {
        Point2D pt1 = this.get(0);
        Point2D pt2 = this.get(1);
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        double y = (pt1.getY() + pt2.getY()) / 2.0 - dim.getHeight() / 2.0;
        return new Point2D.Double(Math.max(pt1.getX(), pt2.getX()) + 4.0, y);
    }

    public double getMaxX(StringBounder stringBounder) {
        double result = -1.7976931348623157E308;
        for (Point2D pt : this) {
            result = Math.max(result, pt.getX());
        }
        if (this.textBlock != null) {
            Point2D position = this.getTextBlockPosition(stringBounder);
            Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
            result = Math.max(result, position.getX() + dim.getWidth());
        }
        return result;
    }

    void drawInternalLabel(UGraphic ug) {
        if (this.textBlock != null) {
            Point2D position = this.getTextBlockPosition(ug.getStringBounder());
            this.textBlock.drawU(ug.apply(new UTranslate(position)));
        }
    }

    public void copyLabels(WormTexted other) {
        this.textBlock = other.textBlock;
    }
}

