/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class GtileColumns
extends AbstractGtile {
    protected final List<Gtile> gtiles;
    private final List<Dimension2D> dims = new ArrayList<Dimension2D>();
    protected final List<UTranslate> positions = new ArrayList<UTranslate>();

    public String toString() {
        return "GtileIfSimple " + this.gtiles;
    }

    public Gtile first() {
        return this.gtiles.get(0);
    }

    public GtileColumns(List<Gtile> gtiles, Swimlane singleSwimlane) {
        super(gtiles.get(0).getStringBounder(), gtiles.get(0).skinParam(), singleSwimlane);
        this.gtiles = gtiles;
        double dx = 0.0;
        for (Gtile tile : gtiles) {
            Dimension2D dim = tile.calculateDimension(this.getStringBounder());
            UTranslate pos = UTranslate.dx(dx);
            dx += dim.getWidth() + this.getMargin();
            this.dims.add(dim);
            this.positions.add(pos);
        }
    }

    private double getMargin() {
        return 20.0;
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        for (int i = 0; i < this.gtiles.size(); ++i) {
            Gtile tile = this.gtiles.get(i);
            UTranslate pos = this.positions.get(i);
            ug.apply(pos).draw(tile);
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D result = new Dimension2DDouble(0.0, 0.0);
        for (int i = 0; i < this.dims.size(); ++i) {
            Dimension2D dim = this.dims.get(i);
            UTranslate pos = this.positions.get(i);
            Dimension2D corner = pos.getTranslated(dim);
            result = MathUtils.max(result, corner);
        }
        return result;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        for (Gtile tile : this.gtiles) {
            result.addAll(tile.getSwimlanes());
        }
        return Collections.unmodifiableSet(result);
    }
}

