/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.ThemeStyle;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorRuntimeException;

public class CommandCreoleColorAndSizeChange
implements Command {
    private final Pattern2 mypattern;
    private final ThemeStyle themeStyle;
    public static final String fontPattern = "\\<font(?:[%s]+size[%s]*=[%s]*[%g]?(\\d+)[%g]?|[%s]+color[%s]*=[%s]*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>";
    private static final Pattern2 pattern = MyPattern.cmpile("^(\\<font(?:[%s]+size[%s]*=[%s]*[%g]?(\\d+)[%g]?|[%s]+color[%s]*=[%s]*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>(.*?)\\</font\\>)");
    private static final Pattern2 patternEol = MyPattern.cmpile("^(\\<font(?:[%s]+size[%s]*=[%s]*[%g]?(\\d+)[%g]?|[%s]+color[%s]*=[%s]*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>(.*))$");

    public static Command create(ThemeStyle themeStyle) {
        return new CommandCreoleColorAndSizeChange(themeStyle, pattern);
    }

    public static Command createEol(ThemeStyle themeStyle) {
        return new CommandCreoleColorAndSizeChange(themeStyle, patternEol);
    }

    private CommandCreoleColorAndSizeChange(ThemeStyle themeStyle, Pattern2 pattern) {
        this.mypattern = pattern;
        this.themeStyle = themeStyle;
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.mypattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) throws NoSuchColorRuntimeException {
        FontConfiguration fc1;
        Matcher2 m = this.mypattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc2 = fc1 = stripe.getActualFontConfiguration();
        if (m.group(2) != null) {
            fc2 = fc2.changeSize(Integer.parseInt(m.group(2)));
        }
        try {
            if (m.group(3) != null) {
                String s = m.group(3);
                HColor color = HColorSet.instance().getColor(this.themeStyle, s);
                fc2 = fc2.changeColor(color);
            }
            stripe.setActualFontConfiguration(fc2);
            stripe.analyzeAndAdd(m.group(4));
            stripe.setActualFontConfiguration(fc1);
            return line.substring(m.group(1).length());
        }
        catch (NoSuchColorException e) {
            throw new NoSuchColorRuntimeException();
        }
    }
}

