"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.DropEmptyChunksStream = void 0;
var stream_1 = require("stream");
/**
 * A transformation stream that doesn't forward empty chunks.
 */
var DropEmptyChunksStream = /** @class */ (function (_super) {
    __extends(DropEmptyChunksStream, _super);
    function DropEmptyChunksStream() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * The transformation logic of the stream.
     * @param chunk The data chunk to be transformed.
     * @param _encoding If the chunk is a string, then this is the encoding type.
     *                  If chunk is a buffer, then this is the special value 'buffer'.
     * @param callback A callback function (optionally with an error argument and data) to be called
     *                 after the supplied chunk has been processed.
     */
    DropEmptyChunksStream.prototype._transform = function (chunk, _encoding, callback) {
        if (chunk.length > 0) {
            this.push(chunk);
        }
        callback();
    };
    return DropEmptyChunksStream;
}(stream_1.Transform));
exports.DropEmptyChunksStream = DropEmptyChunksStream;
