/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.device.IHvDevice;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import com.android.hierarchyviewerlib.models.ViewNode;
import com.android.hierarchyviewerlib.ui.DevicePropertyEditingSupport;
import com.android.hierarchyviewerlib.ui.util.DrawableViewNode;
import com.android.hierarchyviewerlib.ui.util.TreeColumnResizer;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class PropertyViewer
extends Composite
implements TreeViewModel.ITreeChangeListener {
    private TreeViewModel mModel;
    private TreeViewer mTreeViewer;
    private Tree mTree;
    private TreeViewerColumn mValueColumn;
    private PropertyValueEditingSupport mPropertyValueEditingSupport;
    private Image mImage;
    private DrawableViewNode mSelectedNode;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            PropertyViewer.this.mModel.removeTreeChangeListener(PropertyViewer.this);
        }
    };
    private ControlListener mControlListener = new ControlAdapter(){
        private boolean noInput = false;
        private boolean noHeader = false;

        public void controlResized(ControlEvent e) {
            if (PropertyViewer.this.getBounds().height <= 20) {
                PropertyViewer.this.mTree.setHeaderVisible(false);
                this.noHeader = true;
            } else if (this.noHeader) {
                PropertyViewer.this.mTree.setHeaderVisible(true);
                this.noHeader = false;
            }
            if (PropertyViewer.this.getBounds().height <= 38) {
                PropertyViewer.this.mTreeViewer.setInput(null);
                this.noInput = true;
            } else if (this.noInput) {
                PropertyViewer.this.mTreeViewer.setInput((Object)PropertyViewer.this.mModel);
                this.noInput = false;
            }
        }
    };

    public PropertyViewer(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.mTreeViewer = new TreeViewer((Composite)this, 0);
        this.mTree = this.mTreeViewer.getTree();
        this.mTree.setLinesVisible(true);
        this.mTree.setHeaderVisible(true);
        TreeColumn propertyColumn = new TreeColumn(this.mTree, 0);
        propertyColumn.setText("Property");
        TreeColumn valueColumn = new TreeColumn(this.mTree, 0);
        valueColumn.setText("Value");
        this.mValueColumn = new TreeViewerColumn(this.mTreeViewer, valueColumn);
        this.mPropertyValueEditingSupport = new PropertyValueEditingSupport((ColumnViewer)this.mTreeViewer);
        this.mValueColumn.setEditingSupport((EditingSupport)this.mPropertyValueEditingSupport);
        this.mModel = TreeViewModel.getModel();
        ContentProvider contentProvider = new ContentProvider();
        this.mTreeViewer.setContentProvider((IContentProvider)contentProvider);
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)contentProvider);
        this.mTreeViewer.setInput((Object)this.mModel);
        this.mModel.addTreeChangeListener(this);
        this.addDisposeListener(this.mDisposeListener);
        TreeColumnResizer resizer = new TreeColumnResizer(this, propertyColumn, valueColumn);
        this.addControlListener(this.mControlListener);
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        this.mImage = imageLoader.loadImage("picker.png", Display.getDefault());
        this.treeChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionChanged() {
        PropertyViewer propertyViewer = this;
        synchronized (propertyViewer) {
            this.mSelectedNode = this.mModel.getSelection();
        }
        this.doRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void treeChanged() {
        PropertyViewer propertyViewer = this;
        synchronized (propertyViewer) {
            this.mSelectedNode = this.mModel.getSelection();
        }
        this.doRefresh();
    }

    @Override
    public void viewportChanged() {
    }

    @Override
    public void zoomChanged() {
    }

    private void doRefresh() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PropertyViewer.this.mTreeViewer.refresh();
            }
        });
    }

    private class PropertyValueEditingSupport
    extends EditingSupport {
        private DevicePropertyEditingSupport mDevicePropertyEditingSupport;

        public PropertyValueEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.mDevicePropertyEditingSupport = new DevicePropertyEditingSupport();
        }

        protected boolean canEdit(Object element) {
            if (PropertyViewer.this.mSelectedNode == null) {
                return false;
            }
            return element instanceof ViewNode.Property && ((PropertyViewer)PropertyViewer.this).mSelectedNode.viewNode.window.getHvDevice().isViewUpdateEnabled() && this.mDevicePropertyEditingSupport.canEdit((ViewNode.Property)element);
        }

        protected CellEditor getCellEditor(Object element) {
            ViewNode.Property p = (ViewNode.Property)element;
            DevicePropertyEditingSupport.PropertyType type = this.mDevicePropertyEditingSupport.getPropertyType(p);
            Composite parent = (Composite)this.getViewer().getControl();
            switch (type) {
                case INTEGER: 
                case INTEGER_OR_CONSTANT: {
                    return new TextCellEditor(parent);
                }
                case ENUM: {
                    String[] items = this.mDevicePropertyEditingSupport.getPropertyRange(p);
                    return new ComboBoxCellEditor(parent, items, 8);
                }
            }
            return null;
        }

        protected Object getValue(Object element) {
            ViewNode.Property p = (ViewNode.Property)element;
            DevicePropertyEditingSupport.PropertyType type = this.mDevicePropertyEditingSupport.getPropertyType(p);
            if (type == DevicePropertyEditingSupport.PropertyType.ENUM) {
                String[] items = this.mDevicePropertyEditingSupport.getPropertyRange(p);
                return this.indexOf(p.value, items);
            }
            return ((ViewNode.Property)element).value;
        }

        private int indexOf(String item, String[] items) {
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].equals(item)) continue;
                return i;
            }
            return -1;
        }

        protected void setValue(Object element, Object newValue) {
            ViewNode.Property p = (ViewNode.Property)element;
            IHvDevice device = ((PropertyViewer)PropertyViewer.this).mSelectedNode.viewNode.window.getHvDevice();
            Collection<ViewNode.Property> properties = ((PropertyViewer)PropertyViewer.this).mSelectedNode.viewNode.namedProperties.values();
            if (this.mDevicePropertyEditingSupport.setValue(properties, p, newValue, ((PropertyViewer)PropertyViewer.this).mSelectedNode.viewNode, device)) {
                PropertyViewer.this.doRefresh();
            }
        }
    }

    private class ContentProvider
    implements ITreeContentProvider,
    ITableLabelProvider {
        private ContentProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getChildren(Object parentElement) {
            PropertyViewer propertyViewer = PropertyViewer.this;
            synchronized (propertyViewer) {
                if (PropertyViewer.this.mSelectedNode != null && parentElement instanceof String) {
                    String category = (String)parentElement;
                    ArrayList<ViewNode.Property> returnValue = new ArrayList<ViewNode.Property>();
                    for (ViewNode.Property property : ((PropertyViewer)PropertyViewer.this).mSelectedNode.viewNode.properties) {
                        if (category.equals("miscellaneous")) {
                            if (property.name.indexOf(58) != -1) continue;
                            returnValue.add(property);
                            continue;
                        }
                        if (!property.name.startsWith((String)parentElement + ":")) continue;
                        returnValue.add(property);
                    }
                    return returnValue.toArray(new ViewNode.Property[returnValue.size()]);
                }
                return new Object[0];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getParent(Object element) {
            PropertyViewer propertyViewer = PropertyViewer.this;
            synchronized (propertyViewer) {
                if (PropertyViewer.this.mSelectedNode != null && element instanceof ViewNode.Property) {
                    if (((PropertyViewer)PropertyViewer.this).mSelectedNode.viewNode.categories.size() == 0) {
                        return null;
                    }
                    String name = ((ViewNode.Property)element).name;
                    int index = name.indexOf(58);
                    if (index == -1) {
                        return "miscellaneous";
                    }
                    return name.substring(0, index);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasChildren(Object element) {
            PropertyViewer propertyViewer = PropertyViewer.this;
            synchronized (propertyViewer) {
                if (PropertyViewer.this.mSelectedNode != null && element instanceof String) {
                    String category = (String)element;
                    for (String name : ((PropertyViewer)PropertyViewer.this).mSelectedNode.viewNode.namedProperties.keySet()) {
                        if (category.equals("miscellaneous")) {
                            if (name.indexOf(58) != -1) continue;
                            return true;
                        }
                        if (!name.startsWith((String)element + ":")) continue;
                        return true;
                    }
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getElements(Object inputElement) {
            PropertyViewer propertyViewer = PropertyViewer.this;
            synchronized (propertyViewer) {
                if (PropertyViewer.this.mSelectedNode != null && inputElement instanceof TreeViewModel) {
                    if (((PropertyViewer)PropertyViewer.this).mSelectedNode.viewNode.categories.size() == 0) {
                        return ((PropertyViewer)PropertyViewer.this).mSelectedNode.viewNode.properties.toArray(new ViewNode.Property[((PropertyViewer)PropertyViewer.this).mSelectedNode.viewNode.properties.size()]);
                    }
                    return ((PropertyViewer)PropertyViewer.this).mSelectedNode.viewNode.categories.toArray(new String[((PropertyViewer)PropertyViewer.this).mSelectedNode.viewNode.categories.size()]);
                }
                return new Object[0];
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int column) {
            if (PropertyViewer.this.mSelectedNode == null) {
                return null;
            }
            if (column == 1 && PropertyViewer.this.mPropertyValueEditingSupport.canEdit(element)) {
                return PropertyViewer.this.mImage;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getColumnText(Object element, int column) {
            PropertyViewer propertyViewer = PropertyViewer.this;
            synchronized (propertyViewer) {
                if (PropertyViewer.this.mSelectedNode != null) {
                    if (element instanceof String && column == 0) {
                        String category = (String)element;
                        return Character.toUpperCase(category.charAt(0)) + category.substring(1);
                    }
                    if (element instanceof ViewNode.Property) {
                        if (column == 0) {
                            String returnValue = ((ViewNode.Property)element).name;
                            int index = returnValue.indexOf(58);
                            if (index != -1) {
                                return returnValue.substring(index + 1);
                            }
                            return returnValue;
                        }
                        if (column == 1) {
                            return ((ViewNode.Property)element).value;
                        }
                    }
                }
                return "";
            }
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

