/*
 * Decompiled with CFR 0.152.
 */
package com.yxz.suit;

import com.yxz.entity.Message;
import com.yxz.suit.ErrorHandler;
import com.yxz.suit.exp.SuitException;
import com.yxz.suit.handler.SuitHandler;
import com.yxz.suit.protocol.SuitCodeFactory;
import com.yxz.util.MessageUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class Controller {
    private static Controller INSTANCE = new Controller();
    static final int CONNECT_TIMEOUT = 1500;
    private IoSession session;
    private NioSocketConnector connector = new NioSocketConnector();
    private SuitHandler handler;
    private int sdpPort;
    private String host;
    private DatagramSocket socket;
    private ErrorHandler errorHandler;
    private String mySdp;
    public Object LOCK = new Object();
    public Object SESSION_LOCK = new Object();
    private Socket holeSocket;
    private Long sessionId;

    private Controller() {
    }

    public static Controller getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String host, int port, int sdpPort, ErrorHandler errorHandler) throws SuitException {
        this.errorHandler = errorHandler;
        this.host = host;
        this.sdpPort = sdpPort;
        this.handler = new SuitHandler(errorHandler);
        this.connector = new NioSocketConnector();
        this.connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new SuitCodeFactory()));
        this.connector.setHandler((IoHandler)this.handler);
        this.connector.setConnectTimeoutMillis(1500L);
        try {
            ConnectFuture future = this.connector.connect((SocketAddress)new InetSocketAddress(host, port));
            future.awaitUninterruptibly();
            this.session = future.getSession();
        }
        catch (RuntimeIoException e) {
            throw new SuitException("connect to server timeout");
        }
        Object object = this.SESSION_LOCK;
        synchronized (object) {
            try {
                this.SESSION_LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.session == null) {
            throw new SuitException("connect to server timeout");
        }
    }

    public void disconnect() {
        block12: {
            if (this.socket != null) {
                try {
                    try {
                        this.socket.close();
                    }
                    catch (Exception exception) {
                        this.socket = null;
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.socket = null;
                    throw throwable;
                }
                this.socket = null;
            }
        }
        if (this.holeSocket != null) {
            try {
                try {
                    this.holeSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.holeSocket = null;
                }
            }
            finally {
                this.holeSocket = null;
            }
        }
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.holeSocket != null) {
            try {
                this.holeSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.session.close(true);
        this.connector.dispose();
    }

    public void regist(String etc1, String etc2) {
        Message m = new Message();
        m.setEtc1(etc1);
        m.setEtc2(etc2);
        m.setType(1);
        this.session.write((Object)MessageUtils.toJson((Message)m));
    }

    public String catchSdp() throws IOException, SuitException {
        this.socket = new DatagramSocket();
        byte[] buf = new byte[4];
        DatagramPacket packet = new DatagramPacket(buf, 4);
        packet.setSocketAddress(new InetSocketAddress(this.host, this.sdpPort));
        String sdp = null;
        int i = 0;
        while (i < 3) {
            this.socket.send(packet);
            try {
                byte[] buffer = new byte[1024];
                DatagramPacket p = new DatagramPacket(buffer, 1024);
                this.socket.receive(p);
                sdp = new String(buffer, 0, p.getLength());
                break;
            }
            catch (Exception exception) {
                ++i;
            }
        }
        if (sdp == null) {
            throw new SuitException("can not get sdp");
        }
        this.mySdp = sdp = String.valueOf(sdp) + "-" + InetAddress.getLocalHost().getHostAddress() + ":" + this.socket.getLocalPort();
        return sdp;
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Long sessionId) {
        this.sessionId = sessionId;
    }

    public String getMySdp() {
        return this.mySdp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket holePunch(Long id) throws IOException, SuitException {
        String sdp = this.catchSdp();
        Message m = new Message();
        m.setType(2);
        m.setSdp(sdp);
        m.setSessionId(id);
        this.session.write((Object)MessageUtils.toJson((Message)m));
        Object object = this.LOCK;
        synchronized (object) {
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.holeSocket;
    }

    public void setHoleSocket(Socket holeSocket) {
        this.holeSocket = holeSocket;
    }

    public Socket getHoleSocket() {
        return this.holeSocket;
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    public static void main(String[] args) throws SuitException, IOException {
        Controller.getInstance().init("127.0.0.1", 8888, 8888, null);
        Controller.getInstance().holePunch(1L);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Controller.getInstance().close();
    }
}

