/*
 * Decompiled with CFR 0.152.
 */
package com.yxz.suit.handler;

import com.yxz.entity.Message;
import com.yxz.suit.ErrorHandler;
import com.yxz.suit.processor.HolePunchProcessor;
import com.yxz.util.MessageUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;

public class SuitHandler
extends IoHandlerAdapter {
    static Log LOG = LogFactory.getLog(SuitHandler.class);
    private ErrorHandler errorHandler;
    private HolePunchProcessor holePunchProcessor;

    public SuitHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.holePunchProcessor = new HolePunchProcessor(errorHandler);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        LOG.info(message);
        Message m = MessageUtils.toMessage((String)message.toString());
        if (m.getType() == -1) {
            this.errorHandler.handleError(m);
        } else {
            this.errorHandler.handleMsg(m);
        }
        this.holePunchProcessor.process(m, session);
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        LOG.info((Object)cause);
    }
}

