/*
 * Decompiled with CFR 0.152.
 */
package com.yxz.suit.peer;

import com.yxz.suit.Controller;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ice4j.pseudotcp.PseudoTcpSocket;
import org.ice4j.pseudotcp.PseudoTcpSocketFactory;

public class Peer {
    private InetSocketAddress address;
    private DatagramSocket socket;
    private boolean resend = true;
    static Log LOG = LogFactory.getLog(Peer.class);

    public Peer(InetSocketAddress address) {
        this.address = address;
        this.socket = Controller.getInstance().getSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void punching() {
        byte[] buf = new byte[2];
        DatagramPacket packet = new DatagramPacket(buf, 2);
        packet.setSocketAddress(this.address);
        PunchingThread pt = new PunchingThread(this);
        pt.start();
        int i = 0;
        while (i < 10) {
            try {
                if (!this.resend) break;
                LOG.info((Object)("try to punching, send package to " + this.address));
                this.socket.send(packet);
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        if (this.resend) {
            pt.setLive(false);
            LOG.info((Object)("punching to " + this.address + " fail!"));
        } else {
            LOG.info((Object)("punching to " + this.address + " success!"));
            PseudoTcpSocketFactory factory = new PseudoTcpSocketFactory();
            try {
                PseudoTcpSocket pseudoTcpSocket = factory.createSocket(this.socket);
                pseudoTcpSocket.connect(this.address, 10000);
                Controller.getInstance().setHoleSocket(pseudoTcpSocket);
                Object object = Controller.getInstance().LOCK;
                synchronized (object) {
                    Controller.getInstance().LOCK.notify();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class PunchingThread
    extends Thread {
        private Peer peer;
        private boolean live = true;

        public PunchingThread(Peer peer) {
            this.peer = peer;
        }

        @Override
        public void run() {
            byte[] buf = new byte[2];
            DatagramPacket packet = new DatagramPacket(buf, 2);
            while (this.live) {
                try {
                    this.peer.socket.receive(packet);
                    this.peer.resend = false;
                    packet.setSocketAddress(this.peer.address);
                    this.peer.socket.send(packet);
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void setLive(boolean live) {
            this.live = live;
        }
    }
}

