/*
 * Decompiled with CFR 0.152.
 */
package com.yxz.suit.processor;

import com.yxz.entity.Message;
import com.yxz.suit.Controller;
import com.yxz.suit.ErrorHandler;
import com.yxz.suit.peer.Peer;
import com.yxz.suit.proxy.ControlledProxy;
import com.yxz.suit.proxy.ControllerProxy;
import com.yxz.util.MessageUtils;
import java.net.InetSocketAddress;
import org.apache.mina.core.session.IoSession;

public class HolePunchProcessor {
    private ErrorHandler errorHandler;
    private String otherSdp;
    private String mySdp;

    public HolePunchProcessor(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Message m, IoSession session) {
        if (m.getType() == 2) {
            try {
                String sdp = Controller.getInstance().catchSdp();
                this.otherSdp = m.getSdp();
                this.mySdp = sdp;
                m.setSdp(this.mySdp);
                m.setType(3);
                session.write((Object)MessageUtils.toJson((Message)m));
            }
            catch (Exception e) {
                this.errorHandler.handleError(m);
            }
        } else if (m.getType() == 4) {
            Peer peer = new Peer(this.getSocketAddress());
            peer.punching();
            if (Controller.getInstance().getHoleSocket() != null) {
                ControlledProxy proxy = new ControlledProxy(3389, Controller.getInstance().getHoleSocket());
                try {
                    proxy.start();
                    proxy.close();
                    Controller.getInstance().disconnect();
                }
                catch (Exception e) {
                    Message msg = new Message();
                    msg.setType(-1);
                    msg.setEtc1(e.getMessage());
                    this.errorHandler.handleError(msg);
                }
            }
        } else if (m.getType() == 3) {
            this.otherSdp = m.getSdp();
            this.mySdp = Controller.getInstance().getMySdp();
            Peer peer = new Peer(this.getSocketAddress());
            peer.punching();
            if (Controller.getInstance().getHoleSocket() != null) {
                ControllerProxy proxy = new ControllerProxy(8898, Controller.getInstance().getHoleSocket());
                try {
                    proxy.start();
                    proxy.close();
                    Controller.getInstance().disconnect();
                }
                catch (Exception e) {
                    Message msg = new Message();
                    msg.setType(-1);
                    msg.setEtc1(e.getMessage());
                    this.errorHandler.handleError(msg);
                }
            }
        } else if (m.getType() == 5) {
            Controller.getInstance().setSessionId(m.getSessionId());
            Object object = Controller.getInstance().SESSION_LOCK;
            synchronized (object) {
                Controller.getInstance().SESSION_LOCK.notify();
            }
        }
    }

    private InetSocketAddress getSocketAddress() {
        String otherRemoteHost = this.otherSdp.split("-")[0].split(":")[0];
        int otherRemotePort = Integer.parseInt(this.otherSdp.split("-")[0].split(":")[1]);
        String otherLocalHost = this.otherSdp.split("-")[1].split(":")[0];
        int otherLocalPort = Integer.parseInt(this.otherSdp.split("-")[1].split(":")[1]);
        String myRemoteHost = this.mySdp.split("-")[0].split(":")[0];
        if (otherRemoteHost.equals(myRemoteHost)) {
            return new InetSocketAddress(otherLocalHost, otherLocalPort);
        }
        return new InetSocketAddress(otherRemoteHost, otherRemotePort);
    }
}

