/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.spring.ssl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class KeyStoreFactoryBean
extends AbstractFactoryBean {
    private String type = "JKS";
    private String provider = null;
    private char[] password = null;
    private File file = null;
    private Resource resource = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createInstance() throws Exception {
        if (this.file == null && this.resource == null) {
            throw new IllegalArgumentException("Required property missing. Either 'file' or 'resource' have to be specified");
        }
        KeyStore ks = null;
        ks = this.provider == null ? KeyStore.getInstance(this.type) : KeyStore.getInstance(this.type, this.provider);
        InputStream is = null;
        is = this.file != null ? new BufferedInputStream(new FileInputStream(this.file)) : this.resource.getInputStream();
        try {
            ks.load(is, this.password);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return ks;
    }

    public Class getObjectType() {
        return KeyStore.class;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setPassword(String password) {
        this.password = (char[])(password != null ? password.toCharArray() : null);
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setType(String type) {
        Assert.notNull((Object)type, (String)"Property 'type' may not be null");
        this.type = type;
    }
}

