﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true" Inherits="Kesion.NET.WebSite.Admin.Content.KS_ContentCartogram" Codebehind="KS.ContentCartogram.aspx.cs" %>
<asp:Content ID="Content1" ContentPlaceHolderID="KSContent" runat="server">
<link href="/admin/images/chart.css" rel="stylesheet" type="text/css">
<div class="content-area" style="margin-top:20px;">
  <div class="chart-num" id="chart-num1">
      <div class="chart-data">
	     <table width="100%" border="0" cellpadding="0" cellspacing="0" class="chart-d-table">
		    <tr>
			   <th rowspan="2" class="chart-t-title">人才库增长</th>
			    <%=year %>
			</tr>
			<tr>
			  <%=yearcount %>
			</tr>
		 </table>
	  </div>
	  <div class="chart-img clearfix">
	     <div class="chart-w49 fl">
		    <div id="num1chart-img1"></div>
		 </div>
		 <div class="chart-w49 fr">
		    <div id="num1chart-img2"></div>
		 </div>
	  </div>
  </div> 
  <div class="chart-num" id="chart-num2">
      <div class="chart-data">
	     <table width="100%" border="0" cellpadding="0" cellspacing="0" class="chart-d-table">
		    <tr>
			   <th rowspan="2" class="chart-t-title">性别分布</th>
			   <%=sex %>
			   <th>合计</th>
			</tr>
			<tr><%=sexcount %>
			</tr>
		 </table>
	  </div>
	  <div class="chart-img clearfix">
	     <div class="chart-w49 fl">
		    <div id="num2chart-img1"></div>
		 </div>
		 <div class="chart-w49 fr">
		    <div id="num2chart-img2"></div>
		 </div>
	  </div>
  </div>
  <div class="chart-num" id="chart-num3">
      <div class="chart-data">
	     <table width="100%" border="0" cellpadding="0" cellspacing="0" class="chart-d-table">
		    <tr>
			   <th rowspan="2" class="chart-t-title">人员类别</th>
			   <th>专业技术</th>
			   <th>企业管理</th>
			   <th>高技能</th>
			   <th>农村实用</th>
			   <th>急需引进</th>
			   <th>社会工作</th>
			   <th>领军人才</th>
			   <th>优秀专家</th>
			   <th>选调生</th>
			   <th>驻酒单位</th>
			   <th>其他</th>
			</tr>
			<tr>
			   <td><%=peopletype[0] %></td>
			   <td><%=peopletype[1] %></td>
			   <td><%=peopletype[2] %></td>
			   <td><%=peopletype[3] %></td>
			   <td><%=peopletype[4] %></td>
			   <td><%=peopletype[5] %></td>
			   <td><%=peopletype[6] %></td>
			   <td><%=peopletype[7] %></td>
			   <td><%=peopletype[8] %></td>
			   <td><%=peopletype[9] %></td>
			   <td><%=peopletype[10] %></td>
			</tr>
		 </table>
	  </div>
	  <div class="chart-img clearfix">
	     <div class="chart-w49 fl">
		    <div id="num3chart-img1"></div>
		 </div>
		 <div class="chart-w49 fr">
		    <div id="num3chart-img2"></div>
		 </div>
	  </div>
  </div> 
</div>
<script src="/admin/images/highcharts.js"></script>
<script>
//人才库折线图
var chart = new Highcharts.Chart('num1chart-img1', {
    title: {
        text: '人才库年度增长（折线）',
        x: -20
    },
    xAxis: {
        categories: [<%=yeartu %>]
    },
    yAxis: {
        title: {
            text: ' '
        }
    },
    legend: {
        layout: 'vertical',
        align: 'right',
        verticalAlign: 'middle',
        borderWidth: 0
    },
    series: [{
        name: ' ',
        data: [<%=yearcounttu %>]
    }]
});

$(function () {
	
	//人才库柱状图
    $('#num1chart-img2').highcharts({
        chart: {
            type: 'column'
        },
        title: {
            text: '人才库年度增长（柱图）'
        },
        xAxis: {
            categories: [
                <%=yeartu %>
            ],
            crosshair: true
        },
        yAxis: {
            min: 0,
            title: {
                text: ' '
            }
        },
        tooltip: {
            headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
            '<td style="padding:0"><b>{point.y} </b></td></tr>',
            footerFormat: '</table>',
            shared: true,
            useHTML: true
        },
        plotOptions: {
            column: {
                pointPadding: 0.2,
                borderWidth: 0
            }
        },
        series: [{
            name: ' ',
            data: [<%=yearcounttu %>]
        }]
    });
	
	//性别分布饼形
    $('#num2chart-img1').highcharts({
        chart: {
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false
        },
        title: {
            text: '性别分布（饼形图）'
        },
        tooltip: {
            headerFormat: '{series.name}<br>',
            pointFormat: '{point.name}: <b>{point.percentage:.1f}%</b>'
        },
        plotOptions: {
            pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                dataLabels: {
                    enabled: false
                },
                showInLegend: true
            }
        },
        series: [{
            type: 'pie',
            name: ' ',
            data: [
                ['男',2122],
                ['女',128]
            ]
        }]
    });


	
	//性别分布柱图
	$('#num2chart-img2').highcharts({
        chart: {
            type: 'column'
        },
        title: {
            text: '性别分布（柱图）'
        },
        xAxis: {
            type: 'category',
            labels: {
                rotation: -45,
            }
        },
        yAxis: {
            min: 0,
            title: {
                text: ' '
            }
        },
        legend: {
            enabled: false
        },
        tooltip: {
            pointFormat: '<b>{point.y} </b>'
        },
        series: [{
            name: ' ',
            data: [
                <%=sextiao %>
            ],
            dataLabels: {
                enabled: true,
                rotation: -90,
                color: '#FFFFFF',
                align: 'right',
                format: ' ', 
                y: 10,
            }
        }]
    });

	//人员类别饼形图
	$('#num3chart-img1').highcharts({
        chart: {
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false
        },
        title: {
            text: '人员类别（饼形图）'
        },
        tooltip: {
            headerFormat: '{series.name}<br>',
            pointFormat: '{point.name}: <b>{point.percentage:.1f}%</b>'
        },
        plotOptions: {
            pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                dataLabels: {
                    enabled: false
                },
                showInLegend: true
            }
        },
        series: [{
            type: 'pie',
            name: ' ',
            data: [
                <%=peoplecontent %>
            ]
        }]
    });
	
	
	//人员类别柱图
	$('#num3chart-img2').highcharts({
        chart: {
            type: 'column'
        },
        title: {
            text: '人员类别（柱图）'
        },
        xAxis: {
            type: 'category',
            labels: {
                rotation: -45,
            }
        },
        yAxis: {
            min: 0,
            title: {
                text: ' '
            }
        },
        legend: {
            enabled: false
        },
        tooltip: {
            pointFormat: '人才数量: <b>{point.y} </b>'
        },
        series: [{
            name: ' ',
            data: [
                <%=peoplecontent %>
            ],
            dataLabels: {
                enabled: true,
                rotation: -90,
                color: '#FFFFFF',
                align: 'right',
                format: ' ', 
                y: 10,
            }
        }]
    });
});

</script>
</asp:Content>
