﻿//2017.10.20 by zhuang
var form = {
	target:{
		selectNumber:'',
		selectNumberBox:'',
	},
	selectNumber:function(target,num,other,minNumber){
		/*
		 *target 操作对象
		 *num 显示条数
		 *other 用于判断类型
		 *minNum 最小值
		 */
		var minNum = minNumber || 1;
		_this = $(target);
		this.target.selectNumber = $(target);
		$('.selectNumber').find('.number').removeClass('focus');
		_this.addClass('focus');
		window.event.stopPropagation();
		var offset = {
			left:_this.offset().left,
			top:_this.offset().top+_this.outerHeight()
		};
		var activeVal = _this.text();
		$('#selectNumberBox').remove();
		$('body').append('<div id="selectNumberBox"></div>');
		var selectNumberBox = $('#selectNumberBox');
		this.target.selectNumberBox = selectNumberBox;
		selectNumberBox.css({left:''+offset.left+'px',top:''+offset.top+'px'}).html('').fadeIn(200);
		var optionType = '';
		if(other){
			optionType = ' data-type="'+other+'"'
		};
		for(var i=0;i<num;i++){
			if(i>=minNum-1){
				var numText = i+1;
				if(i==activeVal-1){
					selectNumberBox.append('<div'+optionType+' class="option active" onClick="form.numberOption(this)">'+numText+'</div>');
				}else{
					selectNumberBox.append('<div'+optionType+' class="option" onClick="form.numberOption(this)">'+numText+'</div>');
				}
			}
		};
		
		selectNumberBox.click(function(e){
			var e = window.event || e;
			e.stopPropagation();
		});

		$(document).click(function(){
			selectNumberBox.fadeOut(200);
			$('.selectNumber').find('.number').removeClass('focus');
		});

	},
	numberOption:function(target){
		$(target).addClass('active').siblings().removeClass('active');
		this.target.selectNumber.text($(target).text())
		//特别处理
		if($(target).attr('data-type')=='ratio'){
			var numText = 12/this.target.selectNumber.text();
			$('#ratioNumber').html('');
			for(var i=0;i<this.target.selectNumber.text();i++){
				if(i==0){
					$('#ratioNumber').append('<div data-type="ratioTotal" class="number ratio-number">'+numText+'</div>');
				}else{
					$('#ratioNumber').append('<div class="ratio-colon">:</div><div class="number ratio-number">'+numText+'</div>');
				}
			}

			formatSplit.ratioNumberClick();

		}else if($(target).attr('data-type')=='ratioTotal'){
			
			var total = 0;
			
			$('.ratio-number').each(function(){
				total += parseInt($(this).text());
			});

			var result = 12-total;
			var ratioLength = $('.ratio-colon').length;
			var r = ratioLength;
			var a = new Array();
			for(var i=0;i<ratioLength;i++){
				var mean = Math.ceil(result/r);
				a.push(mean);
				result -= mean;
				r--;
			}
			var numIndex = 0;
			$('.ratio-number').each(function(){
				if($(this)[0].className.indexOf('focus')==-1&&a[numIndex]){
					var newText = parseInt($(this).text())+a[numIndex];
					numIndex++;
					$(this).text(newText);
				}
			});

		};

		this.target.selectNumber.removeClass('focus');
		this.target.selectNumberBox.hide();

	},
	checkbox:function(target){
		var $this = $(target);
		var name = $this.attr('name');
		$this.hide();
		if($this.is(':checked')==true){
			$this.after('<div class="drag-checkbox-style drag-checked" check-flag="1" check-name="'+name+'"><i></i></div>');
		}else{
			$this.after('<div class="drag-checkbox-style" check-flag="0" check-name="'+name+'"><i></i></div>');
		};
		
		$this.next('.drag-checkbox-style').on('click',function(){
			if($(this).attr('check-flag')=='0'){
				$(this).addClass('drag-checked');
				$(this).prev().attr('checked',true);
				$(this).attr('check-flag','1');
			}else{
				$(this).removeClass('drag-checked');
				$(this).prev().attr('checked',false);
				$(this).attr('check-flag','0');
				
			};
		});
		
		
	}
}
