﻿<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
  <meta name="renderer" content="webkit"> 
  <title>网站颜色配置</title>
  <link rel="Stylesheet" href="/admin/drag/css/drag.base.css">
  <link rel="Stylesheet" href="/admin/drag/css/kesion.form.css">
  <link rel="stylesheet" href="/admin/drag/color/colorpicker.css" />
  <style>
		.website-color .color-inner{ position:relative; padding-right:62px;margin-bottom:10px;}
		.website-color .ks-text{width:100%; font-size:13px; padding-left:40px;}
		.website-color .color-tit{ line-height:33px;color:#999; font-size:13px;}
		.recover-btn{ padding:15px 0px;}
  </style>    
  
</head>
<body>
   
    <div id="content">
        <div class="ks-form">
    		<ul>
            	<li style="border:0px;">
                    <div class="website-color clearfix">
                    	<div class="text-color">
                        	<div class="color-inner">
                                <div class="color-tit">网站主色</div>
                                <div class="colorpickerField">
                                    <input name="main-color" type="text" class="ks-text">
                                </div>
                            </div>
                        </div>
                    	<div class="text-color">
                        	<div class="color-inner">
                                <div class="color-tit">辅助色</div>
                                <div class="colorpickerField">
                                	<input name="auxiliary-color" type="text" class="ks-text">
                                </div>
                            </div>
                        </div>
                    	<div class="text-color">
                        	<div class="color-inner">
                                <div class="color-tit">默认文字</div>
                                <div class="colorpickerField">
                                	<input name="text-color" type="text" class="ks-text">
                                </div>
                            </div>
                        </div>
                    	<div class="text-color">
                        	<div class="color-inner">
                                <div class="color-tit">链接颜色</div>
                                <div class="colorpickerField">
                                	<input name="a-color" type="text" class="ks-text">
                                </div>
                            </div>
                        </div>
                    	<div class="text-color">
                        	<div class="color-inner">
                                <div class="color-tit">链接经过</div>
                                <div class="colorpickerField">
                                	<input name="a-hover-color" type="text" class="ks-text">
                                </div>
                            </div>
                        </div>
                    	<div class="text-color">
                        	<div class="color-inner">
                                <div class="color-tit">普通信息</div>
                                <div class="colorpickerField">
                                	<input name="info-color" type="text" class="ks-text">
                                </div>
                            </div>
                        </div>
                    	<div class="text-color">
                        	<div class="color-inner">
                                <div class="color-tit">次要信息</div>
                                <div class="colorpickerField">
                                	<input name="minor-color" type="text" class="ks-text">
                                </div>
                            </div>
                        </div>
                        <div class="clear"></div>
                        <div class="recover-btn"><button class="ks-btn ks-btn-line ks-btn-small">恢复初始配色方案</button></div>
                    </div>
                </li>
            </ul>
        </div>  
	</div>
 
     
    <div class="clear blank20" style="border-top:1px solid #ebebeb;"></div>
    <div class="ks-btn-center">
      <button class="ks-btn ks-btn-normal" onClick="colorConfig.save()" id="btn-save">保存</button>
      &nbsp;
      <button class="ks-btn" onClick="parent.closeSetWindow()">取消</button>
    
    </div>

    <script src="/admin/drag/js/utils.js"></script>
    <script>utils.loadJs(['jquery','colorpicker','nicescroll'])</script>

	<script>
		
		var cssPath = parent.tpDir+'/css/drag.setColor.css';
		var colorConfig = new utils.page({
			data:{
				initialColor:''
			},
			ready:function(){
				this.contHeight();
				$('#content').niceScroll({  
					cursorcolor:"rgba(0,0,0,0.2)",  
					cursoropacitymax:1,  
					touchbehavior:false,  
					cursorwidth:"6px",  
					cursorborder:"0", 
					cursorborderradius:"10px"  
				}); 
				
				//获取css文件信息
				var that = this;
				$.ajax({
					url:cssPath,
					success:function(css){
					   //获取初始颜色配置信息
						var initialColor = css.split('/*initialColor:/')[1].split('/*setColor:/')[0];
						that.data.initialColor = '/*initialColor:/'+initialColor;

						that.colorEach(css,'/*setColor:/');
						
					}
				});

				//恢复初始颜色
				$('.recover-btn').on('click','button',function(){
					  that.colorEach(that.data.initialColor,'/*initialColor:/');
					  
				});

			},
			colorEach:function(css,splitCode){
				//颜色配置
				var cssSplit = css.split(splitCode)[1].replace('*/','');
				var colorSplit = cssSplit.split('&');
				var colorLength = colorSplit.length;
				for(var c=0;c<colorLength;c++){
			  
					//主色
					if(colorSplit[c].indexOf('main-color=')!=-1){
					  var mainColor = colorSplit[c].replace('main-color=','');
					  $('input[name="main-color"]').val(mainColor);
					  
					//默认文字颜色
					}else if(colorSplit[c].indexOf('text-color=')!=-1){
					  var textColor = colorSplit[c].replace('text-color=','');
					  $('input[name="text-color"]').val(textColor);
					//链接颜色
					}else if(colorSplit[c].indexOf('a-color=')!=-1){
					  var aColor = colorSplit[c].replace('a-color=','');
					  $('input[name="a-color"]').val(aColor);
					//链接经过颜色
					}else if(colorSplit[c].indexOf('a-hover-color=')!=-1){
					  var aHoverColor = colorSplit[c].replace('a-hover-color=','');
					  $('input[name="a-hover-color"]').val(aHoverColor);
					//辅助颜色
					}else if(colorSplit[c].indexOf('auxiliary-color=')!=-1){
					  var auxiliaryColor = colorSplit[c].replace('auxiliary-color=','');
					  $('input[name="auxiliary-color"]').val(auxiliaryColor);
					  
					//普通信息颜色
					}else if(colorSplit[c].indexOf('info-color=')!=-1){
					  var infoColor = colorSplit[c].replace('info-color=','');
					  $('input[name="info-color"]').val(infoColor);
					//次要信息颜色
					}else if(colorSplit[c].indexOf('minor-color=')!=-1){
					  var minorColor = colorSplit[c].replace('minor-color=','');
					  $('input[name="minor-color"]').val(minorColor);
					};
				};

				//颜色配置
				$('.colorpickerField').each(function() {
					  var $that = $(this).find('input[type="text"]');
					  var color = $that.val();
					  $that.before('<i class="colorpickerDot" style="background:'+color+'"></i>');
					  $that.ColorPicker({
						  onSubmit: function(hsb, hex, rgb, el) {
							  $(el).val('#'+hex);
							   $that.prev('.colorpickerDot').css({background:'#'+hex});
							  $(el).ColorPickerHide();
						  },
						  onBeforeShow: function () {
							  $(this).ColorPickerSetColor(this.value);
						  },
						  onChange: function (hsb, hex, rgb) {
							 $that.val('#'+hex);
							 $that.prev('.colorpickerDot').css({background:'#'+hex});
						  }
					  }).bind('keyup', function(){
						  $(this).ColorPickerSetColor(this.value);
					  });
		            
		        });

			},
			contHeight:function(){
				var contHeight = $(window).height()-$('.ks-btn-center').outerHeight()-41;
				$('#content').height(contHeight);
			},
			save:function(){
				//配置css文件
				var textColor = $('input[name="text-color"]').val();
				var aColor = $('input[name="a-color"]').val();
				var aHoverColor = $('input[name="a-hover-color"]').val();
				var mainColor = $('input[name="main-color"]').val();
				var auxiliaryColor = $('input[name="auxiliary-color"]').val();
				var infoColor = $('input[name="info-color"]').val();
				var minorColor = $('input[name="minor-color"]').val();
				
				var cssResult = '@charset "utf-8";\n'+
								'body{ background:#fff;}\n'+
								'.ks-main-color{color:'+mainColor+' !important;border-color:'+mainColor+' !important;}\n'+
								'.ks-main-bg-color{ background-color:'+mainColor+' !important;border-color:'+mainColor+' !important;}\n'+
								'body,textarea,input,button,select,keygen,legend{color:'+textColor+';}\n'+
								'a{color:'+aColor+';}\n'+
								'a:hover{color:'+aHoverColor+';}\n'+
								'.ks-auxiliary-color{color:'+auxiliaryColor+' !important; border-color:'+auxiliaryColor+' !important;}\n'+
								'.ks-auxiliary-bgcolor{background:'+auxiliaryColor+' !important; border-color:'+auxiliaryColor+' !important;}\n'+
								'.ks-info-color{color:'+infoColor+' !important;}\n'+
								'.ks-minor-color{color:'+minorColor+' !important;}\n'+
								'.ks-mbtn{ background-color:'+mainColor+' !important;border-color:'+mainColor+' !important; }\n'+
								'.ks-mbtn-line{ color:'+mainColor+' !important;border-color:'+mainColor+' !important;}\n'+
								'.ks-mbtn-line:hover{ background-color:'+mainColor+' !important;color:#fff !important;}\n'+
								'.m-header.m-bg-white .nav-item a,\n'+
								'.m-head1.m-bg-white .m-head-bottom .nav-item a{color:'+aColor+';}\n'+
								'.m-head1.m-bg-white .m-head-bottom,\n'+
								'.m-header.m-bg-white .m-userintro{color:'+infoColor+';}\n'+
								'.m-paging1 a{border:1px solid '+infoColor+'; color:'+infoColor+';}\n'+		
								'.m-paging1 a.curr,\n'+		
								'.m-paging1 a:hover{border:1px solid '+mainColor+';color:'+mainColor+';}\n'+		
								'.m-paging2 a:hover,\n'+		
								'.m-paging2 a.curr{ background:'+mainColor+';color:#fff;}\n'+		
								'.m-paging4 a,\n'+		
								'.m-paging-span{color:'+infoColor+';}\n'+		
								'.m-paging4 a:hover,\n'+		
								'.m-paging-span:hover{border:1px solid '+mainColor+';color:'+mainColor+';}\n'+		
								'.m-paging5 a{ color:'+infoColor+';}\n'+		
								'.m-paging5 a:hover,\n'+		
								'.m-paging5 a.curr{border:1px solid '+mainColor+';color:'+mainColor+';}\n'+		
								'.m-paging5 a.curr{background:'+mainColor+';color:#fff;}\n'+
								''+this.data.initialColor+''+
								'/*setColor:/main-color='+mainColor+'&text-color='+textColor+'&a-color='+aColor+'&a-hover-color='+aHoverColor+'&auxiliary-color='+auxiliaryColor+'&info-color='+infoColor+'&minor-color='+minorColor+'*/';

				
			
				//save
				$.post("/plus/AjaxLabel.aspx",{content:cssResult,action:"savetemplate",skinid:parent.skinId,templatePath:cssPath},
				function(data){
					   if(data=='success'){
					   		parent.popup.tips({
								  title:'保存成功，请刷新页面查看效果',
							});

					   }
					  
				},"text");
				
			}
		});

    </script>


</body>
</html>
