﻿<!doctype html>
<html>
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta name="renderer" content="webkit"> 
	<title>版式拆分</title>
	<link type="text/css" rel="Stylesheet" href="/admin/drag/css/drag.frame.css">
  
</head>
<body>
   
   	
    <div class="drag-setupBox">
    
        <div id="tab-box">
            
            <div class="formatBox">
            	
                <div class="box" style="padding-left:30px;">
                
                    <div class="text">
                        <div class="row">
                        	<div class="tit">拆分类型</div>
                            <div>
                                <label><input name="splitType" type="radio" value="col" checked>列</label>
                            	<label><input name="splitType" type="radio" value="row">行</label>
                            </div> 
                             
                            <div class="clear"></div>
                        </div>
                        
                        <div class="row">
                        	<div class="tit">拆分数量</div>
                            
                            <div class="selectNumber clearfix">
	                            <span class="number" id="splitNum" style="width: 120px">2</span>
                            </div>
                            <div class="clear"></div>
                        </div>

                        <div class="row" id="ratioRow">
                        	<div class="tit">比例设置</div>
                            <div class="selectNumber clearfix" id="ratioNumber">
	                            <div class="number ratio-number">6</div>
                            	<div class="ratio-colon">:</div>
                            	<div class="number ratio-number">6</div>
                            	
                            	
                            </div>
                            <div class="tips" style="margin:5px 0 0 15px;">我们将比例划分为12块，即占比100% = 12，50% = 6，33.3% = 4，25% = 3
                          
                            </div>
                            
                            <div class="clear"></div>
                        </div>

                    </div>
                    
                </div>
               
            </div><!--formatBox-->

   
        </div>

        <div class="drag-buttonBox"><span class="d-inline-block"><div class="drag-btn-main" onClick="formatSplit.determine()">确定</div><div class="drag-btn-gray" onClick="parent.closeWindow(window.name)">取消</div></span></div>

	</div>


    <script src="/admin/drag/js/utils.js"></script>
    <script>utils.loadJs(['jquery','form','nicescroll'])</script>
	<script>

		var formatSplit = new utils.page({
			ready:function(){
				this.tabHeight();
				this.ratioNumberClick();
				$('#splitNum').click(function(){
					form.selectNumber(this,4,'ratio',2);
				});
				$('input[name="splitType"]').click(function(){
					if(this.value=='row'){
						$('#ratioRow').fadeOut(200);
					}else{
						$('#ratioRow').fadeIn(200);
					}
				});
			},
			ratioNumberClick:function(){
				$('.ratio-number').click(function(){
					var total = 0;
					$('.ratio-number').each(function(){
						total += parseInt($(this).text());
					});
					var num = parseInt($(this).text())+12-total;
					form.selectNumber(this,num,'ratioTotal');
				});
			},
			tabHeight:function(){
				var tabHeight = $(window).height()-$('#tab').outerHeight()-$('.drag-buttonBox').outerHeight();
				$('#tab-box').height(tabHeight);
				
				$("#tab-box").niceScroll({  
					cursorcolor:"rgba(0,0,0,0.3)",  
					cursoropacitymax:1,  
					touchbehavior:false,  
					cursorwidth:"6px",  
					cursorborder:"0", 
					cursorborderradius:"6px"  
				}); 
			},
			determine:function(){

				//获取拆分类型 col || row
				var type = $('input[name="splitType"]:checked').val();
				var spacing = utils.getUrlParameter().formatSpacing;
				
				if(spacing==0){
					var spacingCss = '';
				}else{
					var spacingCss = ' style="margin:'+spacing+'px 0 0 '+spacing+'px;"'
				};

				if(type=='col'){
					var result = '';
					$('#ratioNumber').find('.number').each(function(){
						var colNum = $(this).text();
						result += '<div drag-format="sub" class="col-'+colNum+' clearfix"><div drag-addModule="true"'+spacingCss+'></div></div>'
					});
					
				}else{
					var result = '';
					var splitNum = $('#splitNum').text();
					for(var s=0;s<splitNum;s++){
						result += '<div drag-format="sub" class="col-12 clearfix"><div drag-addModule="true"'+spacingCss+'></div></div>';
					}

				};
				
			
				//返回结果
				parent.ModuleBack(result,'formatSplit');
				parent.closeWindow(window.name);//关闭窗口

			}

		});
    
    </script>


</body>
</html>