﻿namespace Kesion.NET.WebSite
{
    using System;
    using System.Drawing;
    using System.Drawing.Text;
    using System.Web.UI;
    using System.Web.UI.WebControls;
    using System.Xml;
    using Kesion.BLL;
    using Kesion.Cache;
    using Kesion.Components;
    using Kesion.Config;
    using Kesion.HtmlTags;
    using Kesion.Publics;
    using Kesion.XML;
    public partial class Admin_Config : BaseFun
    {
        private static string oldTemplate = string.Empty;
        private static string oldMobileTemplate = string.Empty;
        private static string oldSpaceTemplate = string.Empty;
        private static string oldSchoolTemplate = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            // KSSecurity.ModelID = "sys";    //模块ID号
            // KSSecurity.PowerID = "s001";   //子顶权限ID号
            KSSecurity.CheckPermissions();

            if (!IsPostBack)
            {
                InitConfig();
                InitalAttribute();
            }
        }

        private void InitalAttribute()
        {


            if (Utils.GetSysInfo("//sysinfo/isbusiness").ToLower() != "true") //非商业版本
            {
                this.OfficialInfo.Items[0].Enabled = false;
                this.OfficialInfo.Items[1].Enabled = false;
                this.SiteKey.Enabled = false;

                this.ftp.Attributes.Add("disabled", "true");
                this.ftp.Attributes.Add("onclick", "alert('当前使用的是体验版本，暂无开放此功能！');");
            }
            else
            {
                this.OfficialInfo.Items[0].Enabled = true;
                this.OfficialInfo.Items[1].Enabled = true;
                this.SiteKey.Enabled = true;

            }


            this.TopNav1.Text = "网站参数设置";
            this.Tips1.ImagePath = "../../admin/images/tipsico/";
            this.CopyRight1.CancelButtonEnabled = "false";
            this.CopyRight1.SubmitButtonText = "确定设置(O)";

            Utils.SetButtonDisabled((Button)this.CopyRight1.FindControl("submitbutton"));


            this.FsoIndexExt.Attributes["onclick"] = "showfsotime();";
            this.RdbUserNameType.Attributes["onclick"] = "showLoginType()";

            this.SiteName.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','网站的名称，用于在位置导航等地方里显示!如：KesionCMS官方站->新闻中心','50','down')");
            this.SiteName.Attributes.Add("onmouseout", "hidehintinfo()");

            this.InstallDir.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','系统安装的路径，系统会自动获取，但需要手工保存!<br/>前台模板用{$GetInstallDir}调用。','50','up')");
            this.InstallDir.Attributes.Add("onmouseout", "hidehintinfo()");

            this.WebLogo.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','前台模板用{$GetSiteLogo}调用可以得到该Logo地址。','50','up')");
            this.WebLogo.Attributes.Add("onmouseout", "hidehintinfo()");

            this.FsoIndexExt.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','网站首页的扩名设置，如果首页不想生成请设置扩展名为.aspx!','50','up')");
            this.FsoIndexExt.Attributes.Add("onmouseout", "hidehintinfo()");

            this.SiteKey.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','网站的授权注册码，商业版本请填写官方提供的25位授权码，免费版本请填写&quot;0&quot;','50','up')");
            this.SiteKey.Attributes.Add("onmouseout", "hidehintinfo()");


            this.CopyRight.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','网站的版权信息声明，可用标签{$GetCopyRight}在模板里进行调用','50','up')");
            this.CopyRight.Attributes.Add("onmouseout", "hidehintinfo()");

            this.SiteTitle.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','例如：厦门科汛软件有限公司官方站<br/>在模板里可以用标签{$GetSiteTitle}调用。','50','up')");
            this.SiteTitle.Attributes.Add("onmouseout", "hidehintinfo()");
            this.TxtMetaKeywords.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','例如：&ltmeta name=&quot;Keywords&quot; content=&quot;Kesion ICMS,IExam,IMall网站系统&quot;/&gt;<br/>在模板里可以用标签{$GetMetaKeyWords}调用。','50','up')");
            this.TxtMetaKeywords.Attributes.Add("onmouseout", "hidehintinfo()");
            this.TxtMetaDescript.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','例如：&ltmeta name=&quot;Description&quot; content=&quot;KesionEDU网校系统是由厦门科汛软件有限公司基于ASP.Net+MSSQL 2008技术开发的在线教育系统，是经过多年的经验积累&quot;/&gt;<br/>在模板里可以用标签{$GetMetaDescript}调用。','50','up')");
            this.TxtMetaDescript.Attributes.Add("onmouseout", "hidehintinfo()");


            //会员选项
            this.UserSystemTF.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','若关闭本站将不能使用会员功能，包括投稿，消费等等！','50','down')");
            this.UserSystemTF.Attributes.Add("onmouseout", "hidehintinfo()");
            this.UserAllowRegTF.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','若设为不允许，本站将不接纳新会员的注册申请！','50','up')");
            this.UserAllowRegTF.Attributes.Add("onmouseout", "hidehintinfo()");

            this.CkbEnabledRegField.Items[0].Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','若设为开启会员组注册，则用户可以选择自己的用户组进行注册！','50','up')");
            this.CkbEnabledRegField.Items[0].Attributes.Add("onmouseout", "hidehintinfo()");
            this.CkbEnabledRegField.Items[3].Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','若开启注册验证码认证或注册成功手机短信提示，则需要选中此项！','50','up')");
            this.CkbEnabledRegField.Items[3].Attributes.Add("onmouseout", "hidehintinfo()");
            this.NoAllowRegUserName.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','不允许注册的用户名称，多个请用|线隔开，如admin|manage|kesion！','50','up')");
            this.NoAllowRegUserName.Attributes.Add("onmouseout", "hidehintinfo()");
            this.UserMutiLoginTF.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','限制一个会员同一时间只能在一台电脑上登录，这样可以有效防止会员号共用！','50','up')");
            this.UserMutiLoginTF.Attributes.Add("onmouseout", "hidehintinfo()");
            this.ScoreToPointRate.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','会员在本站赚取一定积分后，就可以根据这里设置的积分与点券兑换比率进行兑换，兑换后的点券可用于在本站消费，如浏览扣点文章等．','50','up')");
            this.ScoreToPointRate.Attributes.Add("onmouseout", "hidehintinfo()");
            this.ScoreToEdaysRate.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','会员在本站赚取一定积分后，就可以根据这里设置的积分与有效期兑换比率进行兑换，兑换后的有效天数可用于在本站消费，如浏览有效期内方可查看的文章等．','50','up')");
            this.ScoreToEdaysRate.Attributes.Add("onmouseout", "hidehintinfo()");
            this.MoneyToPointRate.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','会员给自己的账号购买充值后，就可以根据这里设置的资金与点券兑换比率进行兑换，兑换后的点券可用于在本站消费，如浏览扣点文章等．','50','up')");
            this.MoneyToPointRate.Attributes.Add("onmouseout", "hidehintinfo()");
            this.MoneyToEdaysRate.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','会员给自己的账号购买充值后，就可以根据这里设置的资金与有效期兑换比率进行兑换，兑换后的有效天数可用于在本站消费，如浏览有效期内方可查看的文章等．','50','up')");
            this.MoneyToEdaysRate.Attributes.Add("onmouseout", "hidehintinfo()");

            //其它选项
            this.TxtCurrencySymbol.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','前台模板可以使用标签{$GetCurrencySymbol}调用．','50','up')");
            this.TxtCurrencySymbol.Attributes.Add("onmouseout", "hidehintinfo()");
            this.TxtCurrencyUnit.Attributes.Add("onmouseover", "showhintinfo(this,0,0,'提示','前台模板可以使用标签{$GetCurrencyUnit}调用．','50','up')");
            this.TxtCurrencyUnit.Attributes.Add("onmouseout", "hidehintinfo()");


            this.UserMinChar.Attributes["onkeypress"]
                = this.UserMaxChar.Attributes["onkeypress"]
                = this.UserPerMinLogin.Attributes["onkeypress"]
                = this.UserPerMinAddScore.Attributes["onkeypress"]
                = this.UserRegAddMoney.Attributes["onkeypress"]
                = this.UserRegAddPoint.Attributes["onkeypress"]
                = this.UserRegAddScore.Attributes["onkeypress"]
                = this.ScoreToPointRate.Attributes["onkeypress"]
                = this.ScoreToEdaysRate.Attributes["onkeypress"]
                = this.MoneyToEdaysRate.Attributes["onkeypress"]
                = this.MoneyToPointRate.Attributes["onkeypress"]
                = this.ThumbsWidth.Attributes["onkeypress"]
                = this.ThumbsHeight.Attributes["onkeypress"]
                = this.WaterMarkTransParency.Attributes["onkeypress"]
                = "if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;";
            this.UserMinChar.Attributes["style"]
                = this.UserMaxChar.Attributes["style"]
                = this.UserPerMinLogin.Attributes["style"]
                = this.UserPerMinAddScore.Attributes["style"]
                = this.UserRegAddMoney.Attributes["style"]
                = this.UserRegAddPoint.Attributes["style"]
                = this.UserRegAddScore.Attributes["style"]
                = this.ScoreToPointRate.Attributes["style"]
                = this.ScoreToEdaysRate.Attributes["style"]
                = this.MoneyToEdaysRate.Attributes["style"]
                = this.MoneyToPointRate.Attributes["style"]
                = this.ThumbsWidth.Attributes["style"]
                = this.ThumbsHeight.Attributes["style"]
                = this.WaterMarkTransParency.Attributes["style"]
                = "text-align:center";


            //缩略图水印
            this.WaterMarkType.Attributes["onclick"] = "showwatermarkarea();";

            this.RdbRemoteAnnexTF.Attributes["onclick"] = "showFtp();";
            this.Rdb3GEnable.Attributes["onclick"] = "show3G();";
            this.RdbIsPoint.Attributes["onclick"] = "showPoint();";

        }

        public void LoadPosition(int selectid)
        {
            #region 加载水印设置界面
            position.Text = "<table width=\"260\" height=\"200\" border=\"0\" class=\"waterback\">";
            for (int i = 1; i < 10; i++)
            {
                if (i % 3 == 1) position.Text += "<tr>";
                if (selectid == i)
                {
                    position.Text += "<td width=\"33%\" align=\"center\"><input type=\"radio\" id=\"watermarkstatus\" name=\"watermarkstatus\"    value=\"" + i + "\" checked>#" + i + "</td>";
                }
                else
                {
                    position.Text += "<td width=\"33%\" align=\"center\"><input type=\"radio\" id=\"watermarkstatus\" name=\"watermarkstatus\"    value=\"" + i + "\" >#" + i + "</td>";

                }
                if (i % 3 == 0) position.Text += "</tr>";

            }

            position.Text += "</table><input type=\"radio\" id=\"watermarkstatus\" name=\"watermarkstatus\" value=\"0\" ";
            if (selectid == 0)
            {
                position.Text += " checked";
            }
            position.Text += ">不启用水印功能";
            #endregion

        }
        /// <summary>
        /// 加载字体
        /// </summary>
        /// <param name="v"></param>
        private void LoadWaterMarkFont(string v)
        {
            #region 加载字体
            InstalledFontCollection fonts = new InstalledFontCollection();
            foreach (FontFamily family in fonts.Families)
            {
                ListItem li = new ListItem();
                li.Text = family.Name;
                li.Value = family.Name;
                if (family.Name == v)
                {
                    li.Selected = true;
                }
                else
                {
                    li.Selected = false;
                }
                this.WaterMarkFontName.Items.Add(li);
            }
            #endregion
        }
        private void InitConfig()
        {
            try
            {
                ConfigInfo __configinfo = ConfigManage.Deserialize(Server.MapPath("../../config/general.config"));

                this.SiteName.Text = __configinfo.SiteName;
                this.SiteTitle.Text = __configinfo.SiteTitle;
                this.Domain.Text = __configinfo.Domain;
                //this.InstallDir.Text = BaseConfigManage.InstallDir;
                this.InstallDir.Text = KSCMS.GetInstallDir();
                this.WebLogo.Text = __configinfo.WebLogo;
                this.SpecialFsoTF.SelectedValue = __configinfo.SpecialFsoTF.ToString();

                string FsoIndex = __configinfo.FSOIndex;
                string[] FIArr = FsoIndex.Split('.');
                IndexFile.Items.FindByValue(FIArr[0].ToString().ToLower()).Selected = true;
                FsoIndexExt.Items.FindByValue("." + FIArr[1].ToString().ToLower()).Selected = true;

                this.TxtCacheTime.Text = __configinfo.CacheTime.ToString();
                this.DefaultUpFileSize.Text = __configinfo.DefaultUpFileSize.ToString();
                this.DefaultUpFileType.Text = __configinfo.DefaultUpFileType;
                this.WebMaster.Text = __configinfo.WebMaster;

                if (__configinfo.OfficialInfo.IndexOf('1') >= 0)
                {
                    this.OfficialInfo.Items[0].Selected = true;
                }
                if (__configinfo.OfficialInfo.IndexOf('2') >= 0)
                {
                    this.OfficialInfo.Items[1].Selected = true;
                }
                if (__configinfo.OfficialInfo.IndexOf('3') >= 0)
                {
                    this.OfficialInfo.Items[2].Selected = true;
                }
                if (__configinfo.OfficialInfo.IndexOf('4') >= 0)
                {
                    this.OfficialInfo.Items[3].Selected = true;
                }

                this.SiteKey.Text = __configinfo.SiteKey;
                this.CopyRight.Text = __configinfo.CopyRight;
                this.TxtMetaKeywords.Text = __configinfo.MetaKeyWords;
                this.TxtMetaDescript.Text = __configinfo.MetaDescript;


                //模板选项
                this.IndexTemplate.Text = __configinfo.IndexTemplate;
                this.SpecialIndexTemplate.Text = __configinfo.SpecialIndexTemplate;
                this.UserIndexTemplate.Text = __configinfo.UserIndexTemplate;
                this.SearchTemplate.Text = __configinfo.SearchTemplate;
                this.TxtAutoCreateIndexTime.Text = __configinfo.AutoCreateIndexTime.ToString();
                this.PKIndexTemplate.Text = __configinfo.PKIndexTemplate;
                this.PKContentTemplate.Text = __configinfo.PKContentTemplate;
                this.PKMoreTemplate.Text = __configinfo.PKMoreTemplate;

                //会员选项
                this.UserSystemTF.SelectedValue = __configinfo.UserSystemTF.ToString();
                this.UserAllowRegTF.SelectedValue = __configinfo.UserAllowRegTF.ToString();
                try
                {
                    this.UserLience.Text = XmlObject.ReadXmlReturnNode(Server.MapPath("~/config/commontemplate.config"), "//labeltemplate/label[@name='regLience']");
                    this.TxtRegSuccMail.Text = XmlObject.ReadXmlReturnNode(Server.MapPath("~/config/commontemplate.config"), "//labeltemplate/label[@name='regSendMail']");
                }
                catch
                {
                }

                foreach (ListItem li in this.CkbEnabledRegField.Items)
                {
                    if (Utils.InArray(li.Value, __configinfo.EnabledRegField, ",", false))
                    {
                        li.Selected = true;
                    }
                    else
                    {
                        li.Selected = false;
                    }
                }


                this.UserEmailMutiRegTF.SelectedValue = __configinfo.UserEmailMutiRegTF.ToString();
                this.UserMinChar.Text = __configinfo.UserMinChar.ToString();
                this.UserMaxChar.Text = __configinfo.UserMaxChar.ToString();
                this.NoAllowRegUserName.Text = __configinfo.NoAllowRegUserName;
                this.UserMutiLoginTF.SelectedValue = __configinfo.UserMutiLoginTF.ToString();
                this.UserPerMinLogin.Text = __configinfo.UserPerMinLogin.ToString();
                this.UserPerMinAddScore.Text = __configinfo.UserPerMinLoginAddScore.ToString();
                this.UserRegAddMoney.Text = __configinfo.UserRegAddMoney.ToString();
                this.UserRegAddPoint.Text = __configinfo.UserRegAddPoint.ToString();
                this.UserRegAddScore.Text = __configinfo.UserRegAddScore.ToString();
                this.ScoreToEdaysRate.Text = __configinfo.ScoreToEdaysRate.ToString();
                this.ScoreToPointRate.Text = __configinfo.ScoreToPointRate.ToString();
                this.MoneyToEdaysRate.Text = __configinfo.MoneyToEdaysRate.ToString();
                this.MoneyToPointRate.Text = __configinfo.MoneyToPointRate.ToString();
                this.PointName.Text = __configinfo.PointName;
                this.PointUnit.Text = __configinfo.PointUnit;



                //图片缩略图水印
                this.ThumbsWidth.Text = __configinfo.ThumbsWidth.ToString();
                this.ThumbsHeight.Text = __configinfo.ThumbsHeight.ToString();
                this.WaterMarkType.SelectedValue = __configinfo.WaterMarkType.ToString();
                this.WaterMarkTxt.Text = __configinfo.WaterMarkTxt;
                LoadWaterMarkFont(__configinfo.WaterMarkFontName);
                // this.WaterMarkFontName.SelectedValue = __configinfo.WaterMarkFontName;
                this.WaterMarkFontSize.Text = __configinfo.WaterMarkFontSize.ToString();
                this.WaterMarkFontColor.Text = __configinfo.WaterMarkFontColor;
                this.WaterMarkFontStyle.SelectedValue = __configinfo.WaterMarkFontStyle;
                this.WaterMarkFontBgColor.Text = __configinfo.WaterMarkFontBgColor;
                this.WaterMarkPic.Text = __configinfo.WaterMarkPic;
                this.WaterMarkTransParency.Text = __configinfo.WaterMarkTransParence.ToString();

                if (__configinfo.WaterMarkType == 1)
                {
                    this.watermarkpicarea.Attributes["style"] = "display:";
                    this.watermarktxtarea.Attributes["style"] = "display:none";
                }
                else
                {
                    this.watermarkpicarea.Attributes["style"] = "display:none";
                    this.watermarktxtarea.Attributes["style"] = "display:";
                }
                LoadPosition(__configinfo.WaterMarkStatus);

                //邮件选项
                this.SmtpServer.Text = __configinfo.SmtpServer;
                this.SmtpPort.Text = __configinfo.SmtpPort.ToString();
                this.MailFrom.Text = __configinfo.MailFrom;
                this.MailUserName.Text = __configinfo.MailUserName;
                this.MailPassword.Attributes.Add("value", __configinfo.MailPassWord);
                // this.MailPassword.Text = __configinfo.MailPassWord;

                //商城配置
                string templates = __configinfo.ShopTemplates + "#######################################################################################################";
                string[] setArr = templates.Split('#');
                this.TxtShopPriceBit.Text = __configinfo.ShopPriceBit.ToString();
                this.TxtCurrencySymbol.Text = setArr[48].ToString();
                this.TxtCurrencyUnit.Text = setArr[49].ToString();
                this.RdbMobileMutiRegTF.Text = Utils.StrToInt(setArr[54]).ToString();
                this.RdbLoginType.Text = Utils.StrToInt(setArr[55]).ToString();
                this.RdbUserNameType.SelectedValue = Utils.StrToInt(setArr[56]).ToString();
                this.TxtIPNum.Text = setArr[57].ToString();
                this.RdbFsoPath.SelectedValue = Utils.StrToInt(setArr[58].ToString()).ToString();
                this.RdbSearchType.SelectedValue = Utils.StrToInt(setArr[66]).ToString();
                foreach (ListItem li in CkbSearchFiled.Items)
                {
                    if (Utils.InArray(li.Value, setArr[67], ","))
                    {
                        li.Selected = true;
                    }
                    else
                    {
                        li.Selected = false;
                    }
                }
                this.RdbRegUserNameHasNum.SelectedValue = Utils.StrToInt(setArr[69]).ToString();
                this.RdbRegUserNameHasCN.SelectedValue = Utils.StrToInt(setArr[70]).ToString();
                this.RdbUploadDirType.SelectedValue = Utils.StrToInt(setArr[82]).ToString();
                this.RdbThumbAddWaterMark.SelectedValue = Utils.StrToInt(setArr[86]).ToString();
                this.TxtTemplate01.Text = setArr[89].ToString();
                this.TxtTemplate02.Text = setArr[90].ToString();
                this.TxtTemplate03.Text = setArr[91].ToString();
                this.RdbHidUserName.SelectedValue = Utils.StrToInt(setArr[96].ToString()).ToString();
                this.RdbIsPoint.SelectedValue = Utils.StrToInt(setArr[98].ToString()).ToString();
                this.TxtTJMoney.Text = Utils.StrToFloat(setArr[63].ToString()).ToString();
                this.TxtTJScore.Text = Utils.StrToInt(setArr[99].ToString()).ToString();
                this.TxtTJPoint.Text = Utils.StrToFloat(setArr[100].ToString()).ToString();
                this.RdbBingMobile.SelectedValue = Utils.StrToInt(setArr[106].ToString()).ToString();//106未实名认证是否启用手机绑定
                this.RdbIsUrlUid.SelectedValue = Utils.StrToInt(setArr[115].ToString()).ToString();//115 URL是否启有加UID

                oldMobileTemplate = setArr[89].ToString();
                oldSchoolTemplate = setArr[90].ToString();
                oldSpaceTemplate = setArr[91].ToString();

                //其它选项
                this.TemplateDir.Text = __configinfo.TemplateDir;
                oldTemplate = __configinfo.TemplateDir;
                this.UpFileDir.Text = __configinfo.UpFileDir;
                this.FormFsoDir.Text = __configinfo.FormFsoDir;
                this.ADFsoDir.Text = __configinfo.ADFsoDir;
                this.JSFsoDir.Text = __configinfo.JSFsoDir;
                this.SpecialFsoDir.Text = __configinfo.SpecialFsoDir;
                this.ShowAreaLeval.SelectedValue = __configinfo.ShowAreaLeval.ToString();
                this.RdbChangeCityTF.SelectedValue = __configinfo.GroupBuyChangeCityTF.ToString();
                this.TxtRefreshPauseNum.Text = __configinfo.RefreshPauseNum.ToString();
                this.TxtRefreshPauseTime.Text = __configinfo.RefreshPauseTime.ToString();
                this.RdbInitialDataPerDay.SelectedValue = __configinfo.InitialDataPerDay.ToString();
                this.RdbLabelChineseLenTF.SelectedValue = __configinfo.LabelChineseLenTF.ToString();
                this.TxtAutoCreateJSTime.Text = __configinfo.AutoCreateJSTime.ToString();

              


                //ftp选项
                this.RdbRemoteAnnexTF.SelectedValue = __configinfo.RemoteAnnexTF.ToString();

                this.TxtFtpServerIP.Text = __configinfo.FtpServerIP;
                this.TxtFtpServerPort.Text = __configinfo.FtpServerPort;
                this.TxtFtpUserName.Text = __configinfo.FtpServerUserName;
                this.TxtFtpUserPassWord.Attributes.Add("value", __configinfo.FtpServerPassWord);
                this.TxtFtpRemoteAnnexDir.Text = __configinfo.FtpRemoteAnnexDir;
                this.TxtFtpRemoteAnnexUrl.Text = __configinfo.FtpRemoteAnnexUrl;
                this.TxtFtpRemoteAnnexSize.Text = __configinfo.FtpRemoteAnnexSize.ToString();
                this.RdbFtpDeleteLocalFile.SelectedValue = __configinfo.FtpDeleteLocalFile.ToString();

                //百度AK
                this.TxtBaiduAK.Text = __configinfo.ShopExpressInfo;   

                //3G选项
                this.Rdb3GEnable.SelectedIndex = this.Rdb3GEnable.Items.IndexOf(this.Rdb3GEnable.Items.FindByValue(__configinfo.G3Enabled.ToString()));
                this.Rdb3GUserRegEnable.SelectedIndex = this.Rdb3GUserRegEnable.Items.IndexOf(this.Rdb3GUserRegEnable.Items.FindByValue(__configinfo.G3UserRegEnable.ToString()));
                this.Txt3GSiteName.Text = __configinfo.G3SiteName;
                this.Txt3GLogo.Text = __configinfo.G3Logo;
                this.Txt3GCopyRight.Text = __configinfo.G3CopyRight;
                this.Txt3GcontentLengh.Text = __configinfo.G3ContetnLength.ToString();//短信长度限制


                XmlDocument xd = new XmlDocument();
                xd.Load(Server.MapPath("/Config/3GSetting.config"));
                XmlNode root = xd.DocumentElement;//获取根节点
                XmlNodeList items = root.ChildNodes; //获取节点列表

                foreach (XmlNode p in items)
                {
                    if (p.Name == "G3MessageVerify")
                    {
                        this.RbMessageVerify.SelectedValue = p.InnerText.Trim();
                    }

                    if (p.Name == "G3AllowVisitorsMessage")
                    {
                        this.RdbMessageVisitor.SelectedValue = p.InnerText.Trim();
                    }
                   

                    if (p.Name == "WeixinAutoCreateUser")
                    {
                        this.RdbWeixinAutoCreateUser.SelectedValue = Utils.StrToInt(p.InnerText).ToString();
                    }
                    if (p.Name == "WeixinAutoLogin")
                    {
                        this.RdbWeixinAutoLogin.SelectedValue = Utils.StrToInt(p.InnerText).ToString();
                    }
                    if (p.Name == "WeixinLoginBindUser")
                    {
                        this.RdbWeixinLoginBindUser.SelectedValue = Utils.StrToInt(p.InnerText).ToString();
                    }

                }

            }
            catch
            {
                SiteName.Text = "www.kesion.com";
                SiteTitle.Text = "KesionICMS " + DateTime.Now.Year.ToString();
                IndexFile.Items.FindByValue("index").Selected = true;
            }
        }


        protected void SaveButton_Click(object sender, EventArgs e)
        {
             
            string sysDir = "plus,shop,model,config,admin,cache,uploadfiles,ks_inc,images,3g,app_browsers,app_data,ask,bin,control,bbs,model,ks_inc,user";
            string tpDir = this.TemplateDir.Text.ToLower();
            if (string.IsNullOrEmpty(tpDir))
            {
                JS.Alert("PC模板目录不能留空!", KSCMS.GetComeUrl());
            }
            else if (Utils.InArray(tpDir, sysDir, ","))
            {
                JS.Alert("PC模板目录不能和系统目录同名!", KSCMS.GetComeUrl());
            }

            string mobileTpDir = this.TxtTemplate01.Text;
            if (!string.IsNullOrEmpty(mobileTpDir))
            {
                if (Utils.InArray(mobileTpDir, sysDir, ","))
                {
                    JS.Alert("手机模板目录不能和系统目录同名!", KSCMS.GetComeUrl());
                }
            }

            string spaceTpDir = this.TxtTemplate03.Text;
            if (!string.IsNullOrEmpty(spaceTpDir))
            {
                if (Utils.InArray(spaceTpDir, sysDir, ","))
                {
                    JS.Alert("个人空间模板目录不能和系统目录同名!", KSCMS.GetComeUrl());
                }
            }



            string upDir = this.UpFileDir.Text.ToLower();

            if (string.IsNullOrEmpty(upDir))
            {
                JS.Alert("上传目录不能留空!", KSCMS.GetComeUrl());
            }
            else if (upDir.ToLower() != "uploadfiles" && Utils.InArray(upDir, sysDir, ","))
            {
                JS.Alert("上传目录不能和系统目录同名!", KSCMS.GetComeUrl());
            }



            XmlDocument xmldoc = new XmlDocument();
            xmldoc.Load(Server.MapPath("~/config/commontemplate.config"));
            XmlNode node = xmldoc.SelectSingleNode("//labeltemplate/label[@name='regLience']");
            if (node != null)
            {
                XmlElement xe = (XmlElement)node;
                xe.InnerText = this.UserLience.Text;
            }
            node = xmldoc.SelectSingleNode("//labeltemplate/label[@name='regSendMail']");
            if (node != null)
            {
                XmlElement xe = (XmlElement)node;
                xe.InnerText = this.TxtRegSuccMail.Text;
            }
            else
            {
                XmlNode root = xmldoc.SelectSingleNode("//labeltemplate");
                XmlElement xe1 = xmldoc.CreateElement("label");
                xe1.SetAttribute("name", "regSendMail");
                xe1.InnerText = this.TxtRegSuccMail.Text;
                root.AppendChild(xe1);
            }
            xmldoc.Save(Server.MapPath("~/config/commontemplate.config"));

            ConfigInfo __configinfo = ConfigManage.Deserialize(Server.MapPath("../../config/general.config"));
            __configinfo.SiteName = SiteName.Text;
            __configinfo.SiteTitle = SiteTitle.Text;
            __configinfo.Domain = Domain.Text;
            __configinfo.InstallDir = this.InstallDir.Text;
            __configinfo.WebLogo = this.WebLogo.Text;
            __configinfo.FSOIndex = this.IndexFile.SelectedItem.Text + this.FsoIndexExt.SelectedItem.Text;
            __configinfo.CacheTime = Utils.StrToInt(this.TxtCacheTime.Text);
            __configinfo.SpecialFsoTF = Convert.ToInt16(this.SpecialFsoTF.SelectedValue);
            __configinfo.DefaultUpFileSize = Utils.StrToInt(this.DefaultUpFileSize.Text, 0);
            __configinfo.DefaultUpFileType = this.DefaultUpFileType.Text.Trim();
            __configinfo.WebMaster = this.WebMaster.Text;

            string ostr = "";
            for (int i = 0; i < this.OfficialInfo.Items.Count; i++)
            {
                if (this.OfficialInfo.Items[i].Selected == true)
                {
                    ostr += this.OfficialInfo.Items[i].Value;
                }
            }

            __configinfo.OfficialInfo = ostr;
            __configinfo.SiteKey = this.SiteKey.Text;
            __configinfo.CopyRight = this.CopyRight.Text;
            __configinfo.MetaKeyWords = this.TxtMetaKeywords.Text;
            __configinfo.MetaDescript = this.TxtMetaDescript.Text;

            //模板绑定
            __configinfo.IndexTemplate = this.IndexTemplate.Text;
            __configinfo.SpecialIndexTemplate = this.SpecialIndexTemplate.Text;
            __configinfo.UserIndexTemplate = this.UserIndexTemplate.Text;
            __configinfo.SearchTemplate = this.SearchTemplate.Text;
            __configinfo.AutoCreateIndexTime = Utils.StrToInt(this.TxtAutoCreateIndexTime.Text);
            __configinfo.PKIndexTemplate = this.PKIndexTemplate.Text;
            __configinfo.PKContentTemplate = this.PKContentTemplate.Text;
            __configinfo.PKMoreTemplate = this.PKMoreTemplate.Text;

            //会员选项
            __configinfo.UserSystemTF = Utils.StrToInt(this.UserSystemTF.SelectedItem.Value, 0);
            __configinfo.UserAllowRegTF = Utils.StrToInt(this.UserAllowRegTF.SelectedItem.Value, 0);

            string EnabledRegField = string.Empty;
            foreach (ListItem li in this.CkbEnabledRegField.Items)
            {
                if (li.Selected == true)
                {
                    if (string.IsNullOrEmpty(EnabledRegField))
                    {
                        EnabledRegField = li.Value;
                    }
                    else
                    {
                        EnabledRegField += "," + li.Value;
                    }
                }
            }

            __configinfo.EnabledRegField = EnabledRegField;

            __configinfo.UserEmailMutiRegTF = Utils.StrToInt(this.UserEmailMutiRegTF.SelectedItem.Value, 0);
            __configinfo.UserMinChar = Utils.StrToInt(this.UserMinChar.Text, 0);
            __configinfo.UserMaxChar = Utils.StrToInt(this.UserMaxChar.Text, 0);
            __configinfo.NoAllowRegUserName = this.NoAllowRegUserName.Text;
            __configinfo.UserMutiLoginTF = Utils.StrToInt(this.UserMutiLoginTF.SelectedItem.Value, 0);
            __configinfo.UserPerMinLogin = Utils.StrToInt(this.UserPerMinLogin.Text, 0);
            __configinfo.UserPerMinLoginAddScore = Utils.StrToInt(this.UserPerMinAddScore.Text, 0);
            __configinfo.UserRegAddMoney = Utils.StrToFloat(this.UserRegAddMoney.Text, 0);
            __configinfo.UserRegAddPoint = Utils.StrToFloat(this.UserRegAddPoint.Text, 0);
            __configinfo.UserRegAddScore = Utils.StrToInt(this.UserRegAddScore.Text, 0);
            __configinfo.ScoreToPointRate = Utils.StrToInt(this.ScoreToPointRate.Text, 0);
            __configinfo.ScoreToEdaysRate = Utils.StrToInt(this.ScoreToEdaysRate.Text, 0);
            __configinfo.MoneyToPointRate = Utils.StrToInt(this.MoneyToPointRate.Text, 0);
            __configinfo.MoneyToEdaysRate = Utils.StrToInt(this.MoneyToEdaysRate.Text, 0);
            __configinfo.PointName = this.PointName.Text;
            __configinfo.PointUnit = this.PointUnit.Text;

            //缩略图水印
            __configinfo.ThumbsWidth = Utils.StrToInt(this.ThumbsWidth.Text, 0);
            __configinfo.ThumbsHeight = Utils.StrToInt(this.ThumbsHeight.Text, 0);
            __configinfo.WaterMarkType = Utils.StrToInt(this.WaterMarkType.SelectedItem.Value, 0);
            __configinfo.WaterMarkTxt = this.WaterMarkTxt.Text;
            __configinfo.WaterMarkFontName = this.WaterMarkFontName.SelectedItem.Value;
            __configinfo.WaterMarkFontSize = Utils.StrToInt(this.WaterMarkFontSize.Text, 12);
            __configinfo.WaterMarkFontColor = this.WaterMarkFontColor.Text;
            __configinfo.WaterMarkFontStyle = this.WaterMarkFontStyle.SelectedValue;
            __configinfo.WaterMarkFontBgColor = this.WaterMarkFontBgColor.Text;
            __configinfo.WaterMarkPic = this.WaterMarkPic.Text;
            __configinfo.WaterMarkTransParence = Utils.StrToInt(this.WaterMarkTransParency.Text, 0);
            __configinfo.WaterMarkStatus = Utils.StrToInt(KSCMS.S("watermarkstatus"), 0);

            //其它
            __configinfo.ShopExpressInfo = this.TxtBaiduAK.Text.Trim();  //访问百度地图的AK

            //邮件选项
            __configinfo.SmtpServer = this.SmtpServer.Text;
            __configinfo.SmtpPort = Utils.StrToInt(this.SmtpPort.Text, 25);
            __configinfo.MailFrom = this.MailFrom.Text;
            __configinfo.MailUserName = this.MailUserName.Text;
            if (this.MailPassword.Text != "")
                __configinfo.MailPassWord = this.MailPassword.Text;


            //商城配置
            #region 商城配置
            string settings = __configinfo.ShopTemplates;
            if (settings.Split('#').Length < 120)
            {
                settings += "####################################################";
            }
            string[] tpSetting = settings.Split('#');
            string newTp = string.Empty;
            int ii = 0;
            foreach (string s in tpSetting)
            {
                if (ii == 0)
                {
                    newTp = s;
                }
                else if (ii == 48)
                {
                    newTp += "#" + this.TxtCurrencySymbol.Text; //48 商品价格单位符号
                }
                else if (ii == 49)
                {
                    newTp += "#" + this.TxtCurrencyUnit.Text; //49 商品价格单位中文名称
                }
                else if (ii == 54)
                {
                    newTp += "#" + this.RdbMobileMutiRegTF.SelectedValue; //54每个手机号注册多次
                }
                else if (ii == 55)
                {
                    newTp += "#" + this.RdbLoginType.SelectedValue; //55 登录方式限制
                }
                else if (ii == 56)
                {
                    newTp += "#" + this.RdbUserNameType.SelectedValue; //56 会员名称构成格式
                }
                else if (ii == 57)
                {
                    newTp += "#" + Utils.StrToInt(this.TxtIPNum.Text); //57 每个IP每天注册会员数
                }
                else if (ii == 58)
                {
                    newTp += "#" + Utils.StrToInt(this.RdbFsoPath.SelectedValue);  //58生成HTML路径
                }
                else if (ii == 66)
                {
                    newTp += "#" + Utils.StrToInt(this.RdbSearchType.SelectedValue); //启用模糊搜索
                }
                else if (ii == 69)
                {
                    newTp += "#" + Utils.StrToInt(this.RdbRegUserNameHasNum.SelectedValue); //注册用户名纯数字
                }
                else if (ii == 70)
                {
                    newTp += "#" + Utils.StrToInt(this.RdbRegUserNameHasCN.SelectedValue); //注册用户名允许含中文
                }
                else if (ii == 82)
                {
                    newTp += "#" + Utils.StrToInt(this.RdbUploadDirType.SelectedValue); //上传目录格式
                }
                else if (ii == 85)
                {
                    newTp += "#" ;          //原移动端绑定二级域名，预留可用
                }
                else if (ii == 86)
                {
                    newTp += "#" + Utils.StrToInt(this.RdbThumbAddWaterMark.SelectedValue); //缩略图加水印
                }
                else if (ii == 89)
                {
                    newTp += "#" + this.TxtTemplate01.Text.Trim();  //手机模板总目录
                }
                else if (ii == 90)
                {
                    newTp += "#" + this.TxtTemplate02.Text.Trim();  //机构模板总目录
                }
                else if (ii == 91)
                {
                    newTp += "#" + this.TxtTemplate03.Text.Trim();  //个人空间模板总目录
                }
                else if (ii == 96)
                {
                    newTp += "#" + this.RdbHidUserName.SelectedValue;  //用户名隐藏显示处理
                }
                else if (ii == 98)
                {
                    newTp += "#" + this.RdbIsPoint.SelectedValue;  //启用点券功能
                }
                else if (ii == 63)
                {
                    newTp += "#" + this.TxtTJMoney.Text;          //给推荐人送人民币
                }
                else if (ii == 99)
                {
                    newTp += "#" + this.TxtTJScore.Text;          //给推荐人送积分
                }
                else if (ii == 100)
                {
                    newTp += "#" + this.TxtTJPoint.Text;          //给推荐人送点券
                }
                else if (ii == 106)
                {
                    newTp += "#" + Utils.StrToInt(this.RdbBingMobile.SelectedValue); //106未实名认证是否启用手机绑定
                }
                else if (ii == 115)
                {
                    newTp += "#" + Utils.StrToInt(this.RdbIsUrlUid.SelectedValue); //115 URL是否加上UID
                }
                else if (ii == 67)
                {
                    string searchField = string.Empty;
                    foreach (ListItem li in CkbSearchFiled.Items)
                    {
                        if (li.Selected == true)
                        {
                            if (string.IsNullOrEmpty(searchField))
                            {
                                searchField = li.Value;
                            }
                            else
                            {
                                searchField += "," + li.Value;
                            }
                        }
                    }
                    newTp += "#" + searchField; //搜索匹配字段

                }
                else
                {
                    newTp += "#" + s;
                }
                ii++;
            }
            __configinfo.ShopPriceBit = Utils.StrToInt(this.TxtShopPriceBit.Text);
            __configinfo.ShopTemplates = newTp;
            #endregion



            //其它选项
            __configinfo.TemplateDir = this.TemplateDir.Text.Trim();

            #region 模板目录更名
            if (oldTemplate.ToLower() != __configinfo.TemplateDir.ToLower())
            {
                Kesion.HtmlTags.Function.RenameFolder("~/" + oldTemplate, "~/" + __configinfo.TemplateDir);
            }
            if (!string.IsNullOrEmpty(this.TxtTemplate01.Text) && !string.IsNullOrEmpty(oldMobileTemplate) && oldMobileTemplate.ToLower() != this.TxtTemplate01.Text.ToLower())
            {

                Kesion.HtmlTags.Function.RenameFolder("~/" + oldMobileTemplate, "~/" + this.TxtTemplate01.Text.Trim());
            }
            if (!string.IsNullOrEmpty(this.TxtTemplate02.Text) && !string.IsNullOrEmpty(oldSchoolTemplate) && oldSchoolTemplate.ToLower() != this.TxtTemplate02.Text.ToLower())
            {

                Kesion.HtmlTags.Function.RenameFolder("~/" + oldSchoolTemplate, "~/" + this.TxtTemplate02.Text.Trim());
            }
            if (!string.IsNullOrEmpty(this.TxtTemplate03.Text) && !string.IsNullOrEmpty(oldSpaceTemplate) && oldSpaceTemplate.ToLower() != this.TxtTemplate03.Text.ToLower())
            {

                Kesion.HtmlTags.Function.RenameFolder("~/" + oldSpaceTemplate, "~/" + this.TxtTemplate03.Text.Trim());
            }
            #endregion


            __configinfo.UpFileDir = this.UpFileDir.Text;
            __configinfo.FormFsoDir = this.FormFsoDir.Text;
            __configinfo.ADFsoDir = this.ADFsoDir.Text;
            __configinfo.JSFsoDir = this.JSFsoDir.Text;
            __configinfo.SpecialFsoDir = this.SpecialFsoDir.Text;
            __configinfo.ShowAreaLeval = Utils.StrToInt(this.ShowAreaLeval.SelectedValue, 1);
            __configinfo.GroupBuyChangeCityTF = Utils.StrToInt(this.RdbChangeCityTF.SelectedValue);
            __configinfo.RefreshPauseNum = Utils.StrToInt(this.TxtRefreshPauseNum.Text);
            __configinfo.RefreshPauseTime = Utils.StrToInt(this.TxtRefreshPauseTime.Text);
            __configinfo.InitialDataPerDay = Utils.StrToInt(this.RdbInitialDataPerDay.SelectedValue);
            __configinfo.LabelChineseLenTF = Utils.StrToInt(this.RdbLabelChineseLenTF.SelectedValue);
            __configinfo.AutoCreateJSTime = Utils.StrToInt(this.TxtAutoCreateJSTime.Text);



            //ftp选项
            __configinfo.RemoteAnnexTF = Convert.ToInt16(this.RdbRemoteAnnexTF.SelectedValue);
            if (Utils.GetSysInfo("//sysinfo/isbusiness").ToLower() == "true")  //商业版本
            {
                __configinfo.FtpServerIP = this.TxtFtpServerIP.Text;
                __configinfo.FtpServerPort = this.TxtFtpServerPort.Text;
                __configinfo.FtpServerUserName = this.TxtFtpUserName.Text;
                __configinfo.FtpServerPassWord = this.TxtFtpUserPassWord.Text;
                __configinfo.FtpRemoteAnnexDir = this.TxtFtpRemoteAnnexDir.Text;
                __configinfo.FtpRemoteAnnexUrl = this.TxtFtpRemoteAnnexUrl.Text;
                __configinfo.FtpRemoteAnnexSize = Utils.StrToInt(this.TxtFtpRemoteAnnexSize.Text);
                __configinfo.FtpDeleteLocalFile = Utils.StrToInt(this.RdbFtpDeleteLocalFile.SelectedValue);
            }

            //3G选项
            __configinfo.G3Enabled = Utils.StrToInt(this.Rdb3GEnable.SelectedValue);
            __configinfo.G3SiteName = this.Txt3GSiteName.Text;
            __configinfo.G3Logo = this.Txt3GLogo.Text;
            __configinfo.G3CopyRight = this.Txt3GCopyRight.Text;
            __configinfo.G3UserRegEnable = Utils.StrToInt(this.Rdb3GUserRegEnable.SelectedValue);
            __configinfo.G3ContetnLength = Utils.StrToInt(this.Txt3GcontentLengh.Text);

            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.Load(Server.MapPath("/Config/3GSetting.config"));
            XmlNodeList nodeList = xmlDoc.SelectSingleNode("WeixinConfigInfo").ChildNodes;//获取WeixinConfigInfo节点的所有子节点
            foreach (XmlNode xn in nodeList)//遍历所有子节点
            {
                XmlElement xe = (XmlElement)xn;//将子节点类型转换为XmlElement类型
                if (xe.Name == "G3MessageVerify")
                {
                    xe.InnerText = this.RbMessageVerify.SelectedValue;
                }
                if (xe.Name == "G3AllowVisitorsMessage")
                {
                    xe.InnerText = this.RdbMessageVisitor.SelectedValue;
                }
                
                if (xe.Name == "AutoTurnMobileSite")
                {
                    xe.InnerText = "0";
                }
                if (xe.Name == "WeixinAutoCreateUser")
                {
                    xe.InnerText = this.RdbWeixinAutoCreateUser.SelectedValue;
                }
                if (xe.Name == "WeixinAutoLogin")
                {
                    xe.InnerText = this.RdbWeixinAutoLogin.SelectedValue;
                }
                if (xe.Name == "WeixinLoginBindUser")
                {
                    xe.InnerText = this.RdbWeixinLoginBindUser.SelectedValue;
                }


            }

            xmlDoc.Save(Server.MapPath("/Config/3GSetting.config"));//保存。



            ConfigManage.Serialiaze(__configinfo, Server.MapPath("../../config/general.config"));

            #region 更新缓存
            ClearConfigCache();
            #endregion

            JS.Alert("恭喜，网站参数配置成功！", KSCMS.GetComeUrl());
            //Page.ClientScript.RegisterStartupScript(this.GetType(), "", "<script>jQuery(function(){KesionJS.Alert('恭喜,网站参数配置成功!',\"location.href='" + KSCMS.GetInstallDir() + MyCache.GetCacheConfig(4) + "/system/KS.Config.aspx';\");});</script>");
        }
        public static void ClearConfigCache()
        {
            #region 更新缓存
            KSCache cache = KSCache.GetCacheService();
            cache.RemoveObject("/CMS/ConfigList");
            cache.RemoveObject("/CMS/LabelList" + MyCache.GetTemplateID());
            cache.RemoveObject("/CMS/JSLabelList" + MyCache.GetTemplateID());
            cache.RemoveObject("/CMS/DataLabel" + MyCache.GetTemplateID());
            cache.RemoveObject("/CMS/NavigationLabelList" + MyCache.GetTemplateID());
            cache.RemoveObject("/CMS/Domain");


            PageCache.UpdateCacheFileTag(KSCMS.GetInstallDir() + "cache/index.cache");

            #endregion
        }

    }
}