﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="Kesion.Config" %>
<%@ Import Namespace="Kesion.Components" %>
<%@ Import Namespace="Kesion.HtmlTags" %>
<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="Kesion.Course" %>
<script runat="server" type="text/C#">

    dynamic __user = HttpContext.Current.Items["user"];                //初始化用户信息，
    private static dynamic __info = new System.Dynamic.ExpandoObject();   //初始化当前页信息
    
    public int recordcount, pagecount;
    public int CurrPage = new BasicField().GetCurrPage;
    public int PageSize = 10;

    protected DataRow drr;
    private string GetVal(string fieldName)
    {
        if (drr != null)
        {
            return drr[fieldName].ToString();
        }
        else
        {
            return string.Empty;
        }
    }
    
    protected void Page_Load(object sender, EventArgs e)
    {

        if (KSCMS.S("editsave") == "editsave")
        {
            editsave();//更新信息
        } 
        //根据参数判盘类型信息
        switch (KSCMS.S("action"))
        {
            case "delete"://删除
                deletechat(KSCMS.S("ids"));
                break;
            case "edit"://编辑初始化
                initedit(Utils.StrToInt(KSCMS.S("id")));
                break;

        }
    }
    //编辑初始化
    private void initedit(int chatid)
    {
        using (DataTable dt = DataFactory.GetDataTable("select top 1 * from KS_CourseChat where chatid=" + chatid))
        {
            if (dt != null)
            {
                drr = dt.Rows[0];
            }
        }
    }

    //更新提问的内容
    private void editsave() 
    {
        string content= Utils.ChkSQL(KSCMS.S("chatcontent"));
        Hashtable ht = new Hashtable();
        ht.Add("ChatID", Utils.StrToInt(KSCMS.S("chatid")));
        ht.Add("UserName", __user.UserName);
        ht.Add("Userid", __user.UserID);
        ht.Add("UserIP ", Utils.GetRealIP());
        ht.Add("ReplayData", DateTime.Now);
        ht.Add("ReplayContent", content);//追问存储位置ChatStatus
        ht.Add("ChatStatus", 1);//追问添加
        CommonData.Insert("KS_CourseReplayChat", ht); 
        Msg.Alert("恭喜，追问成功！", KSCMS.GetComeUrl());
    }
     
    //删除操作
    private void deletechat(string ids) 
    {
        if (ids == null || ids == "0") return;
        ids = Utils.FilterIDs(ids);
        using (DataTable dt = DataFactory.GetDataTable("select * from KS_CourseChat where chatid in (" + ids + ")"))
        {
            if (dt != null)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    Hashtable ht = new Hashtable();
                    ht.Add("chatid", dr["chatid"].ToString());
                    if (dr["chattype"].ToString() == "1")
                    {
                        //删除问答相关的表信息
                        string tablename = DataFactory.GetOnlyValue("select top 1 PostTable from KS_AskTopic where topicid=" + dr["ChatInfoid"].ToString());
                        DataFactory.ExecuteNonQuery("delete from " + tablename + " where topicid=" + dr["ChatInfoid"].ToString());//回复表
                        DataFactory.ExecuteNonQuery("delete from KS_AskTopic where topicid=" + dr["ChatInfoid"].ToString());//问题表
                    }
                    else if (dr["chattype"].ToString() == "99")
                    {
                        //删除点播道具的使用记录
                        DataFactory.ExecuteNonQuery("delete from KS_CosPropItem where id=" + dr["ChatInfoid"].ToString());//道具使用表
                    }
                    CommonData.Delete("KS_CourseChat", ht);
                }
            }
        }
        Msg.Alert("恭喜，删除成功！", KSCMS.GetComeUrl());
    }
    
    #region    获取聊天的相关信息
    //获取存储的类型信息
    public string getchattype(int chattype)
    {
        string chattypenaem = string.Empty;
        switch (chattype)
        {
            case 1:
                chattypenaem = "问老师";
                break;
            case 2:
                chattypenaem = "问客服";
                break;
            case 99:
                chattypenaem = "点播互动道具";
                break;
            case 100:
                chattypenaem = "直播互动道句";
                break;
            default:
                chattypenaem = "问答";
                break;
        }
        return chattypenaem;
    }
    //获取所属课程名
    public string getcoursename(int courseid)
    {
        StringBuilder sb = new StringBuilder();
        string coursename = DataFactory.GetOnlyValue("select top 1 name from KS_Course where courseid=" + courseid);
        if (coursename == "0")
        {
            sb.Append("<span>--</span>");
        }
        else
        {
            sb.Append("<a target='_blank' href=" + BasicField.GetRewriteUrl("courseview", Utils.StrToInt(courseid)) + ">" + coursename + "</a>");
        }
        return sb.ToString();
    }
    //获取课时的名称
    public string getperiodname(int periodid)
    {
        string periodname = DataFactory.GetOnlyValue("select top 1 PeriodName from  KS_CosPeriod where PeriodID =" + periodid);
        return periodname;
    }
    //判断是否显示删除的操作
    private void showdelete(int chatid) 
    {
        using (DataTable dt = DataFactory.GetDataTable("select * from KS_CourseReplayChat where chatid="+chatid))
        {
           string showdelete="不显示";
            if (dt.Rows.Count > 0) //说明  有回复   或者   有追问内容
            { 
               foreach(DataRow dr in dt.Rows)
               {
                   if (dr["chatstatus"].ToString() == "0")
                   {
                       showdelete += ",回复";
                   }
                   else
                   {
                       showdelete += ",不显示";
                   }
               }
            }
            if (showdelete.IndexOf("回复") != -1) // 存在回复内容    显示删除操作信息
            {
                KSCMS.W("<span>--</span>");
            }
            else
            {
                KSCMS.W("<a href="+BasicField.GetUserUrl("Course/MyChatInfo","action-edit,id-"+chatid) +" onclick=return(confirm('确定删除么？请谨慎操作！')) ><i class='userfont uf-delete'></i></a>");
            }
        }
    } 
    #endregion
    
</script>

<div class="r_tybox nomar">
    <%if(KSCMS.S("action")!="edit"){ %>
    <div class="r_title">我的咨询
        <div class="tabs">  
          <ul class="clearfix">
              <li <%=KSCMS.S("chatstatus")==""?"class='puton'":"" %>><a href="<%=BasicField.GetUserUrl("Course/MyChatInfo") %>">我咨询的教师</a></li> 
              <li><a href="<%=BasicField.GetUserUrl("course/MyChatService") %>">我咨询的客服</a></li>
              <%if (Utils.GetSysInfo("//sysinfo/model/mall").ToString()== "true") { %>
              <li><a href="<%=BasicField.GetUserUrl("Shop/MyMallAsk") %>">商品咨询</a></li>
              <%} %>
              <li <%=KSCMS.S("chatstatus")=="1"?"class='puton'":"" %>><a href="<%=BasicField.GetUserUrl("Course/MyChatInfo","chatstatus-1") %>">已解决</a></li>  
              <li <%=KSCMS.S("chatstatus")=="0"?"class='puton'":"" %>><a href="<%=BasicField.GetUserUrl("Course/MyChatInfo","chatstatus-0") %>">未解决</a></li>  
    <%--      <li <%=KSCMS.S("chattype")=="99"?"class='puton'":"" %>><a href="<%=BasicField.GetUserUrl("Course/MyChatInfo","chattype-99") %>">互动参与</a></li> --%>          
          </ul>
        </div>

    </div>

    <div class="top_c_sc"> 
        <form name="myform" action="{$GetCurrUrl}" method="post">
            <select name="selecttype" class="f-left"> 
                <option value="1"  <%=KSCMS.S("selecttype")=="1"?"selected='selected'":"" %>>课程</option>
                <option value="2" <%=KSCMS.S("selecttype")=="2"?"selected='selected'":"" %>>内容</option> 
            </select>
            <input name="searchteaxt" type="text" value="<%=KSCMS.S("searchteaxt") %>" class="textbox f-left" placeholder="搜索问题的关键字..." />
            <input type="submit" name="Button4" value=" 搜索 " id="Button4" class="grey-bt f-left" />
        </form>
    </div>


    <div class="clear"></div>
    
    <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" class="border">
         <tr align="center" class="title"> 
             <td align="center">参与课程</td> 
             <td align="center">参与内容</td> 
             <td align="center">参与时间</td> 
             <td align="center">状态</td>   
             <td align="center">查看</td> 
             <td align="center">删除</td> 
         </tr>
     <% string sqlParam = " KS_CourseChat where chattype=1 and userid=" + __user.UserID;
        //sqlParam += " and chattype=" + Utils.StrToInt(KSCMS.S("chattype"),1);//默认为名师 
        if (KSCMS.S("chatstatus") != "")
        {
            sqlParam += " and chatstatus=" + Utils.StrToInt(KSCMS.S("chatstatus"));
        }
        if (KSCMS.S("selecttype") != "")//搜索类型
        {
            if (KSCMS.S("searchteaxt") != "")
            {
                switch (KSCMS.S("selecttype"))
                { 
                    case "1"://课程名称搜索
                        sqlParam += " and coursename like '%" + Utils.RemoveXss(KSCMS.S("searchteaxt")) + "%'";
                        break;
                    case "2"://问题内容搜索
                        sqlParam += " and chatcontent like '%" + Utils.RemoveXss(KSCMS.S("searchteaxt")) + "%'";
                        break;
                }
            }
        }
        using (DataTable dt = DataFactory.GetPage("*", sqlParam, "chatid", "order by chatid desc", CurrPage, PageSize, out recordcount, out pagecount))
        {
            if (dt.Rows.Count > 0)
            {
                foreach(DataRow dr in dt.Rows)
                {
                %>
          <tr class="tdbg">
              <td class="tag_left"><%=getcoursename(Utils.StrToInt(dr["courseid"].ToString())) %>
                  <%=Utils.StrToInt(dr["periodid"].ToString())==0?"":"(课时:"+getperiodname(Utils.StrToInt(dr["periodid"].ToString()))+")" %>
              </td>
              <td class="tag_left">
                 <div  class="asktitle" > <%=dr["chatcontent"].ToString()%></div>
              </td>
              <td  style="text-align:center;"><%=Utils.FormatHumanizedTime(Convert.ToDateTime(dr["AddData"]))%> </td>
              <td style="text-align:center;"><%=dr["chatstatus"].ToString()=="0"?("<a href='"+BasicField.GetUserUrl("teacher/TcChatInfo","action-upstatus,id-"+dr["chatid"].ToString())+"' class=red-color>未解决</a>"):("<span class=green-color>已解决</span>") %></td>
            <td align="center" style="width:60px"> 
            <a href="<%=BasicField.GetUserUrl("Course/MyChatInfo","action-edit,id-"+dr["chatid"].ToString()) %>" class="icon-bt"><i class="userfont uf-chakan"></i></a>
            </td>
              <td align="center" style="width:60px"> 
                  <%if (dr["chatstatus"].ToString() == "1") {%>
                  <span>--</span>
                  <%
                    } else { showdelete(Utils.StrToInt(dr["chatid"].ToString())); } %>
                   
            </td>
          </tr>
          <%
                }
            }
            else {
                KSCMS.W("<tr class=\"tdbg\"> <td colspan=\"7\" style=\"border-bottom:0px;\"><div class=\"clear blank10\"></div><div class=\"empty\"> 暂无参与记录！</div></td></tr><style>.cz_btn{display:none;}</style>");
            }
        }
        %>
      </table>
     <div class="cz_btn">
	 <%
            #region 分页
            string PageStr = "[KS:PageStr2]";
            BasicField.ReplaceFilterPage(ref PageStr, CurrPage, PageSize, pagecount, recordcount);
            KSCMS.W(PageStr);
            #endregion
         %>
     </div>
    <%}else if(KSCMS.S("action")=="edit"){ %>
     
    <div class="r_title r_title_back"><a href="<%=BasicField.GetUserUrl("Course/MyChatInfo") %>" onclick="history.back();" title="返回"><i class="userfont uf-back1"></i></a>提问详情</div>
    <div class="clear"></div>
    <form method="post" action="{$GetCurrUrl}">
    <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" class="border">
          <tr>
            <td>提问内容</td>
            <td class="tag_left"><strong><%=GetVal("chatcontent") %><input type="hidden" name="chatinfoid" value="<%=GetVal("chatinfoid") %>" /></strong><p>编号：<%=GetVal("chatid") %><input type="hidden" name="chatid" value="<%=GetVal("chatid") %>"  /> &nbsp; &nbsp; 提问时间：<%=GetVal("adddata") %> &nbsp; &nbsp; <%=GetVal("chatstatus")=="1"?"<span class='green-color'>已解决</span>":"<a href='"+BasicField.GetUserUrl("teacher/TcChatInfo","action-upstatus,id-"+GetVal("chatid"))+"'><span class='red-color'>未解决</span></a>" %></p></td>
         </tr>
          <%
          using (DataTable dt = DataFactory.GetDataTable("select * from KS_CourseReplayChat where chatid =" + GetVal("chatid")))
          {
              if (dt.Rows.Count > 0)
              {
                  foreach(DataRow dr in dt.Rows)
                  {
                  %>
        <tr>
            <td><%=dr["username"].ToString() %>:</td>
            <td colspan="9"><%=dr["ReplayContent"].ToString() %><br /><%=dr["ReplayData"].ToString() %></td>
            </tr>
        <%
                  }
              } 
          }
             %>
         <%if (GetVal("chatstatus") == "0")
              { %>
        <tr>
            <td>追问</td>
            <td colspan="9"><div class="textarea-wrap"><textarea name="chatcontent" style="width:100%;height:200px;" placeholder="此处填写追问内容..."></textarea></div>
                <input type="hidden" name="editsave" value="editsave" />
            </td>
            </tr>  
        <%} %>

     </table>

    <%if (GetVal("chatstatus") == "0")
              { %> 
      <div class="cz_btn t-a-center">
          <input type="submit"  ID="Submit1" class="green-bt" style="display:inline" value=" 提 交 "   />
      </div> 
    
    <%} else{ %>
       <div class="line-f"></div>
    <%} %>

    </form> 
    <%} %>


</div>
