﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.APPCode" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="Kesion.HtmlTags" %>
<%@ Import Namespace="System.Data" %>
<script runat="server" type="text/C#">

    dynamic __user = HttpContext.Current.Items["user"];                //初始化用户信息
    bool isLoadPage = true;  //定义页面是否加载

    string action = string.Empty;
    int recordcount, pagecount;
    int CurrPage = new BasicField().GetCurrPage;
    int PageSize = 10;

    private DataRow drr = null;
    public static int smallClassID = 0;
    public static int cityId = 0;
    public static int Id = 0;
    public static int FreightType = 0;
    protected void Page_Load(object sender, EventArgs e)
    {

        action = KSCMS.S("action").ToLower();
        switch (action)
        {
            case "modify":
                ModifyPro();
                break;
            case "dosave":
                isLoadPage = false;
                DoSave();
                return;
            case "del":
                isLoadPage = false;
                DelPro(KSCMS.S("id"));
                break;
            case "dodel":
                isLoadPage = false;
                DelPro(KSCMS.S("ids"));
                break;
        
        }


    }
    private string GetVal(string fieldName)
    {
        return (drr == null ? string.Empty : drr[fieldName].ToString());
    }

    private void DelPro(string ids)
    {
        ids = Utils.FilterIDs(ids);
        if (ids == "0" || string.IsNullOrEmpty(ids))
        {
            Msg.Alert("没有选择要删除的商品！", KSCMS.GetComeUrl());
            return;

        }
        else
        {
            DataFactory.ExecuteNonQuery("delete From KS_ProGroupBuy Where id in(" + ids + ") and inputer='" + __user.UserName + "'");
            Msg.Alert("恭喜，商品删除成功！", KSCMS.GetComeUrl());
            return;
        }
    }

    private void ModifyPro()
    {
        #region 修改
        Id = Utils.StrToInt(KSCMS.S("id"));
        if (Id == 0) JS.AlertDoFun("参数错误！", "history.back()");
        using (DataTable dt = DataFactory.GetDataTable("select top 1 * From KS_ProGroupBuy Where Inputer='" + __user.UserName + "' and id=" + Id))
        {
            if (dt.Rows.Count < 0)
            {
                JS.AlertDoFun("对不起，找不到团购商品！", "history.back()");
            }
            else
            {
                drr= dt.Rows[0];
                smallClassID = Utils.StrToInt(drr["classid"].ToString());
                cityId = Utils.StrToInt(drr["cityid"].ToString());
                FreightType = Utils.StrToInt(drr["FreightType"].ToString());
            }
        }
        #endregion
    }
    private void DoSave()
    {
        #region 保存团购添加/修改
        Id = Utils.StrToInt(KSCMS.S("ID"));
        string subject = Utils.RemoveXss(KSCMS.S("Title"));
        if (string.IsNullOrEmpty(subject))
        {
            Msg.AlertDoFun("团购商品名称必须输入!", "history.back()");
            return;
        }

        Hashtable ht = new Hashtable();

        ht.Add("subject", subject);
        ht.Add("unit", KSCMS.S("Unit"));
        ht.Add("MapMarker",KSCMS.S("MapMarker"));


        if (Utils.IsDateTime(KSCMS.S("BeginTime")))
        {
            ht.Add("begindate", Convert.ToDateTime(KSCMS.S("BeginTime")));
        }
        else
        {
            Msg.Alert("开始时间格式不正确，请重新输入!");
            return;
        }
        if (Utils.IsDateTime(KSCMS.S("EndDate")))
        {
            ht.Add("enddate", Convert.ToDateTime(KSCMS.S("EndDate")));
        }
        else
        {
            Msg.Alert("结束时间格式不正确，请重新输入!");
            return;
        }

        int bigclassid = Utils.StrToInt(KSCMS.S("BigClassID"));
        int classid = Utils.StrToInt(KSCMS.S("classid"));
        int cityId = Utils.StrToInt(KSCMS.S("cityid"));
        ht.Add("bigclassid", bigclassid);
        ht.Add("classid", classid);
        ht.Add("bigphoto", KSCMS.S("BigPhoto"));
        ht.Add("photourl", KSCMS.S("PhotoUrl"));
        ht.Add("provinceid", Utils.StrToInt(KSCMS.S("ProvinceID")));
        ht.Add("cityid", cityId);

        ht.Add("endtf", Utils.StrToInt(KSCMS.S("EndTF")));

        ht.Add("ShowPayMent", Utils.StrToInt(KSCMS.S("ShowPayMent")));

        ht.Add("Price_Original", Utils.StrToDecimal(KSCMS.S("Price_Original")));
        ht.Add("discount", Utils.StrToFloat(KSCMS.S("Discount")));
        ht.Add("Price", Utils.StrToDecimal(KSCMS.S("Price")));
        ht.Add("minnum", Utils.StrToInt(KSCMS.S("MinNum")));
        ht.Add("LimitBuyNum", Utils.StrToInt(KSCMS.S("LimitBuyNum")));
        ht.Add("Amount", Utils.StrToInt(KSCMS.S("Amount")));
        ht.Add("AmountNum", Utils.StrToInt(KSCMS.S("AmountNum")));

        ht.Add("intro", KSCMS.S("Intro"));
        ht.Add("Highlights", KSCMS.S("Highlights").Replace("\r\n", "<br/>"));
        ht.Add("Protection", KSCMS.S("Protection").Replace("\r\n","<br/>"));
        ht.Add("Notes", KSCMS.S("Notes").Replace("\r\n", "<br/>"));
        ht.Add("AllowBMFlag", 0);
        ht.Add("AllowArrGroupID", string.Empty);
        ht.Add("templateid", "{$TemplateDir}/商城系统/团购内容页.html");
        ht.Add("HasSellNum", Utils.StrToInt(KSCMS.S("HasSellNum")));
        ht.Add("ChangesUrl", "");
        ht.Add("inputer", (new TemporaryVar()).UserName);
        ht.Add("ShowDelivery", Utils.StrToInt(KSCMS.S("ShowDelivery")));
        ht.Add("FreightType", Utils.StrToInt(KSCMS.S("FreightType")));
        ht.Add("Freight", Utils.StrToDecimal(KSCMS.S("Freight")));
        ht.Add("Weight", Utils.StrToFloat(KSCMS.S("Weight")));




        if (Id ==0)
        {
            ht.Add("recommend", 0);
            ht.Add("CleanCart", 1);
            ht.Add("locked", 1);  //添加时设置为未审核，锁定
            ht.Add("IsBusiness", 1);
            ht.Add("adddate", DateTime.Now);
            CommonData.Insert("KS_ProGroupBuy", ht);
            updateInfoNum(bigclassid, classid);
            #region 关联上传文件
            int id = CommonData.GetMaxId("KS_ProGroupBuy", "id");
            string tempContent = UtilsQueryParam.Get("", 0);
            Kesion.APPCode.Public.FileAssociation(100003, id, tempContent, 0);
            #endregion

            Msg.Confirm("恭喜，团购添加成功，继续添加吗?", "top.location.href='" + BasicField.GetUserUrl("shop/mygroupbuy", "action-add") + "';", "top.location.href='" + BasicField.GetUserUrl("shop/mygroupbuy") + "';");

        }
        else
        {
            CommonData.Update("KS_ProGroupBuy", ht, " where id=" + Id);
            updateInfoNum(bigclassid, classid);
            #region 关联上传文件
            string tempContent = UtilsQueryParam.Get("", 0);
            Kesion.APPCode.Public.FileAssociation(100003, Id, tempContent, 1);
            #endregion
            Msg.Alert("恭喜，团购修改成功!", BasicField.GetUserUrl("shop/mygroupbuy"));

        }
        #endregion

    }
    private void updateInfoNum(int bigclassid, int classid)
    {
        DataFactory.ExecuteNonQuery("UPDATE KS_ProGroupBuyClass Set InfoNum=(select count(1) From KS_ProGroupBuy Where BigClassID=KS_ProGroupBuyClass.classid) where classid=" + bigclassid);
        DataFactory.ExecuteNonQuery("UPDATE KS_ProGroupBuyClass Set InfoNum=(select count(1) From KS_ProGroupBuy Where ClassID=KS_ProGroupBuyClass.classid) where classid=" + classid);
    }
    public static string getSellNum(int flag, int infoid)
    {
        string sqlStr = string.Empty;
        switch (flag)
        {
            case 1:
                sqlStr = "select sum(num) from ks_proorderitem i inner join ks_proorder o on i.orderid=o.orderid where o.ordertype=1 and i.infoid=" + infoid;
                break;
            case 2:
                sqlStr = "select sum(num) from ks_proorderitem i inner join ks_proorder o on i.orderid=o.orderid where o.ordertype=1 and o.MoneyReceipt>0 and i.infoid=" + infoid;
                break;
            case 3:
                sqlStr = "select sum(num) from ks_proorderitem i inner join ks_proorder o on i.orderid=o.orderid where o.ordertype=1 and o.MoneyReceipt<=0 and i.infoid=" + infoid;
                break;
        }
        if (!string.IsNullOrEmpty(sqlStr))
        {
            return DataFactory.GetOnlyValue(sqlStr);
        }
        else
        {
            return "0";
        }

    }
    /// <summary>
    /// 取得团购商品当前状态
    /// </summary>
    /// <param name="endtf"></param>
    /// <param name="locked"></param>
    /// <param name="beginDate"></param>
    /// <param name="endDate"></param>
    /// <returns></returns>
    public static string GetGroupBuyStatus(int endtf, int locked, DateTime beginDate, DateTime endDate)
    {
        #region 取得团购商品当前状态
        string str = string.Empty;
        DateTime currDate = DateTime.Now;
        TimeSpan ts = currDate.Subtract(beginDate);
        TimeSpan tse = currDate.Subtract(endDate);
        if (ts.TotalMilliseconds < 0)
        {
            str = "<span style='color:green'>未开始</span>";
        }
        else if (tse.TotalMilliseconds > 0)
        {
            str = "<span style='color:#ccc'>已结束</span>";
        }
        else if (endtf == 0 && locked == 0)
        {
            str = "<span style='color:red'>进行中</span>";
        }
        else
        {
            if (locked == 1)
            {
                str = "<span style='color:blue'>未审核</span>";
            }
            else if (endtf == 1)
            {
                str = "<span style='color:#999'>强制结束</span>";
            }
        }

        return str;
        #endregion
    }

</script>
<%
    if (!isLoadPage) return;

%>
 <div class="r_tybox nomar">
<%if (string.IsNullOrEmpty(action))
    { %>
	<div class="tabs">	
			<ul>
				<li<%if (string.IsNullOrEmpty(KSCMS.S("show"))) Response.Write(" class='puton'"); %>>
                <a href="<%=BasicField.GetUserUrl("shop/MyGroupBuy") %>">所有团购商品(<%=DataFactory.GetOnlyValue("select count(1) From KS_ProGroupBuy Where inputer='" + (new TemporaryVar()).UserName + "'")  %>)</a></li>
				<li<%if (KSCMS.S("show") == "1") Response.Write(" class='puton'"); %>>
                <a href="<%=BasicField.GetUserUrl("shop/MyGroupBuy", "show-1") %>">进行中(<%=DataFactory.GetOnlyValue("select count(1) From KS_ProGroupBuy Where locked=0 and endtf=0 and datediff(s,EndDate,getdate())<0 and inputer='" + (new TemporaryVar()).UserName + "'")%>)</a></li>
				<li<%if (KSCMS.S("show") == "2") Response.Write(" class='puton'"); %>>
                <a href="<%=BasicField.GetUserUrl("shop/MyGroupBuy", "show-2") %>">已结束(<%=DataFactory.GetOnlyValue("select count(1) From KS_ProGroupBuy Where (endtf=1 or datediff(s,EndDate,getdate())>0) and inputer='" + (new TemporaryVar()).UserName + "'")%>)</a></li>
                <li<%if (KSCMS.S("show") == "3") Response.Write(" class='puton'"); %>>
                <a href="<%=BasicField.GetUserUrl("shop/MyGroupBuy", "show-3") %>">未审核(<%=DataFactory.GetOnlyValue("select count(1) From KS_ProGroupBuy Where locked=1 and inputer='" + (new TemporaryVar()).UserName + "'")%>)</a></li>
			</ul>
	</div>
     <div class="r_padbox">
      <div class="padnav">
            <span><a href="<%=BasicField.GetUserUrl("shop/mygroupbuy", "action-add") %>" >发布团购商品</a></span>
        </div>
	<div class="r_padbox">
         <iframe src="about:blank" style="display:none;width:0px;height:0px" name="hidiframe"></iframe>
        <form name="myform" action="{$GetCurrUrl}" method="post" id="myform" target="hidiframe">
        <input type="hidden" name="action" value="dodel"/>
         <table id="tablist" width="98%" border="0" align="center"  class="border">
      <tr class="title">
        	<td width="20" align="center">&nbsp;</td>
        	<td align="center">团购商品名称</td>
            <td align="center"> 原价</td>
            <td align="center"> 团购价 </td>
            <td align="center">状态</td>
	        <td align="center">操作</td>
        </tr>
     <%
         string param = " WHERE Inputer='" + Utils.RemoveXss(Utils.ChkSQL((new TemporaryVar()).UserName)) + "'";
         if (!string.IsNullOrEmpty(KSCMS.S("show")))
         {

             switch (Utils.StrToInt(KSCMS.S("show")))
             {
                 case 1:
                     param += " and locked=0 and endtf=0 and datediff(s,EndDate,getdate())<0";
                     break;
                 case 2:
                     param += " and (endtf=1 or datediff(s,EndDate,getdate())>0)";
                     break;
                 case 3:
                     param += " and locked=1";
                     break;
             }

         }
         using (DataTable dt = DataFactory.GetPage("*", "[KS_ProGroupBuy]" + param, "id", "order by id desc", CurrPage, PageSize, out recordcount, out pagecount))
         {
             if (dt.Rows.Count > 0)
             {
                 foreach (DataRow dr in dt.Rows)
                 {

                         %>
              <tr class="tdbg">
          <td class="splittd" align="center">
          <input type="checkbox"  name="ids" id="ids" value='<%=dr["id"].ToString() %>' />
         </td>
          <td class="splittd">
              <img width="35" height="45" onerror="this.src='<%=Kesion.Cache.MyCache.GetCacheShopConfig(9) %>';" src='<%=dr["PhotoUrl"].ToString() %>' style="border:1px solid #efefef;padding:2px;margin:2px;" align="left" />
             <a href='<%=BaseFun.GetRewriteUrl("groupbuyview", Convert.ToInt32(dr["id"].ToString())) %>' title='<%=dr["subject"].ToString() %>' target="_blank"><%=Utils.CutStr(dr["subject"].ToString(), 60) %></a>
             <%=Convert.ToInt16(dr["recommend"].ToString()) == 1 ? "<span style='color:green'>荐</span>" : string.Empty %>
             <br />
             <span class="tips">[总销量：<%=getSellNum(1, Convert.ToInt16(dr["id"].ToString())) %><%= string.IsNullOrEmpty(Convert.ToString(dr["unit"].ToString())) ? "件" : dr["unit"].ToString() %>，已付：<span style='color:green'><%= getSellNum(2, Convert.ToInt32(dr["id"].ToString())) %></span><%=string.IsNullOrEmpty(Convert.ToString(dr["unit"].ToString())) ? "件" : dr["unit"].ToString() %>，未付：<span style='color:Red'><%=getSellNum(3, Convert.ToInt32(dr["id"].ToString())) %></span><%=string.IsNullOrEmpty(Convert.ToString(dr["unit"].ToString())) ? "件" : dr["unit"].ToString() %>] </span>

             <span class="tips">[库存：<%=Utils.StrToInt(dr["Amount"].ToString()) %> <%= string.IsNullOrEmpty(Convert.ToString(dr["unit"].ToString())) ? "件" : dr["unit"].ToString() %>]</span>
            
         </td>
          <td class="splittd" align="center">
             <span style='color:#999999;text-decoration:line-through;'><%=MyCache.GetCurrencySymbol%><%= Public.ReturnShopPrice(Utils.StrToDecimal(dr["price_original"].ToString()))%><%=MyCache.GetCurrencyUnit%></span>
         </td>
          <td class="splittd" align="center">
             <span style='color:brown;font-size:14px'><%=MyCache.GetCurrencySymbol%><%=Public.ReturnShopPrice(Utils.StrToDecimal(dr["Price"].ToString()))%><%=MyCache.GetCurrencyUnit%></span>
         </td>
         <td class="splittd" align="center">
            <%=GetGroupBuyStatus(Convert.ToInt16(dr["endtf"].ToString()), Convert.ToInt16(dr["locked"].ToString()), Convert.ToDateTime(dr["begindate"].ToString()), Convert.ToDateTime(dr["enddate"].ToString()))%>
         </td>
        <td class="splittd" align="center">
             <a href="<%=BasicField.GetUserUrl("shop/mygroupbuy", "action-modify,id-" + dr["id"].ToString()) %>">修改</a>
             <a href="<%=BasicField.GetUserUrl("shop/mygroupbuy", "action-del,id-" + dr["id"].ToString()) %>" onclick="return(confirm('确定删除吗？'))">删除</a>
          </td>

      </tr>  
                        <%



                                }

                            }
                            else
                            {
                 %>
             <tr class="tdbg">
                <td class="splittd" style="text-align:center" colspan="10">
                  找不到任何团购商品！
                </td>
           </tr> 
             <%
                     }
                 }
     %>
    </table>
          <div class="cz_btn"><span><input type="checkbox" name="chkall" id="chkall" onclick="CheckAll(this.form);"/>全选  &nbsp;&nbsp; 
    </span><span><input type="submit" id="ButtonDel" class="button" value=" 删除 " onmousedown="return(GetIDS())"/></span></div>
    </form>
<%
    #region 分页
    string PageStr = "[KS:PageStr3]";
    BasicField.ReplaceFilterPage(ref PageStr, CurrPage, PageSize, pagecount, recordcount);
    KSCMS.W(PageStr);
    #endregion
         %>

	</div>
<%}
    else
    { %>


<script src="/KS_Inc/DatePicker/WdatePicker.js"></script>
<% Kesion.APPCode.EditorAPI.EchoHead();%>

        <iframe src="about:blank" style="display:none;width:0px;height:0px" name="hidiframe"></iframe>
        <form name="myform" action="{$GetCurrUrl}" method="post" id="myform" target="hidiframe">
        <input type="hidden" name="action" value="dosave"/>
<table class="border" width="98%" align=center border=0>
   <tr class="title">
         <td colspan="2"> <%=KSCMS.S("action").Equals("modify") ? "修 改 " : "发 布 "%>团 购</td>
        </tr>
       
          <tr class="tdbg">
            <td class="lefttd" height="30" width="110" align="right"><strong>商品名称：</strong></td>
            <td>
                &nbsp;<input type="text" class="textbox" maxlength="255" name="Title" id="Title" value="<%=GetVal("Subject") %>"/>
                &nbsp;商品单位：<input type="text" class="textbox" maxlength="255" name="Unit" id="Unit" value="<%=GetVal("Unit") %>" style="text-align:center;width:30px;"/> <=
              <select name="SelectUnit" onchange="getUnit(this.value)">
                  <option value="">--快速选择--</option>
             
                 <%
                     #region 选择单位

                     using (DataTable dt = DataFactory.GetDataTable("select Distinct Top 10 Unit From KS_ProGroupBuy Group by unit"))
                     {
                         if (dt.Rows.Count > 0)
                         {
                             foreach (DataRow dr in dt.Rows)
                             {
                                 if (!string.IsNullOrEmpty(dr["unit"].ToString()))
                                 {
                                     Response.Write("<option value='" + dr["unit"].ToString() + "'>" + dr["unit"].ToString() + "</option>");
                                 }
                             }
                         }
                     }
                     #endregion
 %>  </select>  <input type="checkbox" name="EndTF" value="1" <%=GetVal("endtf")=="1"?" checked":"" %>/>已结束<br />
               <span class="tips">如: 今日原价3288<%=MyCache.GetCurrencyUnit%>的婚纱照1239<%=MyCache.GetCurrencyUnit%>限量火爆团购。</span> 
            </td>
          </tr>
        
          <tr class="tdbg">
                <td align="right" class="lefttd" height="30"><strong>商品分类：</strong></td>
                <td>
                 &nbsp;<select name="BigClassID" id="BigClassID" onchange="getClass()">
                      <option value="0">--选择团购分类--</option>
                     <%
                         using (DataTable dt = DataFactory.GetDataTable("select classid,classname,parentid from KS_ProGroupBuyClass where parentid=0 and islock=0 order by rootid,orders"))
                         {
                             if (dt.Rows.Count > 0)
                             {
                                 foreach (DataRow dr in dt.Rows)
                                 {
                                     if (GetVal("BigClassID") == dr["classid"].ToString())
                                     {
                                         Response.Write("<option value='" + dr["classid"].ToString() + "' selected>" + dr["classname"].ToString() + "</option>");
                                     }else
                                     {
                                         Response.Write("<option value='" + dr["classid"].ToString() + "'>" + dr["classname"].ToString() + "</option>");
                                     }
                                 }
                             }
                         }
                          %>
                       </select> 
                <select name="ClassID" id="ClassID">
                 <option value="0">--选择小类--</option>
                </select>   
                </td>
            </tr>
            <tr class="tdbg">
                 <td align="right" class="lefttd">
                     <strong>封面大图片：</strong></td>
                 <td class="righttd" style="height: 30px; width: 487px;">
                 &nbsp;<input type="text" class="textbox" id="BigPhoto" name="BigPhoto" value="<%=GetVal("BigPhoto") %>">
          &nbsp;<input type="button" class="button" onclick="OpenThenSetValue('/plus/Include/SelectFile.aspx?ChannelID=4',550,290,window,jQuery('#BigPhoto')[0]);"  value="选择图片" />

          <iframe src="/plus/include/UpLoad.aspx?IsPic=1&FieldID=BigPhoto&ChannelID=4" marginheight="0" marginwidth="0"  width="100%" height="30" frameborder="0" scrolling="no"></iframe>

                 </td>
             </tr>
            <tr class="tdbg">
                 <td align="right" class="lefttd">
                     <strong>封面小图片：</strong></td>
                 <td class="righttd">
                 &nbsp;<input type="text" class="textbox" id="PhotoUrl" name="PhotoUrl" value="<%=GetVal("PhotoUrl") %>" />
          &nbsp;<input type="button" class="button" onclick="OpenThenSetValue('/plus/Include/SelectFile.aspx?ChannelID=4',550,290,window,jQuery('#PhotoUrl')[0]);" value="选择图片" />
                    <iframe src="/plus/include/UpLoad.aspx?IsPic=1&FieldID=PhotoUrl&ChannelID=4" marginheight="0" marginwidth="0"  width="100%" height="30" frameborder="0" scrolling="no"></iframe>

                 </td>
             </tr>
            <tr class="tdbg">
                <td align="right" class="lefttd" height="30">
                 <strong>团购时间限制：</strong>
                </td>
                <td>
                 <script>   isHour = 1;</script>
                 &nbsp;<input type="text" class="textbox Wdate" ID="BeginTime" value="<%=GetVal("BeginDate") %>" name="BeginTime" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'});"> 至 <input type="text" class="textbox Wdate" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'});" ID="EndDate" name="EndDate" value="<%=GetVal("EndDate") %>">
                </td>
            </tr>
           <tr class="tdbg">
                 <td align="right" class="lefttd">
                   <strong>地区设置：</strong></td>
                 <td class="righttd" style="height: 30px">
                 
                     <%
                         #region 选择省份
                         if (MyCache.GetCacheShopConfig(17) == "1")
                         {
                             Response.Write(@"<select name=""ProvinceID"" id=""ProvinceID"" onchange=""getCity()"">
                     <option value=""0"">--选择省份--</option>");
                             using (DataTable dt = MyCache.GetAreaTable())
                             {
                                 if (dt.Rows.Count > 0)
                                 {
                                     DataView dv = dt.DefaultView;
                                     dv.RowFilter = "parentid=0";
                                     DataTable dtt = dv.ToTable();
                                     foreach (DataRow dr in dtt.Rows)
                                     {
                                         if (GetVal("provinceid") == dr["id"].ToString()) {
                                             Response.Write("<option value='" + dr["id"].ToString() + "' selected>" + dr["city"].ToString() + "</option>");
                                          }else
                                         {
Response.Write("<option value='" + dr["id"].ToString() + "'>" + dr["city"].ToString() + "</option>");
                                         }

                                     }
                                 }
                             }
                             Response.Write(@"  </select> <select name=""CityID"" id=""CityID"">
                   <option value=""0"">--选择城市--</option>
                  </select>");
                         }
                         
                         #endregion
 %> 百度地图坐标：<input type="text" name="MapMarker" ID="MapMarker" class="textbox" value="<%=GetVal("MapMarker") %>" maxlength="100" />
                     &nbsp;</td>
             </tr>
     <tr>
                <td align="right" class="lefttd" height="30">
                 <strong>消费方式：</strong>
                </td>
                <td class="righttd">
                    <input type="radio" name="ShowDelivery" value="1" onclick="showYf(1);"<%=GetVal("ShowDelivery")=="1"||string.IsNullOrEmpty(GetVal("ShowDelivery"))?" checked":"" %>/>实物（需要送货）
                    <input type="radio" name="ShowDelivery" value="0" onclick="showYf(0);" <%=GetVal("ShowDelivery")=="0"?" checked":"" %>/>凭验证码消费
                   
                    <div id="yf" style="border:1px solid #999999;background-color:#f1f1f1;padding:2px;">
                        <input type="radio" value="0" name="FreightType"<%if (FreightType == 0) Response.Write(" checked"); %>/>
                        包邮
                        <br />
                        <input type="radio" value="1" name="FreightType" <%if (FreightType == 1) Response.Write(" checked"); %>/>
                        运费 <input type="text" name="Freight" value="12" class="textbox" style="width:60px;text-align:center" /><%=MyCache.GetCurrencyUnit%>
                      <span style="display:none"><input type="checkbox" name="ShowPayMent" value="1" <%=GetVal("ShowPayMent")=="1"||string.IsNullOrEmpty(GetVal("ShowPayMent"))?" checked":"" %>/>显示支付方式</span>

                    </div>
                </td>
            </tr>

           <tr class="tdbg">
                 <td align="right" class="lefttd">
                     <strong>价格设置：</strong></td>
                 <td class="righttd" style="height: 30px">
                 原价：<input type="text" value="<%= string.IsNullOrEmpty(GetVal("Price_Original"))?"100":Public.ReturnShopPrice(GetVal("Price_Original")) %>" onKeyPress= "return regInput(this,/^\d*\.?\d{0,2}$/,String.fromCharCode(event.keyCode))" onpaste="return regInput(this,/^\d*\.?\d{0,2}$/,window.clipboardData.getData('Text'))" ondrop="return regInput(this,    /^\d*\.?\d{0,2}$/,event.dataTransfer.getData('Text'))" class="textbox" ID="Price_Original" name="Price_Original" style="width:60px;text-align:center"><%=MyCache.GetCurrencyUnit%>
                 折扣：<input type="text" value="<%= string.IsNullOrEmpty(GetVal("Discount"))?"1":GetVal("Discount") %>" onKeyPress= "return regInput(this,/^\d*\.?\d{0,2}$/,String.fromCharCode(event.keyCode))" onpaste="return regInput(this,/^\d*\.?\d{0,2}$/,window.clipboardData.getData('Text'))" ondrop="return regInput(this,    /^\d*\.?\d{0,2}$/,event.dataTransfer.getData('Text'))" onChange="getprice(this.value);"  class="textbox" id="Discount" name="Discount" style="width:30px;text-align:center">折
                 团购价：<input type="text" value="<%= string.IsNullOrEmpty(GetVal("Price"))?"10":Public.ReturnShopPrice(GetVal("Price")) %>" onKeyPress= "return regInput(this,/^\d*\.?\d{0,2}$/,String.fromCharCode(event.keyCode))" onpaste="return regInput(this,/^\d*\.?\d{0,2}$/,window.clipboardData.getData('Text'))" ondrop="return regInput(this,    /^\d*\.?\d{0,2}$/,event.dataTransfer.getData('Text'))" class="textbox" ID="Price"  name="Price" style="width:60px;text-align:center"><%=MyCache.GetCurrencyUnit%>
                 库存：<input type="text" class="textbox" id="Amount" value="<%= string.IsNullOrEmpty(GetVal("Amount"))?"1000":GetVal("Amount") %>" name="Amount" style="width:50px;text-align:center">件
                 库存报警：<input type="text" value="<%= string.IsNullOrEmpty(GetVal("AmountNum"))?"0":GetVal("AmountNum") %>" class="textbox" id="AmountNum" name="AmountNum" style="width:50px;text-align:center">件 <span class="tips">为“0”不报警。</span>
                  </td>
             </tr>
             <tr class="tdbg">
                 <td align="right" class="lefttd">
                     <strong>购买设置：</strong></td>
                 <td class="righttd">
                 最低人数：<input type="text" value="<%=Utils.StrToInt(GetVal("minnum")) %>" class="textbox" ID="MinNum" name="MinNum"  style="width:50px;text-align:center">人
                 每人限制购买：<input type="text" value="<%=Utils.StrToInt(GetVal("minnum")) %>" class="textbox" ID="LimitBuyNum" name="LimitBuyNum"  style="width:50px;text-align:center">件
                 <span class="tips">不限制请输入0。</span>
                 初始已销售：<input type="text" value="<%=Utils.StrToInt(GetVal("minnum")) %>" class="textbox" ID="TxtHasSellNum"  style="width:50px;text-align:center">件
                 <span class="tips">作弊用的。</span>
                  </td>
             </tr>
           
            <tr class="tdbg">
                <td align="right" class="lefttd" >
                 <strong>本单详情：</strong>
                </td>
                <td class="righttd">
                    <textarea name="Intro" id="Intro" style="width:600px;height:200px" ><%=GetVal("Intro") %></textarea>
                    <%
                        Kesion.APPCode.EditorAPI.EchoEditor("editor", "Intro", "Basic", 0, false, true, true,false);    
                    %>
                
                </td>
           </tr>

            <tr class="tdbg">
                <td align="right" class="lefttd">
                 <strong>精彩卖点：</strong>
                </td>
                <td class="righttd">
                     <textarea name="Highlights" id="Highlights" style="width:600px;height:200px" ><%=GetVal("Highlights") %></textarea>
                    <%
                       Kesion.APPCode.EditorAPI.EchoEditor("Highlights", "Highlights", "Basic", 0, false, true,true,false);    
                    %>

                 <div class="tips">Tips：简要介绍商品的卖点,可以留空。</div>
                </td>
            </tr>
            <tr class="tdbg">
                <td align="right" class="lefttd">
                 <strong>团购保障：</strong>
                </td>
                <td class="righttd">
                     <textarea name="Protection" id="Protection" style="width:600px;height:200px" ><%=GetVal("Protection") %></textarea>
                     <%
                         Kesion.APPCode.EditorAPI.EchoEditor("Protection", "Protection", "Basic", 0, false, true, true,false);    
                    %>
                </td>
            </tr>
            <tr class="tdbg">
                <td align="right" class="lefttd">
                 <strong>温馨提示：</strong>
                </td>
                <td class="righttd">
                     <textarea name="Notes" id="Notes" style="width:600px;height:200px" ><%=GetVal("Notes") %></textarea>
                     <%
                         Kesion.APPCode.EditorAPI.EchoEditor("Notes", "Notes", "Basic", 0, false, true, true,false);    
                    %>
                   
                </td>
            </tr>
        </table>

        <div style="text-align:center;">
          <div class="cz_btn" align="center" style="padding-bottom:10px;"><span><input type="submit" ID="BtnSubmit" onclick="return(CheckForm());" class="button" value="确定发布" /></span>
        </div>
        </form>
        <script>
             var classId=<%=smallClassID %>;
             var cityId=<%=cityId %>;
             function getClass() {
                                var parentId = jQuery("#BigClassID option:selected").val();
                                jQuery.ajax({
                                    type: "POST",
                                    url: "/plus/Ajaxs.ashx",
                                    data: "classid="+classId+"&parentid=" + parentId + "&a=groupbuyclassoption",
                                    success: function(data) {
                                        jQuery("#ClassID").empty().append('<option value="0">--选择小类--</option>').append(data);
                                    }
                                });
             }
             function getCity(){
                                var provinceId = jQuery("#ProvinceID option:selected").val();
                                jQuery.ajax({
                                    type: "POST",
                                    url: "/plus/Ajaxs.ashx",
                                    data: "cityId="+cityId+"&provinceId=" + provinceId + "&a=groupbuycityoption",
                                    success: function(data) {
                                        jQuery("#CityID").empty().append('<option value="0">--选择城市--</option>').append(data);
                                    }
                                });
             }
            function showYf(v) {
                if (v == "1") {
                    jQuery("#yf").show();
                } else {
                    jQuery("#yf").hide();
                }
            }

            jQuery(document).ready(function() {
                <%if (Id!=0){%>
                   getClass();
                   getCity();
                   showYf();
                <%}%>
            });
            function regInput(obj, reg, inputStr) {
                var docSel = document.selection.createRange()
                if (docSel.parentElement().tagName != "INPUT") return false
                oSel = docSel.duplicate()
                oSel.text = ""
                var srcRange = obj.createTextRange()
                oSel.setEndPoint("StartToStart", srcRange)
                var str = oSel.text + inputStr + srcRange.text.substr(oSel.text.length)
                return reg.test(str)
            }
            function getprice(discount) {
                if (parseFloat(discount) > 10) {
                    alert('折扣不能大于10！');
                    jQuery("#Discount").val(10);
                    return false;
                }
                var Price_Original = jQuery("#Price_Original").val();
                if (Price_Original == '' || isNaN(Price_Original)) { Price_Original = 0; }
                jQuery("#Price").val(Math.round(Price_Original * (discount / 10)));
   
            }

            function getUnit(v) {
                jQuery("#Unit").val(v);
            }
            function CheckForm() {
           
                if (jQuery("#Title").val() == '') {
                    KesionJS.Alert("请输入团购商品名称！", 'jQuery("#Title").focus()');
                    return false;
                }
                if (jQuery("#ClassID option:selected").val() == '0') {
                    KesionJS.Alert("请选择团购分类！", 'jQuery("#ClassID").focus()');
                    return false;
                }
                if (jQuery("#BigPhoto").val() == '') {
                    KesionJS.Alert("请上传团购封面大图！", 'jQuery("#BigPhoto").focus()');
                    return false;
                }
                if (jQuery("#PhotoUrl").val() == '') {
                    KesionJS.Alert("请上传团购封面小图！", 'jQuery("#PhotoUrl").focus()');
                    return false;
                }
                if (jQuery("#Price_Original").val() == '') {
                    KesionJS.Alert("请输入商品原价！", 'jQuery("#Price_Original").focus()');
                    return false;
                }
                if (jQuery("#Discount").val() == '') {
                    KesionJS.Alert("请输入商品折扣！", 'jQuery("#Discount").focus()');
                    return false;
                }
                if (parseFloat(jQuery("#Discount").val()) > 10) {
                    KesionJS.Alert("折扣不能大于10！", 'jQuery("#Discount").focus()');
                    return false;
                }
                if (jQuery("#Price").val() == '') {
                    KesionJS.Alert("请输入团购价！", 'jQuery("#Price").focus()');
                    return false;
                }
               //jQuery("#aspnetForm").attr("action","MyGroupBuy.aspx");
                return true;
            }
        </script>


<%} %>
</div>