﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.Components" %>
<%@ Import Namespace="Kesion.APPCode" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="Kesion.HtmlTags" %>
<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="System.Xml" %>
<script runat="server" type="text/C#">

    dynamic __user = HttpContext.Current.Items["user"];                //初始化用户信息
    bool isLoadPage = true;  //定义页面是否加载

    string action = string.Empty;
    int recordcount, pagecount;
    int CurrPage = new BasicField().GetCurrPage;
    int PageSize = 10;
    int id = 0;
    public static DataRow dr = null;

    protected void Page_Load(object sender, EventArgs e)
    {
        id = Utils.StrToInt(KSCMS.S("id"));
        action = KSCMS.S("action").ToLower();
        if (action == "dosave")
        {
            isLoadPage = false;
            DoSave();
            return;
        }else if (action == "doconfirmsave")
        {
            isLoadPage = false;
            DoConfirmSave();
            return;
        }

    }

    private void DoConfirmSave()
    {
        #region 凭单消费

        using (DataTable dtt = DataFactory.GetDataTable("select top 1 * From KS_ProOrder Where ID=" + id))
        {
            if (dtt.Rows.Count > 0)
            {
                DataRow dr = dtt.Rows[0];

                int times = Utils.StrToInt(KSCMS.S("Times"));
                string verifyCode = KSCMS.S("VerifyCode");
                string remark = KSCMS.S("Remark");



                if (string.IsNullOrEmpty(verifyCode))
                {
                    Msg.Alert("请输入消费验证码！");
                    return;
                }
                if (verifyCode.ToLower() != dr["verifycode"].ToString())
                {
                    Msg.Alert("输入的消费验证码不正确，请重输！");
                    return;
                }
                if (times <= 0)
                {
                    Msg.AlertDoFun("消费次数已用完！", "history.back()");
                    return;
                }


                using (DataTable dt = DataFactory.GetDataTable("select top 1 num,infoid from KS_ProOrderItem Where OrderID='" + dr["OrderID"].ToString() + "'"))
                {
                    if (dt.Rows.Count > 0)
                    {
                        DataRow drr = dt.Rows[0];
                        int hasTimes = Utils.StrToInt(DataFactory.GetOnlyValue("select sum(times) from KS_ProGroupBuyConsumer where infoid=" + drr["infoid"].ToString() + " and orderid='" + dr["orderid"].ToString() + "'"));
                        int kyTimes = Utils.StrToInt(drr["num"].ToString()) - hasTimes;
                        if (times > kyTimes)
                        {
                            Msg.Alert("对不起，消费次数超过了。该订单剩余" + kyTimes + "的消费次数!");
                            return;
                        }

                    }
                    else
                    {
                        Msg.Alert("对不起，找不到订单！", "history.back()");
                        return;
                    }
                }



                Hashtable ht = new Hashtable();
                ht.Add("infoid", Utils.StrToInt(KSCMS.S("infoId")));
                ht.Add("AddDate", DateTime.Now);
                ht.Add("OrderID", dr["orderid"].ToString());
                ht.Add("UserName", (new TemporaryVar()).UserName);
                ht.Add("Remark", remark);
                ht.Add("Times", times);
                ht.Add("Mobile", dr["mobile"].ToString());

                CommonData.Insert("KS_ProGroupBuyConsumer", ht);

                ht.Clear();
                ht.Add("IsBusinessConfirm", 1);
                CommonData.Update("KS_ProOrder", ht, "where orderid='" + dr["orderid"].ToString() + "'");

                #region 产生订单记录,记录确认消费
                ht.Clear();
                ht.Add("UserName", new TemporaryVar().UserName);
                ht.Add("Inputer", new TemporaryVar().UserName);
                ht.Add("AddDate", DateTime.Now);
                ht.Add("Remark", Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/orderlog/step4/item2")); //提交订单
                Kesion.APPCode.OrderProcess.InsertOrderLog(dr["orderid"].ToString(), 4, ht);
                #endregion

            }
        }
        Msg.AlertDoFun("恭喜，成功录入消费信息!", "top.location.href='" + BasicField.GetUserUrl("shop/mygroupbuyorder") + "';");



        #endregion
    }
    /// <summary>
    /// 发货
    /// </summary>
    private void DoSave()
    {
        #region 发货
        string expressOrderId = KSCMS.S("ExpressOrderID");
        string handlerName = KSCMS.S("AdminName");
        string remark = KSCMS.S("Remark");
        if (string.IsNullOrEmpty(expressOrderId))
        {
            Msg.Alert("请输入发货快递单号!");
            return;
        }
        if (string.IsNullOrEmpty(handlerName))
        {
            Msg.Alert("请输入经手人!");
            return;
        }
        if (string.IsNullOrEmpty(remark))
        {
            Msg.Alert("请输入备注说明!");
            return;
        }
        string DeliverDate = KSCMS.S("DeliverDate");
        DateTime dd = DateTime.Now;
        try
        {
            dd = Convert.ToDateTime(DeliverDate);
        }
        catch
        {
            dd = DateTime.Now;
        }



        Hashtable ht = new Hashtable();
        ht.Add("orderId", KSCMS.S("orderid"));
        ht.Add("ClientName", KSCMS.S("realname"));
        ht.Add("UserName", KSCMS.S("username"));
        ht.Add("Inputer", __user.UserName);
        ht.Add("HandlerName", handlerName);
        ht.Add("DeliverDate", dd);
        ht.Add("DeliverType", 1);
        ht.Add("ExpressCorpId", Utils.StrToInt(KSCMS.S("DeliveryCorpId")));
        ht.Add("ExpressNumber", expressOrderId);
        ht.Add("Remark", remark);
        ht.Add("Status", 1);
        CommonData.Insert("[KS_ProLogDeliver]", ht);
        ht = new Hashtable();
        ht.Add("DeliverStatus", 1);

        if (!string.IsNullOrEmpty(KSCMS.S("Alipaytradeno"))){
            ht.Add("alipaytradestatus", "WAIT_BUYER_CONFIRM_GOODS");
        }

        CommonData.Update("KS_ProOrder", ht, "where id=" + id);

        //以下要放于更新状态后
        string DeliveryCorpName = DataFactory.GetOnlyValue("select top 1 CorpName  from  KS_ProDeliveryCorp  where Corpid=" + Utils.StrToInt(KSCMS.S("DeliveryCorpId")));

        using (DataTable dtt = DataFactory.GetDataTable("select top 1 * From KS_ProOrder Where ID=" + id))
        {
            if (dtt.Rows.Count > 0)
            {
                DataRow dr = dtt.Rows[0];


                #region 支付宝订单状态改变
                int PaymentPlatId = Utils.StrToInt(dr["PaymentPlatId"].ToString());
                if (!string.IsNullOrEmpty(KSCMS.S("Alipaytradeno")) && PaymentPlatId != 0)
                {
                    //支付宝交易号，支付宝根据商户请求，创建订单生成的支付宝交易号。
                    string trade_no = KSCMS.S("Alipaytradeno").Trim();


                    //物流公司名称，物流公司名称
                    string logistics_name = DeliveryCorpName.Trim();


                    //物流发货单号
                    string invoice_no = expressOrderId.Trim();


                    //物流发货时的运输类型，三个值可选：POST（平邮）、EXPRESS（快递）、EMS（EMS）
                    string transport_type = "EXPRESS";
                    //建议与创建交易时选择的运输类型一致

                    ////////////////////////////////////////////////////////////////////////////////////////////////

                    //把请求参数打包成数组
                    SortedDictionary<string, string> sParaTemp = new SortedDictionary<string, string>();
                    sParaTemp.Add("trade_no", trade_no);
                    sParaTemp.Add("logistics_name", logistics_name);
                    sParaTemp.Add("invoice_no", invoice_no);
                    sParaTemp.Add("transport_type", transport_type);

                    //请在这里加上商户的业务逻辑程序代码

                    //——请根据您的业务逻辑来编写程序（以下代码仅作参考）——

                    //获取支付宝的通知返回参数，可参考技术文档中页面跳转同步通知参数列表

                    //构造确认发货接口，无需修改

                    PlatFormInfo payPlatform = PlatForm.GetPlatFormById(PaymentPlatId);
                    string PayOnlineKey = payPlatform.Md5Key;
                    string partner = string.Empty;
                    if (PayOnlineKey.IndexOf("|") > 0)
                    {
                        string[] ArrMD5Key = PayOnlineKey.Split(new char[] { '|' });
                        PayOnlineKey = ArrMD5Key[0];
                        partner = ArrMD5Key[1];
                    }

                    AlipayService ali = new AlipayService(partner, PayOnlineKey);
                    XmlDocument xmlDoc = ali.Send_goods_confirm_by_platform(sParaTemp);
                    StringBuilder sbxml = new StringBuilder();
                    string nodeIs_success = xmlDoc.SelectSingleNode("/alipay/is_success").InnerText;
                    if (nodeIs_success != "T")//请求不成功的错误信息
                    {
                        sbxml.Append("错误：" + xmlDoc.SelectSingleNode("/alipay/error").InnerText);
                    }
                    else//请求成功的支付返回宝处理结果信息
                    {

                        sbxml.Append(xmlDoc.SelectSingleNode("/alipay/response").InnerText);
                    }


                }
            }
            //Response.Write(sbxml.ToString());

            //——请根据您的业务逻辑来编写程序（以上代码仅作参考）——
        }
        #endregion



        int sendMailTf = 0;
        int sendMessage = 0;
        int sendMobile = 0;

        sendMessage = Utils.StrToInt(KSCMS.S("SendMessageToUser"));
        sendMailTf =  Utils.StrToInt(KSCMS.S("SendMailToUser"));
        sendMobile =  Utils.StrToInt(KSCMS.S("SendMobileToUser"));
        string mailTemplate = string.Empty;
        string msg = string.Empty;
        if (sendMailTf == 1 || sendMessage == 1)
        {
            mailTemplate = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(MyCache.GetCacheConfig(0)+"config/shopmail.config"), "//mailtemplate/type[@name='shipping']");
            mailTemplate = Utils.ReplaceString(mailTemplate, "{$Express}",DeliveryCorpName, true);
            mailTemplate = Utils.ReplaceString(mailTemplate, "{$ExpressNo}", expressOrderId, true);
            Kesion.APPCode.OrderProcess.ReplaceOrderLabel(ref mailTemplate,dr);

            string sendToMail = Kesion.APPCode.OrderProcess.Email;
            if (sendMailTf == 1 && Utils.IsValidEmail(sendToMail))
            {

                string mailResult = EmailService.SendMailMsg(MyCache.GetCacheConfig(23), MyCache.GetCacheConfig(24), MyCache.GetCacheConfig(8), sendToMail, "在[" + MyCache.GetCacheConfig(1) + "]订单号为" + dr["OrderID"].ToString() + "发货通知！", mailTemplate, MyCache.GetCacheConfig(25), Utils.StrToInt(MyCache.GetCacheConfig(26)), 3);
                if (mailResult == "success")
                {
                    msg = "<br/>成功向[" + sendToMail + "]发送了一封发货通知邮件!";
                }
                else
                {
                    msg = "<br/>向邮箱[" + sendToMail + "]发送失败！失败原因" + mailResult;
                }

            }
            if (sendMessage == 1 && dr["IsAnonymous"].ToString() == "0")
            {
                Kesion.APPCode.OrderProcess.sendMail("订单[" + dr["orderid"].ToString() + "]发货通知！", dr["userName"].ToString(), mailTemplate);
                msg += "<br/>已向用户[" + dr["username"].ToString() + "]发了站内消息！";
            }

        }


        //发送手机短信
        string mobile = dr["mobile"].ToString();
        if (sendMobile == 1 && !string.IsNullOrEmpty(mobile))
        {
            mailTemplate = Kesion.XML.XmlObject.ReadXmlReturnNode(Utils.GetMapPath(MyCache.GetCacheConfig(0) + "config/shopsms.config"), "//smstemplate/type[@name='shipping']");
            mailTemplate = Utils.ReplaceString(mailTemplate, "{$Express}", DeliveryCorpName, true);
            mailTemplate = Utils.ReplaceString(mailTemplate, "{$ExpressNo}", expressOrderId, true);

            Kesion.APPCode.OrderProcess.ReplaceOrderLabel(ref mailTemplate, dr);

            string templateId = string.Empty;
            XmlDocument docXml = new XmlDocument();
            docXml.Load(Utils.GetMapPath(MyCache.GetCacheConfig(0) + "config/shopsms.config"));
            if (docXml != null)
            {
                templateId = docXml.SelectSingleNode("//smstemplate/type[@name='shipping']").SelectSingleNode("@templateid").InnerText;
            }
            string json = "{\"Express\":\"" + DeliveryCorpName + "\",\"SiteName\":\"" + MyCache.GetCacheConfig(1) + "\",\"ExpressNo\":\"" + expressOrderId + "\",\"TemplateId\":\"" + templateId + "\"}";

            string rstr = SMSAPI.SendMsg(mobile, mailTemplate, json);
            if (rstr == "true")
            {
                msg += "<br/>已向手机号[" + mobile + "]发送了手机短信通知已发货！";
            }
            else
            {
                msg += "<br/>向手机号[" + mobile + "]发送了手机短信通知失败！";
            }
        }

        #region 产生订单记录发货成功
        ht.Clear();
        ht.Add("UserName", Kesion.APPCode.ShoppingCartUser.UserName);
        ht.Add("Inputer", handlerName);
        ht.Add("AddDate", DateTime.Now);
        ht.Add("Remark", Utils.GetLanguageNode("//language/node[@name='modelview']/shopmodel/orderlog/step3")); //订单发货成功
        Kesion.APPCode.OrderProcess.InsertOrderLog(dr["orderId"].ToString(), 3, ht);
        #endregion

        Msg.AlertDoFun(string.Format("恭喜，发货成功!{0}", msg), "top.location.href='"+BasicField.GetUserUrl("shop/ShowMyOrder","id-" + id + @",from-business")+"';");

        #endregion

    }

    public static string GetOrderStatus(string OrderID,int ConsumptionMode,int IsBusinessConfirm,string alipaytradestatus, int status, int DeliverStatus, decimal moneyReceive, decimal totalOrderMoney)
    {

        return Kesion.APPCode.OrderProcess.GetOrderStatus(true, 1, OrderID, ConsumptionMode, IsBusinessConfirm,alipaytradestatus, status, DeliverStatus, moneyReceive, totalOrderMoney);

    }
    public static string getArrtibute(string attributecart, int attrid)
    {
        return Kesion.APPCode.ShopCls.getArrtibute(attributecart, attrid);

    }
    public static string GetTitle(string title, string fileName, string turnUrl, int channelId, int classId, int infoId, string attributeCart,int attrId)
    {
        string str = string.Empty;
        str = "<span><a target='_blank' href='"+ BaseFun.GetRewriteUrl("groupbuyview", infoId)+"'>"+title+"</a></span>";

        return str;
    }

</script>
<%
    if (!isLoadPage) return;
%>
<div class="r_tybox nomar">
<%if (string.IsNullOrEmpty(action))
    { %>
<style>
.border .wait,.border .wff,.border .wfk,.border .wxf{color:red;}
.border .yff,.border .yfq,.border .yqs,.border .confirm{color:green;}
.border .yxf {
color:#999; }
.border .wx{color:#999;}
.border .jq{color:#888;}
.border .tk{color:Purple}
.border .ddff{color:brown;}
.border .list_link{line-height:22px;border-left:1px solid #efefef;padding:5px;}
.border .img img{border:1px solid #ccc;padding:1px;}
</style>
	<div class="tabs">	
			<ul>
				<li<%if (string.IsNullOrEmpty(KSCMS.S("show"))) Response.Write(" class='puton'"); %>><a href="<%=BasicField.GetUserUrl("shop/mygroupbuyorder") %>">近一个月的订单(<%=DataFactory.GetOnlyValue("select count(1) From KS_ProOrder Where datediff(month,[InputTime],getdate())=0 and Business='" + (new TemporaryVar()).UserName + "'")  %>)</a></li>
				<li<%if (KSCMS.S("show") == "2") Response.Write(" class='puton'"); %>><a href="<%=BasicField.GetUserUrl("shop/mygroupbuyorder", "show-2") %>">三个月内的订单(<%=DataFactory.GetOnlyValue("select count(1) From KS_ProOrder Where datediff(month,[InputTime],getdate())<=2 and Business='" + (new TemporaryVar()).UserName + "'")  %>)</a></li>
				<li<%if (KSCMS.S("show") == "-1") Response.Write(" class='puton'"); %>><a href="<%=BasicField.GetUserUrl("shop/mygroupbuyorder", "show--1") %>">所有的订单(<%=DataFactory.GetOnlyValue("select count(1) From KS_ProOrder Where Business='" + (new TemporaryVar()).UserName + "'")  %>)</a></li>
			</ul>
	</div>

	<div class="r_padbox">

        <div class="message">
            <div style="padding:20px">订单搜索：
                <form name="myform" action="{$GetCurrUrl}" method="post" id="myform">
                    <select name="drptj" ID="DrpTJ">
                        <option Value="1"<%=KSCMS.S("drptj") == "1" ? " selected" : "" %>>订单号</option>
                        <option Value="2"<%=KSCMS.S("drptj") == "2" ? " selected" : "" %>>手机号码</option>
                    </select>
                    关键字：<input type="text" name="TxtKey" ID="TxtKey" class="textbox" value="<%=KSCMS.S("TxtKey") %>"/>
                    <input type="submit" value="搜索订单" class="button"/>
                </form>
            </div>
        </div>
          <table width="98%" align="center" border="0" class="border">
              <tr class="title">
               <td height="25" width="40" nowrap><b>序号</b></td>
               <td style="width:500px;text-align:left">&nbsp;&nbsp;<b>商品</b></td>
               <td width="80" align="center"><b>单价</b></td>
               <td width="80" align="center"><b>数量</b></td>
               <td width="70" align="center"><b>实付</b></td>
               <td width="70" align="center" nowrap><b>状态</b></td>
               <td width="70" align="center" nowrap><b>操作</b></td>
              </tr>
           <%
               string sqlParam = string.Empty;
               sqlParam = "KS_ProOrder Where Business='" + (new TemporaryVar()).UserName + "'";
               int show = Utils.StrToInt(KSCMS.S("show"));
               if (show != -1)
               {
                   sqlParam += " and datediff(month,[InputTime],getdate())<= " + show;
               }
               string Key = KSCMS.S("TxtKey");
               if (!string.IsNullOrEmpty(Key))
               {
                   switch (Utils.StrToInt(KSCMS.S("DrpTJ")))
                   {
                       case 1:
                           sqlParam += " and OrderID='" + Utils.ChkSQL(Key) + "'";
                           break;
                       case 2:
                           sqlParam += " and mobile='" + Utils.ChkSQL(Key) + "'";
                           break;
                   }
               }

               using (DataTable dt = DataFactory.GetPage("*", sqlParam, "id", "order by ID desc", CurrPage, PageSize, out recordcount, out pagecount))
               {
                   if (dt.Rows.Count > 0)
                   {
                       int i = 0;
                       foreach (DataRow dr in dt.Rows)
                       {
                           %>
                           <TR class="title1">
				             <td colspan="7" style="padding-top:2px;padding-bottom:2px;padding-left:10px;">
				             <strong>
				            <%=i + 1 + (CurrPage - 1) * PageSize%>、 订单编号：<%=dr["orderid"].ToString()%>&nbsp;&nbsp;下单时间：<%=Utils.FormatHumanizedTime(Convert.ToDateTime(dr["InputTime"].ToString())) %></strong><%=Convert.ToInt16(dr["ordertype"].ToString()) == 1 ? "<span style='color:Red'>团购</span>" : string.Empty%><%=Convert.ToInt32(dr["changescore"].ToString()) > 0 ? " <span style='color:green'>"+MyCache.GetCacheConfig(90)+"兑换</span>" : string.Empty%></td>
			            </TR>
			            <tr>
			            <tr class="tdbg">
                          <td class="list_link" align="center" width="25"></td>
			              <td  colspan="3" align="left">

                                  <%
                                      string strSQL = string.Empty;
                                      strSQL = "select top 100 0 as channelid,i.photourl as defaultpic,i.subject as title, i.classid,0 as filename,0 as turnurl,0 as AttributeCart,o.* from KS_ProOrderItem o left join KS_ProGroupBuy I on i.id=o.infoid where o.Orderid='" + Utils.ChkSQL(dr["orderid"].ToString()) + "' order by o.itemid";


                                      using (DataTable dtt = DataFactory.GetDataTable(strSQL))
                                      {
                                          if (dtt.Rows.Count > 0)
                                          {
                                              foreach (DataRow drr in dtt.Rows)
                                              {
                                                  %>
                               <table width="100%" class="table1" cellpadding="0" cellspacing="0" border="0">
                           <tr class="TR_BG_list">
                              <td class="splittd" align="left" style="width:500px">
                                <table border='0' width="100%" cellpadding="0" cellspacing="0">
		                           <tr>
			                        <td width="60" height="70" align="center" class="img"><img onerror="this.src='<%=MyCache.GetCacheShopConfig(9) %>';" src='<%=drr["DefaultPic"].ToString() %>' width='50' height='50' align='left'/></td>
			                        <td>
                                     <%=GetTitle(Convert.ToString(drr["title"].ToString()), Convert.ToString(drr["fileName"].ToString()), Convert.ToString(drr["TurnUrl"].ToString()), Utils.StrToInt(drr["channelid"].ToString()), Utils.StrToInt(drr["classid"].ToString()), Utils.StrToInt(drr["infoid"].ToString()), Convert.ToString(drr["attributeCart"].ToString()), Utils.StrToInt(drr["attrid"].ToString()))%>			            
		                           </td>
		                          </tr>
		                         </table>
                              </td>
                              <td class="splittd" style="width:80px;"><%=MyCache.GetCurrencySymbol%><%=Public.ReturnShopPrice(drr["Price"].ToString()) %></td>
                              <td class="splittd" style="width:80px;text-align:center"><%#Eval("num") %></td>
                            </table> 
                                                  <%
                                                              }

                                                          }
                                                      }
                               %>


                         </td>
                         <td class="list_link" style="text-align:center" valign="top">
                          <%=Utils.StrToInt(dr["ChangeScore"].ToString()) > 0 ? "" + dr["ChangeScore"].ToString() + "分+" : string.Empty%>
                          <%=MyCache.GetCurrencySymbol%><%=Public.ReturnShopPrice(Convert.ToString(dr["OrderTotalPrice"].ToString()))%></td>
                         <td class="list_link" style="text-align:center" nowrap valign="top">
                         <%=GetOrderStatus(Convert.ToString(dr["orderid"].ToString()), Utils.StrToInt(dr["ConsumptionMode"].ToString()), Utils.StrToInt(dr["IsBusinessConfirm"].ToString()), Convert.ToString(dr["alipaytradestatus"].ToString()), Utils.StrToInt(dr["status"].ToString()), Convert.ToInt16(dr["DeliverStatus"].ToString()), Utils.StrToDecimal(Convert.ToString(dr["MoneyReceipt"].ToString())), Utils.StrToDecimal(Convert.ToString(dr["OrderTotalPrice"].ToString())))%>
                         </td>
				            <td nowrap class="list_link" style="text-align:center" valign="top">
				            <a href="<%=BasicField.GetUserUrl("shop/showmyorder", "id-" + dr["id"].ToString() + ",from-business") %>">订单详情</a>
				
				            <%=dr["ConsumptionMode"].ToString() == "0" ? @"<br/><a href='javascript:;' onclick=""location.href='" + BasicField.GetUserUrl("shop/MyGroupBuyOrder", "id-" + dr["id"].ToString() + ",action-GroupBuyConfirm") + @"';"">查看/确认消费</a>" : ""%>
				            <%=dr["Status"].ToString() != "2" && dr["ConsumptionMode"].ToString() == "1" && dr["PayStatus"].ToString() == "1" && dr["DeliverStatus"].ToString() == "0" ? @"<br/><a href='javascript:;' onclick=""location.href='" + BasicField.GetUserUrl("shop/MyGroupBuyOrder", "action-BusinessDelivery,id-" + dr["id"].ToString()) + @"';"">发货</a>" : ""%>
                             <%=!string.IsNullOrEmpty(MyCache.GetShopCommonConfig(42)) && dr["ConsumptionMode"].ToString() == "1" && dr["DeliverStatus"].ToString() != "0" ? "<br/><a href='" + BasicField.GetUserUrl("shop/showmyorder", "action-ExpressLog,OrderID-" + dr["orderid"].ToString()) + "'>查看物流</a>" : string.Empty %>

				            </td>

                         </tr>
                          <%
                                      i++;
                                  }
                              }
                              else
                              {
                       %>
               <tr class="tdbg">
                <td class="splittd" style="text-align:center" colspan="7">
                  还没有任何的订单！
                </td>
               </tr> 
                       <%

                               }
                           }
            %>
         
           </table>

		<%
            #region 分页
            string PageStr = "[KS:PageStr3]";
            BasicField.ReplaceFilterPage(ref PageStr, CurrPage, PageSize, pagecount, recordcount);
            KSCMS.W(PageStr);
            #endregion
                 %>
        
            </div>
        <%}
    else if (action == "businessdelivery")  //发货
    {
        isLoadPage = false;
        using (DataTable dtt = DataFactory.GetDataTable("select top 1 * From KS_ProOrder Where ID=" + id))
        {
            if (dtt.Rows.Count > 0)
            {
                dr = dtt.Rows[0];

                if (dr["paystatus"].ToString() != "1")
                {
                    Msg.Alert("该订单未付款，不能发货!", KSCMS.GetComeUrl());
                    return;

                }
                else if (dr["DeliverStatus"].ToString() == "1")
                {
                    Msg.Alert("该订单已发货!", KSCMS.GetComeUrl());
                    return;
                }


         %>
    <iframe src="about:blank" name="hidframe" id="hidframe" style="display:none"></iframe>
          <form name="myform" action="{$GetCurrUrl}" method="post" id="myform" target="hidframe">
       <input type="hidden" name="action" value="dosave"/>
                        <input type="hidden" name="orderid" value="<%=dr["orderid"].ToString() %>" />
          <input type="hidden" name="RealName" value="<%=dr["RealName"].ToString() %>" />
          <input type="hidden" name="alipaytradeno" value="<%=dr["alipaytradeno"].ToString() %>" />

<table class="border"  width="99%" align="center" border=0>
    <tr class="title" align=middle>
      <td colSpan=2 height=35><B>订单[<%=dr["orderid"].ToString() %>]发货处理</B>
      </td>
    </tr>
    <tr class="tdbg">
      <td align=right class="lefttd">客户姓名：</td>
      <td><%=dr["RealName"].ToString() %></td>
    </tr>
    <tr class="tdbg">
      <td align=right class="lefttd">用户名：</td>
      <td><%=dr["UserName"].ToString() %></td>
    </tr>
    <tr class="tdbg">
      <td align=right class="lefttd" >订单金额：</td>
      <td>
             <span style="font-weight:bold;font-size:16px;color:brown"><%=MyCache.GetCurrencySymbol %><%=Utils.StrToFloat(dr["orderTotalPrice"].ToString()).ToString("F2") %></span> <%=MyCache.GetCurrencyUnit %>   已付款： <%=MyCache.GetCurrencySymbol %><span style="font-weight:bold;font-size:16px;color:green"><%=Utils.StrToFloat(dr["moneyReceipt"].ToString()).ToString("F2") %></span> <%=MyCache.GetCurrencyUnit %></td>
      </td>
    </tr>
    <tr class="tdbg">
      <td align=right  class="lefttd" >收货信息：</td>
      <td>
      收货地址：<%=string.Concat(MyCache.GetAreaName(Convert.ToInt32(dr["provinceid"].ToString()), "city"), MyCache.GetAreaName(Convert.ToInt32(dr["cityid"].ToString()), "city"), MyCache.GetAreaName(Convert.ToInt32(dr["countyid"].ToString()), "city"), dr["address"].ToString()) %>（收 货 人：<%=dr["RealName"].ToString() %>
      &nbsp;&nbsp;联系电话：<%=dr["tel"].ToString() %> <%=dr["mobile"].ToString() %>
      &nbsp;&nbsp;邮政编码：<%=dr["zipcode"].ToString() %>）
      
      </td>
    </tr>
    <%  if (!string.IsNullOrEmpty(dr["alipaytradeno"].ToString()) && (dr["PaymentPlatId"].ToString() == "9" || dr["PaymentPlatId"].ToString() == "12"))
        { %>
    <tr class="tdbg" id="alipay">
      <td class="lefttd"  align=right>支付宝交易号：</td>
      <td><%=dr["alipaytradeno"].ToString() %>
      <br /><span style='font-weight:Bold;color:green'>本单采用支付宝担保交易,发货操作同时改变支付宝订单状态。</span></td>
    </tr>
    <%} %>
    
    <tr class="tdbg">
      <td class="lefttd" align=right>发货日期：</td>
      <td>
          <input type="text"  class="textbox" id="DeliverDate" name="DeliverDate" value="<%=DateTime.Now.ToString() %>">
          <span class="tips">格式:YYYY-MM-DD hh:mm:ss</span></td>
    </tr>
    <tr class="tdbg">
      <td class="lefttd"  align=right>快递公司：</td>
      <td>
         <select name="DeliveryCorpId" id="DeliveryCorpId">
             <%
                 using (DataTable dt = DataFactory.GetDataTable("Select CorpId,CorpName From KS_ProDeliveryCorp Order By OrderId,corpId"))
                 {
                     foreach (DataRow drr in dt.Rows)
                     {
                         Response.Write("<option value='" + drr[0].ToString() + "'>" + drr[1].ToString() + "</option>");
                     }
                 }
                  %>
         </select>
      </td>
    </tr>
    <tr class="tdbg">
      <td class="lefttd"  align=right>快递单号：</td>
      <td>
      <input type="tel" name="ExpressOrderID" id="ExpressOrderID" class="textbox" />
    </tr>
    <tr class="tdbg">
      <td class="lefttd" align=right>经手人：</td>
      <td>
          <input type="text" name="AdminName" readonly value="<%=!string.IsNullOrEmpty(UserManage.GetUserInfo().RealName) ? UserManage.GetUserInfo().RealName : new TemporaryVar().UserName %>" class="textbox" />
    </tr>
    <tr class="tdbg">
      <td class="lefttd" align=right>备注：</td>
      <td>
      <input type="text" value="订单号：<%=dr["OrderID"].ToString()%>的货物已送出!"  class="textbox" ID="Remark" name="Remark"/>
    </tr>
    
    <tr class="tdbg">
      <td class="lefttd" align=right>通知会员：</td>
      <td>
      <input type="checkbox" name="SendMessageToUser" value="1" checked />同时使用站内短信通知会员已经发货<br />
      <input type="checkbox" name="SendMailToUser" value="1" checked />同时发送邮件通知会员已经发货
            <%
                if (MyCache.GetCacheConfig(32) == "1")
                {
      %>
     <br /> <input type="checkbox" name="SendMobileToUser" value="1" checked />同时发送手机短信通知会员已经发货</td>
      <%} %>
      
      </td>
    </tr>

    <tr class="tdbg" align="middle">
      <td colSpan="2" height="50">
      <input type="submit" name="BtnSave" value="确定发货" class="button"  />
 &nbsp;
        <Input class=button onclick="history.back();" type=button value=取消返回 name=Submit></td>
    </tr>
  </table>
    </form>
 <%}
         }
     }
     else if (action.Equals("groupbuyconfirm"))  //确认消费
     {
         isLoadPage = false;
         using (DataTable dtto = DataFactory.GetDataTable("select top 1 * From KS_ProOrder Where ID=" + id))
         {
             if (dtto.Rows.Count > 0)
             {

                 DataRow dr = dtto.Rows[0];
                 DataRow drr = null;
                 int times = 0;
                 int hasTimes = 0;
                 int kyTimes = 0;

                 if (float.Parse(dr["moneyreceipt"].ToString()) < float.Parse(dr["ordertotalprice"].ToString()))
                 {

                     Msg.AlertDoFun("该订单未支付，不能消费！", "history.back()");
                     return;
                 }
                 using (DataTable dt = DataFactory.GetDataTable("select top 1 num,infoid from KS_ProOrderItem Where OrderID='" + dr["OrderID"].ToString() + "'"))
                 {
                     if (dt.Rows.Count > 0)
                     {
                         drr = dt.Rows[0];

                         times = Utils.StrToInt(drr["num"].ToString());
                         hasTimes = Utils.StrToInt(DataFactory.GetOnlyValue("select sum(times) from KS_ProGroupBuyConsumer where infoid=" + drr["infoid"].ToString() + " and orderid='" + dr["orderid"].ToString() + "'"));
                         kyTimes = times - hasTimes;
                     }
                     else
                     {
                         Msg.AlertDoFun("对不起，找不到订单！", "history.back()");
                         return;
                     }
                 }

                 if (kyTimes > 0)
                 {    %>
        <iframe src="about:blank" name="hidframe" id="hidframe" style="display:none"></iframe>
          <form name="myform" action="{$GetCurrUrl}" method="post" id="myform" target="hidframes">
       <input type="hidden" name="action" value="doconfirmsave"/>
       <input type="hidden" name="infoid" value="<%=drr["infoid"].ToString() %>"/>
    <table class="border" width="99%" align="center" border=0>
    <tr class="Title" align=middle>
      <td colSpan=2 height=25><B>团购单消费确认</B></td>
    </tr>
    <tr class=tdbg>
      <td align=right width="15%"  height="30" class="lefttd">团购商品名称：</td>
      <td>

          <%
              if (DataFactory.Exists("KS_ProGroupBuy", "id=" + drr["infoid"].ToString()))
              {
                  Response.Write(DataFactory.GetOnlyValue("select top 1 subject from KS_ProGroupBuy Where ID=" + drr["infoid"].ToString()));
              }
              else
              {
                  Response.Write("商品已删除");
              }
           %>

      </td>
        
    </tr>
    <tr class=tdbg>
      <td align=right width="15%"  height="30" class="lefttd">订单号：</td>
      <td><%=dr["orderid"].ToString() %></td>
        
    </tr>
    <tr class=tdbg>
      <td align=right width="15%" height="30" class="lefttd">手机号码：</td>
      <td><%=dr["mobile"].ToString() %></td>
        
    </tr>
    <tr class=tdbg>
      <td align=right width="15%"  class="lefttd">验证码：</td>
      <td>
          <input type="text" name="VerifyCode" id="VerifyCode" class="textbox" />
          <span class="tips">请输入消费者提供的验证码。</span>
      </td>
    </tr>
    <tr class=tdbg>
      <td align=right width="15%"  class="lefttd" height="30">消费：</td>
      <td>
         可用次数<span style="color:red"><%=kyTimes %></span>次
          <input type="hidden" name="times" value="<%=kyTimes %>" />
          本次消费
          <%
              for (int i = 1; i <= kyTimes; i++)
              {
                  Response.Write("<option value='" + i.ToString() + "'>" + i.ToString() + "</option>");
              }
           %>
          次

      </td>
    </tr>
    <tr class=tdbg>
      <td align=right width="15%"  class="lefttd">备注：</td>
      <td>
          <textarea name="Remark" id="Remark" class="textbox" style="width:400px;height:50px;">消费</textarea>
      </td>
    </tr>

    <tr class=tdbg align=middle>
      <td colSpan=2 height=30>
      <input type="submit" ID="BtnSave" value="确定消费" class="button"  />
 &nbsp;
        <Input class="button" onclick="history.back();" type=button value=取消返回 name=Submit></td>
    </tr>
  </table>
  </form>
    <%} %>

     <div style="margin:15px"><B>订单[<span style="color:Red"><%=dr["orderid"].ToString() %></span>]的消费明细表</B>
        购买<span style="color:Red"><%=times %></span>次，已消费<span style="color:green"><%=hasTimes %></span>次。
         <input type="hidden" name="times" id="times" value="<%=times %>" />
    </div>

            <table class="border" cellSpacing=1 cellPadding=2 width="99%" align="center" border=0>
                <tr align="center" class="title">
        	    <td align="center">消费时间</td>
               <td  align="center">订单号</td>
        	    <td  align="center">手机号</td>
        	    <td align="center">录入</td>
                <td align="center" width="110">消费次数</td>
	            <td align="center">备注</td>
              </tr>

          <%
              using (DataTable dtt = DataFactory.GetDataTable("select * from KS_ProGroupBuyConsumer Where OrderID='" + dr["orderid"].ToString() + "' and infoid=" + drr["infoid"].ToString()))
              {
                  if (dtt.Rows.Count > 0)
                  {
                      foreach (DataRow drr1 in dtt.Rows)
                      {
                          %>
                <tr class="tdbg">
              <td class="splittd" align="center"><%=drr1["Adddate"].ToString() %> </td>
              <td class="splittd" align="center"><%=drr1["orderid"].ToString() %> </td>
              <td class="splittd">   <%=drr1["mobile"].ToString() %> </td>
              <td class="splittd" align="center"><%=drr1["username"].ToString() %> </td>
              <td class="splittd" align="center"><%=drr1["times"].ToString() %> 次</td>
              <td class="splittd" style="width:180px;word-break:break-all">
            <%=drr1["remark"].ToString() %> </td>
           </tr>     
                           <%
                                   }

                               }
                               else
                               {
                      %>
                 <tr class="tdbg">
                <td class="splittd" style="text-align:center" colspan="7">
                  还没有消费明细记录!
                </td>
               </tr> 
                <%
                        }
                    }
             %>
           

            
            </table>
       

    <div style="text-align:center;margin:20px;">
        <input type="button" class="button" value=" 返回 " onclick="location.href = '<%=BasicField.GetUserUrl("shop/MyGroupBuyOrder")%>';" />

    </div>
    <%}
            }
        }
        %>
</div>