﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="Kesion.Config" %>
<%@ Import Namespace="Kesion.Components" %>
<%@ Import Namespace="Kesion.HtmlTags" %>
<%@ Import Namespace="System.Data" %>
<script runat="server" type="text/C#">
    dynamic __user = UserManage.GetUserInfo();                //初始化用户信息，
    private static dynamic __info = new System.Dynamic.ExpandoObject();   //初始化当前页信息
    bool isLoadPage = true;  //定义页面是否加载

    private string action = string.Empty;
    private int Id = 0;

    int recordcount, pagecount;
    int CurrPage = new BasicField().GetCurrPage;
    int PageSize = 10;

    protected void Page_Load(object sender, EventArgs e)
    {
        action = KSCMS.S("action");
        if (string.IsNullOrEmpty(action))
        {
            action = KSCMS.S("do");
        }
        Id = Utils.StrToInt(BasicField.GetParam("id"));
        if (Id == 0)
        {
            Id = Utils.StrToInt(KSCMS.S("id"));
        }
        action = action.ToLower();
        switch (action)
        {
            case "write":
                #region 修改
                Modify();
                break;
            #endregion
            case "dosave":  //保存博文
                DoSave();
                return;
            case "doclasssave": //保存专栏
                DoClassSave();
                return;
            case "del":  //删除博文
                Hashtable ht = new Hashtable();
                ht.Add("BlogID", Id);
                ht.Add("userid", __user.UserID);
                if (CommonData.Delete("KS_BlogInfo", ht))
                {

                    using (DataTable dt = DataFactory.GetDataTable("select FileName,ID from KS_UploadFiles where (ChannelID=100011 or ChannelID=199999) and InfoId = " + Id))
                    {
                        if (dt.Rows.Count > 0)
                        {
                            foreach (DataRow dr in dt.Rows)
                            {
                                Function.DelFile(dr["FileName"].ToString());
                                Hashtable ht2 = new Hashtable();
                                ht2.Add("ID", dr["ID"].ToString());
                                CommonData.Delete("KS_UploadFiles", ht2);
                            }
                        }
                    }

                    Msg.Alert("删除成功！", KSCMS.GetComeUrl());
                }
                else
                {
                    Msg.Alert("删除失败！", KSCMS.GetComeUrl());
                }
                return;
            case "delclass": //删除专栏目
                ht = new Hashtable();
                ht.Add("ClassID", Id);
                ht.Add("userid", __user.UserID);
                if (CommonData.Delete("KS_UserBlogClass", ht))
                {
                    Msg.Alert("删除成功！", KSCMS.GetComeUrl());
                }
                else
                {
                    Msg.Alert("删除失败！", KSCMS.GetComeUrl());
                }
                return;
            default:
                Initial();
                break;
        }



    }
    private void Initial()
    {
        __info.ClassID = "0";
        __info.TypeID = "0";
        __info.Title = "";
        __info.Content = "";
        __info.Tags = "";
        __info.PassWord = "";
        __info.AddDate = DateTime.Now.ToString();

        if (action == "addclass" && Id > 0)
        {
            using(DataTable dt=DataFactory.GetDataTable("select top 1 * From KS_UserBlogClass Where ClassId="+Id+" and UserID=" + __user.UserID))
            {
                if (dt.Rows.Count > 0)
                {
                    DataRow dr = dt.Rows[0];
                    __info.ClassName = dr["classname"].ToString();
                    __info.OrderID = dr["orderid"].ToString(); ;
                    __info.Descript = dr["descript"].ToString();
                }else
                {
                    __info.ClassName = "";
                    __info.OrderID = "1";
                    __info.Descript = "";
                }
            }
        }
        else
        {
            __info.ClassName = "";
            __info.OrderID = "1";
            __info.Descript = "";
        }

    }
    /// <summary>
    /// 初始化修改博文
    /// </summary>
    private void Modify()
    {
        if (Id > 0)
        {
            using (DataTable dt = DataFactory.GetDataTable("select top 1 * from KS_BlogInfo where UserName='" + UserManage.GetUserInfo().UserName + "' and BlogID = " + Id))
            {
                if (dt.Rows.Count > 0)
                {
                    DataRow dr = dt.Rows[0];
                    __info.ClassID = dr["ClassID"].ToString();
                    __info.TypeID = dr["TypeID"].ToString();
                    __info.Title = dr["Title"].ToString();
                    __info.Content = dr["Contents"].ToString();
                    __info.Tags = dr["Tags"].ToString();
                    __info.PassWord = dr["PassWord"].ToString();
                    __info.AddDate = dr["adddate"].ToString();
                }else
                {
                    Msg.Alert("出错！");
                    isLoadPage = false;
                    return;
                }

            }
        }else
        {
            Initial();
        }
    }
    /// <summary>
    /// 保存博文
    /// </summary>
    private void DoSave()
    {

        BlogConfigInfo __configinfo = BlogConfigManage.Deserialize(Server.MapPath("~/config/Blog.config"));
        int score = 0, myscore = UserManage.GetUserInfo().Score;
        if (int.TryParse(__configinfo.BlogArticleCredits, out score))
        {
            if (myscore < score && score>0)
            {
                Msg.Alert("积分不够，还需要" + (score - myscore) + "个积分才能创建日志。");
                return;
            }
        }
        else
        {
            Msg.Alert("空间参数配置错误！");
            return;
        }


        string Title = Utils.RemoveXss(KSCMS.S("title"));
        string addTime = KSCMS.S("adddate");
        if (!Utils.IsDateTime(addTime)) addTime = DateTime.Now.ToString();
        string tags = Utils.RemoveXss(KSCMS.S("Tags"));
        string content = KSCMS.S("Content");

        string password = Utils.RemoveXss(KSCMS.S("PassWord"));

        int blogClass = Utils.StrToInt(KSCMS.S("ClassID"));
        int userBlogClass = Utils.StrToInt(KSCMS.S("TypeID"));


        if (blogClass == 0)
        {
            Msg.Alert("请选择博文分类！");
            return;
        }

        if (string.IsNullOrEmpty(Title))
        {
            Msg.Alert("请填写博文标题！");
            return;
        }
        else if (content == "")
        {
            Msg.Alert("请填写博文内容！");
            return;
        }


        Hashtable ht = new Hashtable();
        ht.Add("UserID", UserManage.GetUserInfo().UserID);
        ht.Add("UserName", (new TemporaryVar()).UserName);

        ht.Add("TypeID", userBlogClass);
        ht.Add("ClassID", blogClass);
        ht.Add("Title",Title);
        ht.Add("Tags", tags);
        ht.Add("Contents", content);
        ht.Add("PassWord", password);
        ht.Add("Hit", 0);
        ht.Add("AddDate", addTime);

        ht.Add("Best", 0);
        ht.Add("Toplist", 0);
        ht.Add("TotalPut", 0);


        if (Id>0)
        {
            if (CommonData.Update("KS_BlogInfo", ht, "where UserID="+__user.UserID+" and BlogID = " + Id))
            {
                Kesion.APPCode.Public.ClearInvalidAffix(content, Utils.StrToInt(KSCMS.S("classid")));

                #region 关联上传文件
                string tempContent = UtilsQueryParam.Get("", 0);
                Kesion.APPCode.Public.FileAssociation(100011, Id, tempContent, 1);
                #endregion

                Msg.Alert("恭喜，博文修改成功！", BasicField.GetUserSpaceUrl("space/UserBlog"));
            }
            else
            {
                Msg.Alert("更新失败，请重试...", BasicField.GetUserSpaceUrl("space/UserBlog"));
            }


        }
        else
        {

            ht.Add("Status", __configinfo.BlogArticleEnCheck);
            if (CommonData.Insert("KS_BlogInfo", ht))
            {
                int blogid = 0;
                using (DataTable dt = DataFactory.GetDataTable("select MAX(blogid) as id from ks_bloginfo where userid = " + __user.UserID))
                {
                    if (dt.Rows.Count > 0)
                    {
                        blogid = Utils.StrToInt(dt.Rows[0]["id"].ToString());
                    }
                }
                Kesion.APPCode.Public.ClearInvalidAffix(content, blogid);
                #region 关联上传文件
                string tempContent = UtilsQueryParam.Get("", 0);
                Kesion.APPCode.Public.FileAssociation(100011, blogid, tempContent, 0);
                #endregion
                Msg.Confirm("恭喜，博文发布成功，继续发布吗？", "top.location.href='"+BasicField.GetUserSpaceUrl("space/userblog","do-write")+"';", "top.location.href='"+BasicField.GetUserSpaceUrl("space/userblog")+"';");
            }
            else
            {
                Msg.Alert("更新失败，请重试...", BasicField.GetUserSpaceUrl("space/UserBlog"));
            }
        }




    }
    /// <summary>
    /// 保存专栏目
    /// </summary>
    private void DoClassSave()
    {
        string className = Utils.RemoveXss(KSCMS.S("ClassName"));
        string descript = Utils.RemoveXss(KSCMS.S("Descript"));
        int orderID = Utils.StrToInt(KSCMS.S("OrderID"));


        if (className == "")
        {
            Msg.Alert("栏目名称不能为空！");
            return;
        }
        else if (descript == "")
        {
            Msg.Alert("栏目介绍不能为空！");
            return;

        }

        Hashtable ht = new Hashtable();
        ht.Add("ClassName", className);
        ht.Add("Descript", descript);
        ht.Add("OrderID", orderID);

        if (DataFactory.Exists("KS_UserBlogClass", "ClassID <> " + Id+" and ClassName = '" + Utils.ChkSQL(className) + "' and UserID ="+__user.UserID ))
        {
            Msg.Alert("栏目中名称已存在！");
            return;
        }
        else
        {

            if (Id>0)
            {
                if (CommonData.Update("KS_UserBlogClass", ht, "where UserID="+__user.UserID+" and ClassID=" +Id))
                {
                    Msg.Alert("修改成功！", BasicField.GetUserSpaceUrl("space/UserBlog","do-addClass"));
                    return;
                }
                else
                {
                    Msg.AlertDoFun("修改失败！", KSCMS.GetComeUrl());
                    return;
                }
            }
            else
            {
                ht.Add("AddDate", DateTime.Now);
                ht.Add("UserID",__user.UserID);
                ht.Add("UserName", __user.UserName);

                if (CommonData.Insert("KS_UserBlogClass", ht))
                {
                    Msg.Alert("添加成功！", BasicField.GetUserSpaceUrl("space/UserBlog","do-addClass"));
                }
                else
                {
                    Msg.AlertDoFun("添加失败！", BasicField.GetUserSpaceUrl("space/UserBlog","do-addClass"));
                }
            }

        }

    }

</script>

<%
    if (!isLoadPage) return;
%>

<div class="r_tybox nomar">
    	

     <%if (string.IsNullOrEmpty(action)){ %>
    
           <div class="tabs">
            <ul>
            <li<%=BasicField.GetParam("showType")==""?" class='puton'":string.Empty %>><a href="<%=BasicField.GetUserSpaceUrl("space/userblog") %>"><span>所有记录</span></a></li>
            <li<%=BasicField.GetParam("showType")=="1"?" class='puton'":string.Empty %>><a href="<%=BasicField.GetUserSpaceUrl("space/userblog","showtype-1") %>"><span>未审核的记录</span></a></li>
            <li<%=BasicField.GetParam("showType")=="2"?" class='puton'":string.Empty %>><a href="<%=BasicField.GetUserSpaceUrl("space/userblog","showtype-2") %>"><span>已审核的记录</span></a></li>
            </ul>
        </div>
        <div class="r_padbox">
        <div class="clear"></div>
        <div style="display:none" class="padnav">
            <span><a class="button"  href="<%=BasicField.GetUserSpaceUrl("space/userblog","do-write") %>" >写博文</a></span>
          
            <span><a  class="button" href="<%=BasicField.GetUserSpaceUrl("space/userblog","do-addclass") %>">增加专栏分类</a></span>
        </div>

     

            <table class="border" cellspacing="0" align="Center" border="0" id="ctl00_KSContent_List" style="width:100%;border-collapse:collapse;">
				<tr class="title">
					<th scope="col"  style="width:60px;">编号</th><th align="center" scope="col">标题</th><th scope="col">状态</th><th scope="col">分类</th><th scope="col">↓管理操作</th>
				</tr>
        <%

            string param = "";
            if (!string.IsNullOrEmpty(BasicField.GetParam("showtype")))
            {
                param = " and status=" + (Utils.StrToInt(BasicField.GetParam("showtype")) - 1);
            }

            using (DataTable dt = DataFactory.GetPage("*,KS_BlogInfo.ClassID,ClassName", "KS_BlogInfo inner join KS_BlogClass on KS_BlogInfo.ClassID = KS_BlogClass.ClassID  and UserID = " + UserManage.GetUserInfo().UserID+ " "+param , "BlogID",  "  order by BlogID desc", CurrPage, PageSize, out recordcount, out pagecount))
            {
                if (dt.Rows.Count > 0)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        KSCMS.W(string.Format(@"<tr class=""tdbg""><td class=""splittd"" align=""center"">{0}</td>", dr["blogid"].ToString()));
                        KSCMS.W(string.Format(@"<td class=""splittd""><a href=""{0}"" target=""_blank"" title=""{1}"">{1}</a><br/><span style=""color:#999"">时间：{2}</span></td>", BasicField.GetBlogArticleUrl(Utils.StrToInt(dr["BlogID"].ToString()),dr["userid"].ToString()),dr["title"].ToString(),dr["addDate"].ToString()));
                        KSCMS.W(string.Format(@"<td class=""splittd"" style=""text-align:center"">{0}</td>", dr["status"].ToString() == "1" ? "已审核" : "<span style='color:red'>未审核</span>"));
                        KSCMS.W(string.Format(@"<td class=""splittd"" style=""text-align:center"">{0}</td>", dr["classname"].ToString()));

                        KSCMS.W(@"<td class=""splittd"" style=""text-align:center"">");
                        KSCMS.W("<a href='" + BasicField.GetUserSpaceUrl("space/userBlog", "do-write,id-" + dr["blogid"].ToString()) + "'>修改</a>");
                        KSCMS.W(@" <a onclick=""return(confirm('确认删除吗？'))"" href='" + BasicField.GetUserSpaceUrl("space/userBlog", "do-del,id-" + dr["blogid"].ToString()) + "'>删除</a>");
                        KSCMS.W("</td>");
                        KSCMS.W("</tr>");
                    }
                }else
                {
                    KSCMS.W(@"<tr class=""emptycss"">
				<td colspan=""5"">您还没有写博文!</td>
			</tr>");
                }

            }

         %>
        </table>
        <div class="ty_center">
        <%
            #region 分页
            string PageStr = "[KS:PageStr2]";
            BasicField.ReplaceFilterPage(ref PageStr, CurrPage, PageSize, pagecount, recordcount);
            KSCMS.W(PageStr);
            #endregion
         %>
</div>
</div>    
    </div>
<%}else if (action=="write") { %>
 <!--写博文 begin-->

 <% Kesion.APPCode.EditorAPI.EchoHead();
     
          BlogConfigInfo  __configinfo = BlogConfigManage.Deserialize(Server.MapPath("~/config/Blog.config"));
     %>

	<div class="r_tybox nomar">
    	

        <div class="r_padbox nopadtop">
        
                     <script type="text/javascript">
                         function CheckForm() {
                             if (jQuery("#ClassID").val() == '0') {
                                 KesionJS.Alert('请选择博文分类!', 'jQuery("#ClassID").focus()');
                                 return false
                             }
        
                             if (jQuery("#Title").val() == '') {
                                 KesionJS.Alert('请填写博文标题!', 'jQuery("#Title").focus()');
                                 return false
                             }
        
                             return true;
                         }
                         function insertHTMLToEditor(codeStr) {
                             editor.execCommand('insertHtml', codeStr);
                         }
                         function GetKeyTags() {
                             var text = escape(jQuery("#Title").val());
                             if (text != '') {
                                 jQuery("#Tags").val('请稍等,系统正在自动获取tags...').attr("disabled", true);
                                 jQuery.get("/plus/ajaxs.ashx", { a: "GetTags", text: text },
                                   function (data) { jQuery("#Tags").val(unescape(data)).attr("disabled", false); });
                             } else { KesionJS.Alert('对不起,请先输入标题!', "jQuery('#Titls').focus();"); }
                         }
            </script>
     
        <form name="myform" action="<%=BasicField.GetUserUrl("space/userblog") %>" method="post" id="myform" >
        <input type="hidden" name="action" value="dosave"/>

              <table  cellspacing="1" cellpadding="3" class="border" width="100%" align="center" border="0" style="table-layout:fixed">
                    <tr class="tdbg">
                    <td  class="lefttd" style="width:120px;">博文分类：</td>
                    <td style="text-align:left">
                        <select name="ClassID" id="ClassID">
                            <option value="0">-请选择博文分类-</option>
                        <%
                            using (DataTable dt = DataFactory.GetDataTable("select * from KS_BlogClass order by OrderID asc"))
                            {
                                foreach (DataRow dr in dt.Rows)
                                {
                                    KSCMS.W(string.Format("<option value='{0}'{2}>{1}</option>", dr["classid"].ToString(), dr["className"].ToString(), __info.ClassID == dr["classId"].ToString() ? " selected" : string.Empty));
                                }
                            }
                         %>
                            </select>
                        <span style="color: red">*</span></td>
                    </tr>
                    <tr class="tdbg">
                    <td  class="lefttd">用户专栏：</td>
                    <td style="text-align:left">
                         <select name="TypeID" id="TypeID">
                            <option value="0">-请选择自定义分类-</option>
                        <%
                            using (DataTable dt = DataFactory.GetDataTable("select * from KS_UserBlogClass Where UserID="+__user.UserID+" order by OrderID asc"))
                            {
                                foreach (DataRow dr in dt.Rows)
                                {
                                    KSCMS.W(string.Format("<option value='{0}'{2}>{1}</option>", dr["classid"].ToString(), dr["className"].ToString(), __info.TypeID == dr["classId"].ToString() ? " selected" : string.Empty));
                                }
                            }
                         %>
                            </select>
                        <span class="tips">可选。</span></td>
                    </tr>
                                    
                      
                    <tr class="tdbg">
                    <td class="lefttd"> 博文标题：</td>
                    <td style="text-align:left"><input type="text" name="Title" id="Title" maxlength="255" class="textbox" value="<%=__info.Title %>"/>
                    <span style="color: red">* 
                        </span></td>
                    </tr>
        
                    <tr class="tdbg">
                    <td class="lefttd"> 博文日期：</td>
                    <td style="text-align:left"><input type="text" name="AddDate" id="AddDate" maxlength="255" class="textbox" value="<%=__info.AddDate %>"/>
                    <span style="color: red">* 
                        </span></td>
                    </tr>
        
                    <tr class="tdbg">
                    <td class="lefttd"> Tag标签：</td>
                    <td style="text-align:left"><input type="text" name="Tags" id="Tags" maxlength="255" class="textbox" value="<%=__info.Tags %>"/> &nbsp; <a href="javascript:;" onclick="GetKeyTags()">自动获取TAG</a><span class="tips">多个Tags请以空格分隔</span>
                    <span style="color: red">* 
                        </span></td>
                    </tr>
                    <tr class="tdbg">
                    <td class="lefttd">博文内容：</td>
                    <td style="text-align:left">
                        <textarea name="Content" id="Content" style="width:98%;height:300px" ><%=__info.Content %></textarea>
                        <%
                            Kesion.APPCode.EditorAPI.EchoEditor("editor", "Content", "Common", 0, false, true, true, false);    
                       %>
                          </td>
                    </tr>
        
                    <tr class="tdbg" <%=__configinfo.BlogArticleUploadFileSwitch == "1"?"":" style='display:none'" %>>
                    <td class="lefttd"> 上传附件：</td>
                    <td style="text-align:left; padding-left:0px">
                    <iframe id='upiframe' name='upiframe' src='/plus/include/UploadAttachment.aspx?ChannelID=19999' frameborder=0 scrolling=no width='620' height='24'></iframe>
                    </td>
                    </tr>
            
        
                    <tr class="tdbg">
                    <td class="lefttd"> 查看密码：</td>
                    <td style="text-align:left"><input type="text" name="PassWord" id="PassWord" maxlength="255" class="textbox" value="<%=__info.Tags %>"/><span class="tips">不设置密码留空</span>
                    <span style="color: red">
                        </span></td>
                    </tr>
                                  
                <tr class="tdbg">
                    <td class="lefttd" style="border-bottom:0px;">&nbsp;</td>
                    <td style="border-bottom:0px;">
                        <div class="cz_btn">
                        	<span><input type="submit" Onclick="return(CheckForm());" ID="Button2" class="button" value="OK!确定保存" /></span>
                            <span><input type="button" onclick="location.href = '<%=BasicField.GetUserSpaceUrl("space/userblog")%>    ';" class="button" value=" 返 回 " /></span>
                         </div>
                     </td>       
                </tr>
            </table>
	  </form>

        </div>
     </div>

 <!--写博文 end-->
<%}else if (action=="addclass") { %>
 <!--专栏 begin-->

<div class="r_tybox nomar">
    	
        <div class="r_padbox">
                
                            <script type="text/javascript">
                                function CheckForm1() {
                                    if (jQuery("#ClassName").val() == '') {
                                        KesionJS.Alert('请填写专栏名称!', 'jQuery("#ClassName").focus()');
                                        return false
                                    }
                                    if (!is_number(jQuery("#OrderID").val()) || jQuery("#OrderID").val() == '') {
                                        KesionJS.Alert('专栏序号请填写有数数字！', 'jQuery("#OrderID").focus()');
                                        return false;
                                    }
                                    if (jQuery("#Descript").val() == '') {
                                        KesionJS.Alert('请填写专栏描述！', 'jQuery("#Descript").focus()');
                                        return false;
                                    }
    
                                    return true;

                                }

                            </script>
                
        <form name="myform" action="<%=BasicField.GetUserUrl("space/userblog") %>" method="post" id="myforms" >
           <input type="hidden" name="action" value="doclasssave"/>

        <table  cellspacing="1" cellpadding="3" class="border" width="100%" align="center" border="0" style="table-layout:fixed">
                          <tr class="tdbg">
                            <td  class="lefttd" style="width:120px;">专栏名称：</td>
                            <td style="text-align:left">
                                <input type="text" name="ClassName" id="ClassName" maxlength="255" class="textbox" value="<%=__info.ClassName %>"/>
                                <span class="tips">分类的名称。</span><span style="color: red">*</span></td>
                          </tr>
              
                          <tr class="tdbg">
                            <td class="lefttd"> 专栏序号：</td>
                            <td style=" text-align:left">
                                 <input type="text" name="OrderID" id="OrderID" class="textbox" MaxLength="20" value="<%=__info.OrderID %>"/>
                               <span class="tips">排序数字。</span>
                            <span style="color: red">* </span></td>
                          </tr>
                          <tr class="tdbg">
                            <td class="lefttd">专栏描述：</td>
                            <td style="text-align:left"><textarea id="Descript" name="Descript" class="textbox" style="width:500px; height:80px; padding:10px"><%=__info.Descript %></textarea><span style="color: red; padding-left:10px;">*</span></td>
                          </tr>
                          
						<tr class="tdbg">
                            <td class="lefttd" height="40" style="border-bottom:0px">&nbsp;</td>
                            <td style="border-bottom:0px; text-align:left">
                                <div class="cz_btn">
                                	<span><input type="submit" Onclick="return(CheckForm1());" ID="Button1" class="button" value="OK!确定保存" /></span>
                               		<span><input type="button" onclick="location.href = '<%=BasicField.GetUserSpaceUrl("space/userblog")%>    ';" class="button" value=" 返 回 " /></span>
                             	</div>     
                            </td>      
                        </tr>
        </table>
        <div class="padtitle" style="margin-top:10px">已有的专栏列表</div>


            
            <table class="border" cellspacing="0" align="Center" border="0" id="Table1" style="width:99%;padding-left:1%>
				<tr class="title">
					<th scope="col"  style="width:60px;">编号</th><th align="center" scope="col">专栏名称</th><th scope="col">序号</th><th scope="col">↓管理操作</th>
				</tr>
        <%

            string param = "";
            if (!string.IsNullOrEmpty(BasicField.GetParam("showtype")))
            {
                param = " and status=" + (Utils.StrToInt(BasicField.GetParam("showtype")) - 1);
            }

            using (DataTable dt = DataFactory.GetPage("*", "KS_UserBlogClass where UserID = " + __user.UserID+ " "+param , "classID",  "  order by classID desc", CurrPage, PageSize, out recordcount, out pagecount))
            {
                if (dt.Rows.Count > 0)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        KSCMS.W(string.Format(@"<tr class=""tdbg""><td class=""splittd"" align=""center"">{0}</td>", dr["classid"].ToString()));
                        KSCMS.W(string.Format(@"<td class=""splittd"" style=""text-align:center"">{0}</td>", dr["classname"].ToString()));
                        KSCMS.W(string.Format(@"<td class=""splittd"" style=""text-align:center"">{0}</td>", dr["orderid"].ToString()));

                        KSCMS.W(@"<td class=""splittd"" style=""text-align:center"">");
                        KSCMS.W("<a href='" + BasicField.GetUserSpaceUrl("space/userblog", "do-addclass,id-" + dr["classid"].ToString()) + "'>修改</a>");
                        KSCMS.W(@" <a onclick=""return(confirm('确认删除吗？'))"" href='" + BasicField.GetUserSpaceUrl("space/userblog", "do-delclass,id-" + dr["classid"].ToString()) + "'>删除</a>");
                        KSCMS.W("</td>");
                        KSCMS.W("</tr>");
                    }
                }else
                {
                    KSCMS.W(@"<tr class=""emptycss"">
				<td colspan=""4"">没有找任何专栏列表!</td>
			</tr>");
                }

            }

         %>
        </table>
        <div class="ty_center">
        <%
            #region 分页
            string PageStr = "[KS:PageStr2]";
            BasicField.ReplaceFilterPage(ref PageStr, CurrPage, PageSize, pagecount, recordcount);
            KSCMS.W(PageStr);
            #endregion
         %>
</div>

      
		
        </div>
      </div>  

 <!--专栏 end-->

<%} %>
</div>