﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.Components" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="Kesion.HtmlTags" %>
<%@ Import Namespace="System.Data" %>

<script runat="server" type="text/C#">

    dynamic __user = HttpContext.Current.Items["user"];                //初始化用户信息
    public static DataRow dr = null;
    public int id = 0;
    public int DeliverStatus = 0;

    bool isLoadPage = true;  //定义页面是否加载

    protected void Page_Load(object sender, EventArgs e)
    {
        id = Utils.StrToInt(KSCMS.S("id"));

        if (id == 0)
        {
            isLoadPage = false;
            Msg.Alert("Error!");
            return;
        }


        DeliverStatus = Utils.StrToInt(KSCMS.S("DeliverStatus"));


        if (__user == null)
        {
            isLoadPage = false;
            Msg.Alert("出错，找不到订单!");
            return;
        }
        using (DataTable dt = DataFactory.GetDataTable("select top 1 * From KS_ProOrder Where UserName='" + __user.UserName + "' and ID=" + id))
        {
            if (dt.Rows.Count <= 0)
            {
                isLoadPage = false;
                Msg.AlertDoFun("对不起，该订单不是您的，不能填写快递单号！", "history.back()");
                return;
            }else{
			    dr=dt.Rows[0];
			}
        }
        if (KSCMS.S("do") == "dosave")
        {
            isLoadPage = false;
            DoSave();
            return;
        }
        else
        {
            initialDelivery();
        }


    }
    private void initialDelivery()
    {
        using (DataTable dt = DataFactory.GetDataTable("Select CorpId,CorpName From KS_ProDeliveryCorp Order By OrderId,corpId"))
        {
            foreach (DataRow dr in dt.Rows)
            {
                this.DrpDeliveryCorpId.Items.Add(new ListItem(dr[1].ToString(), dr[0].ToString()));
            }
        }

    }
    private void DoSave()
    {
        string ExpressOrderID = KSCMS.S("ExpressOrderID");
        if (Utils.StrToInt(dr["DeliverStatus"].ToString()) != 0)
        {
            if (string.IsNullOrEmpty(ExpressOrderID))
            {
                Msg.AlertDoFun("请输入快递单号！", "history.back()");
                return;
            }
        }
        string ClientName = dr["realname"].ToString();
        if (string.IsNullOrEmpty(ClientName)) ClientName = __user.RealName;
        Hashtable ht = new Hashtable();
        DateTime dtt= DateTime.Now;
        ht.Add("orderId", dr["orderid"].ToString());
        ht.Add("ClientName", ClientName);
        ht.Add("UserName", dr["username"].ToString());
        ht.Add("Inputer", __user.UserName);
        ht.Add("HandlerName", __user.UserName);
        ht.Add("DeliverDate",dtt);
        ht.Add("ExpressCorpId", Utils.StrToInt(KSCMS.S(DrpDeliveryCorpId.UniqueID)));
        ht.Add("ExpressNumber", ExpressOrderID);
        // ht.Add("Status", 0);
        if (DeliverStatus ==9)  //退货
        {
            ht.Add("Status", 12);
            //ht.Add("RemarkStr", "客户已经填写退货快递单号，未处理！"); //产生订单记录,申请退货退款
            ht.Add("Remark", "客户已在" + dtt + "填写退货快递单号,等待处理");
        }
        else if (DeliverStatus ==11) //换货
        {
            ht.Add("Status", 13);
            ht.Add("Remark", "客户已在" + dtt + "填写换货快递单号,等待处理");
            //ht.Add("RemarkStr", "客户已经填写换货快递单号，未处理！"); //产生订单记录,申请换货
        }


        CommonData.Insert("[KS_ProLogDeliver]", ht);

        int LogDeliverId = CommonData.GetMaxId("KS_ProLogDeliver", "ID");

        //CommonData.Update("KS_ProLogDeliver", ht, " where id="+Utils.StrToInt(KSCMS.S("handid"))+"");

        #region 产生订单记录,申请退货退款
        ht.Clear();
        ht.Add("UserName", new TemporaryVar().UserName);
        ht.Add("Inputer", "system");
        ht.Add("LogDeliverId", LogDeliverId);
        ht.Add("AddDate", DateTime.Now);
        if (DeliverStatus == 9)  //退货
        {
            ht.Add("Remark", "客户已寄回(退货)，等待确认处理！"); //产生订单记录,申请退货退款
        }
        else if (DeliverStatus == 11) //换货
        {
            ht.Add("Remark", "客户已寄回(换货)，等待确认处理！"); //产生订单记录,申请换货
        }
        Kesion.APPCode.OrderProcess.InsertOrderLog(dr["orderId"].ToString(), 7, ht, true);
        #endregion
        if (DeliverStatus == 9)  //退货
        {
            DataFactory.ExecuteNonQuery("UPDATE KS_ProOrder Set DeliverStatus=7 Where id=" + id);
        }
        else if (DeliverStatus == 11) //换货
        {
            DataFactory.ExecuteNonQuery("UPDATE KS_ProOrder Set DeliverStatus=8 Where id=" + id);
        }
        Msg.Alert("恭喜，提交成功,请等待处理!", BasicField.GetUserUrl("Shop/MyOrder"));
        return;

    }
</script>
<%
    if (!isLoadPage) return;
%>	<div class="t_tybox nomar">
<div class="tytitle"><h4>退货退款申请</h4></div>
      <form name="myform" action="{$GetCurrUrl}" method="post" id="myform">
       <input type="hidden" name="do" id="do" value="dosave"/>
            <table cellspacing="1" cellpadding="3" class="border" width="98%" align="center" border="0">
               
                <tr class="tdbg">
                    <td class="lefttd" align="right" style="width: 100px;">订单编号：</td>
                    <td><%=dr["orderid"].ToString() %>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td class="lefttd" align="right">订单费用：</td>
                    <td style="height: 30px">
                        <%=MyCache.GetCurrencySymbol%><%=Utils.StrToFloat(dr["NoUseCouponMoney"].ToString()).ToString("F2")%>  <%=MyCache.GetCurrencyUnit%>
         
          &nbsp;&nbsp;已 付 款：<span style="font-weight: bold; font-size: 16px; color: green"><%=MyCache.GetCurrencySymbol%><%=Utils.StrToFloat(dr["MoneyReceipt"].ToString()).ToString("f2") %></span> <%=MyCache.GetCurrencyUnit%>
                    </td>
                </tr>
                <tr class="tdbg" id="DeliveryCompany" runat="server">
                    <td class="lefttd" align="right">快递公司：</td>
                    <td>
                        <asp:DropDownList CssClass="select" ID="DrpDeliveryCorpId" runat="server"></asp:DropDownList>
                        快递单号：
                        <input type="text" class="textbox"  name="ExpressOrderID" ID="ExpressOrderID" Width="200px">
                    </td>
                </tr>
				<tr>
				<td colspan="2">
				  <div class="cz_btn" style="padding-left:165px;">
                    <span>
                        <input type="submit" class="button" value="确定保存" />

                    </span>
                    <span><input type="button" class="button" value=" 返 回 " onclick="history.back()"/></span>
                </div>
				</td>
			   </tr>
            </table>
          
</form><br /><br /></div>